/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.properties.annotations;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.internal.GeneratedSubclasses;
import org.gradle.api.problems.Severity;
import org.gradle.api.problems.internal.DocLink;
import org.gradle.api.problems.internal.GradleCoreProblemGroup;
import org.gradle.cache.internal.CrossBuildInMemoryCache;
import org.gradle.cache.internal.CrossBuildInMemoryCacheFactory;
import org.gradle.internal.deprecation.Documentation;
import org.gradle.internal.properties.annotations.MissingPropertyAnnotationHandler;
import org.gradle.internal.properties.annotations.PropertyAnnotationHandler;
import org.gradle.internal.properties.annotations.PropertyMetadata;
import org.gradle.internal.properties.annotations.PropertyTypeResolver;
import org.gradle.internal.properties.annotations.TypeAnnotationHandler;
import org.gradle.internal.properties.annotations.TypeMetadata;
import org.gradle.internal.properties.annotations.TypeMetadataStore;
import org.gradle.internal.reflect.annotations.AnnotationCategory;
import org.gradle.internal.reflect.annotations.PropertyAnnotationMetadata;
import org.gradle.internal.reflect.annotations.TypeAnnotationMetadata;
import org.gradle.internal.reflect.annotations.TypeAnnotationMetadataStore;
import org.gradle.internal.reflect.validation.ReplayingTypeValidationContext;
import org.gradle.internal.reflect.validation.TypeAwareProblemBuilder;
import org.gradle.internal.reflect.validation.TypeValidationContext;
import org.gradle.util.internal.TextUtil;

public class DefaultTypeMetadataStore
implements TypeMetadataStore {
    private final Collection<? extends TypeAnnotationHandler> typeAnnotationHandlers;
    private final ImmutableMap<Class<? extends Annotation>, ? extends PropertyAnnotationHandler> propertyAnnotationHandlers;
    private final ImmutableSet<Class<? extends Annotation>> allowedPropertyModifiers;
    private final CrossBuildInMemoryCache<Class<?>, TypeMetadata> cache;
    private final TypeAnnotationMetadataStore typeAnnotationMetadataStore;
    private final PropertyTypeResolver propertyTypeResolver;
    private final String displayName;
    private final MissingPropertyAnnotationHandler missingPropertyAnnotationHandler;
    private static final String ANNOTATION_INVALID_IN_CONTEXT = "ANNOTATION_INVALID_IN_CONTEXT";
    private static final String INCOMPATIBLE_ANNOTATIONS = "INCOMPATIBLE_ANNOTATIONS";

    public DefaultTypeMetadataStore(Collection<? extends TypeAnnotationHandler> typeAnnotationHandlers, Collection<? extends PropertyAnnotationHandler> propertyAnnotationHandlers, Collection<Class<? extends Annotation>> allowedPropertyModifiers, TypeAnnotationMetadataStore typeAnnotationMetadataStore, PropertyTypeResolver propertyTypeResolver, CrossBuildInMemoryCacheFactory cacheFactory, MissingPropertyAnnotationHandler missingPropertyAnnotationHandler) {
        this.typeAnnotationHandlers = ImmutableSet.copyOf(typeAnnotationHandlers);
        this.propertyAnnotationHandlers = Maps.uniqueIndex(propertyAnnotationHandlers, PropertyAnnotationHandler::getAnnotationType);
        this.allowedPropertyModifiers = ImmutableSet.copyOf(allowedPropertyModifiers);
        this.typeAnnotationMetadataStore = typeAnnotationMetadataStore;
        this.displayName = DefaultTypeMetadataStore.calculateDisplayName(propertyAnnotationHandlers);
        this.propertyTypeResolver = propertyTypeResolver;
        this.cache = cacheFactory.newClassCache();
        this.missingPropertyAnnotationHandler = missingPropertyAnnotationHandler;
    }

    private static String calculateDisplayName(Collection<? extends PropertyAnnotationHandler> annotationHandlers) {
        return annotationHandlers.stream().map(PropertyAnnotationHandler::getKind).anyMatch(Predicate.isEqual((Object)PropertyAnnotationHandler.Kind.OUTPUT)) ? "an input or output annotation" : "an input annotation";
    }

    @Override
    public <T> TypeMetadata getTypeMetadata(Class<T> type) {
        return (TypeMetadata)this.cache.get(type, this::createTypeMetadata);
    }

    private <T> TypeMetadata createTypeMetadata(Class<T> type) {
        Class publicType = GeneratedSubclasses.unpack(type);
        ReplayingTypeValidationContext validationContext = new ReplayingTypeValidationContext();
        TypeAnnotationMetadata annotationMetadata = this.typeAnnotationMetadataStore.getTypeAnnotationMetadata(publicType);
        annotationMetadata.visitValidationFailures(validationContext);
        for (TypeAnnotationHandler typeAnnotationHandler : this.typeAnnotationHandlers) {
            if (!annotationMetadata.isAnnotationPresent(typeAnnotationHandler.getAnnotationType())) continue;
            typeAnnotationHandler.validateTypeMetadata(publicType, validationContext);
        }
        ImmutableSet.Builder effectiveProperties = ImmutableSet.builderWithExpectedSize((int)annotationMetadata.getPropertiesAnnotationMetadata().size());
        for (PropertyAnnotationMetadata propertyAnnotationMetadata : annotationMetadata.getPropertiesAnnotationMetadata()) {
            ImmutableMap<AnnotationCategory, Annotation> propertyAnnotations = propertyAnnotationMetadata.getAnnotations();
            Class<? extends Annotation> propertyType = this.propertyTypeResolver.resolveAnnotationType((Map<AnnotationCategory, Annotation>)propertyAnnotations);
            if (propertyType == null) {
                this.missingPropertyAnnotationHandler.handleMissingPropertyAnnotation(validationContext, propertyAnnotationMetadata, this.displayName);
                continue;
            }
            PropertyAnnotationHandler annotationHandler = (PropertyAnnotationHandler)this.propertyAnnotationHandlers.get(propertyType);
            if (annotationHandler == null) {
                validationContext.visitPropertyProblem((Action<? super TypeAwareProblemBuilder>)((Action)problem -> problem.forProperty(propertyAnnotationMetadata.getPropertyName()).id(TextUtil.screamingSnakeToKebabCase((String)ANNOTATION_INVALID_IN_CONTEXT), "Invalid annotation in context", GradleCoreProblemGroup.validation().property()).contextualLabel(String.format("is annotated with invalid property type @%s", propertyType.getSimpleName())).documentedAt((DocLink)Documentation.userManual((String)"validation_problems", (String)ANNOTATION_INVALID_IN_CONTEXT.toLowerCase(Locale.ROOT))).severity(Severity.ERROR).details("The '@" + propertyType.getSimpleName() + "' annotation cannot be used in this context").solution("Remove the property").solution("Use a different annotation, e.g one of " + DefaultTypeMetadataStore.toListOfAnnotations((ImmutableSet<Class<? extends Annotation>>)this.propertyAnnotationHandlers.keySet()))));
                continue;
            }
            ImmutableSet<Class<? extends Annotation>> allowedModifiersForPropertyType = annotationHandler.getAllowedModifiers();
            for (Map.Entry entry : propertyAnnotations.entrySet()) {
                AnnotationCategory annotationCategory = (AnnotationCategory)entry.getKey();
                if (annotationCategory == AnnotationCategory.TYPE) continue;
                Class<? extends Annotation> annotationType = ((Annotation)entry.getValue()).annotationType();
                if (!allowedModifiersForPropertyType.contains(annotationType)) {
                    validationContext.visitPropertyProblem((Action<? super TypeAwareProblemBuilder>)((Action)problem -> problem.forProperty(propertyAnnotationMetadata.getPropertyName()).id(TextUtil.screamingSnakeToKebabCase((String)INCOMPATIBLE_ANNOTATIONS), "Incompatible annotations", GradleCoreProblemGroup.validation().property()).contextualLabel("is annotated with @" + annotationType.getSimpleName() + " but that is not allowed for '" + propertyType.getSimpleName() + "' properties").documentedAt((DocLink)Documentation.userManual((String)"validation_problems", (String)INCOMPATIBLE_ANNOTATIONS.toLowerCase(Locale.ROOT))).severity(Severity.ERROR).details("This modifier is used in conjunction with a property of type '" + propertyType.getSimpleName() + "' but this doesn't have semantics").solution("Remove the '@" + annotationType.getSimpleName() + "' annotation")));
                    continue;
                }
                if (this.allowedPropertyModifiers.contains(annotationType)) continue;
                validationContext.visitPropertyProblem((Action<? super TypeAwareProblemBuilder>)((Action)problem -> problem.forProperty(propertyAnnotationMetadata.getPropertyName()).id(TextUtil.screamingSnakeToKebabCase((String)ANNOTATION_INVALID_IN_CONTEXT), "Invalid annotation in context", GradleCoreProblemGroup.validation().property()).contextualLabel(String.format("is annotated with invalid modifier @%s", annotationType.getSimpleName())).documentedAt((DocLink)Documentation.userManual((String)"validation_problems", (String)ANNOTATION_INVALID_IN_CONTEXT.toLowerCase(Locale.ROOT))).severity(Severity.ERROR).details("The '@" + annotationType.getSimpleName() + "' annotation cannot be used in this context").solution("Use a different annotation, e.g one of " + DefaultTypeMetadataStore.toListOfAnnotations(this.allowedPropertyModifiers)).solution("Remove the annotation")));
            }
            DefaultPropertyMetadata property = new DefaultPropertyMetadata(propertyType, propertyAnnotationMetadata);
            annotationHandler.validatePropertyMetadata(property, validationContext);
            if (!annotationHandler.isPropertyRelevant()) continue;
            effectiveProperties.add((Object)property);
        }
        return new DefaultTypeMetadata(publicType, (ImmutableSet<PropertyMetadata>)effectiveProperties.build(), validationContext, this.propertyAnnotationHandlers, annotationMetadata);
    }

    private static String toListOfAnnotations(ImmutableSet<Class<? extends Annotation>> classes) {
        return classes.stream().map(Class::getSimpleName).map(s -> "@" + s).sorted().collect(DefaultTypeMetadataStore.forDisplay());
    }

    private static Collector<? super String, ?, String> forDisplay() {
        return Collectors.collectingAndThen(Collectors.toList(), stringList -> {
            if (stringList.isEmpty()) {
                return "";
            }
            if (stringList.size() == 1) {
                return (String)stringList.get(0);
            }
            int bound = stringList.size() - 1;
            return String.join((CharSequence)", ", stringList.subList(0, bound)) + " or " + (String)stringList.get(bound);
        });
    }

    private static class DefaultPropertyMetadata
    implements PropertyMetadata {
        private final Class<? extends Annotation> propertyType;
        private final PropertyAnnotationMetadata annotationMetadata;

        public DefaultPropertyMetadata(Class<? extends Annotation> propertyType, PropertyAnnotationMetadata annotationMetadata) {
            this.propertyType = propertyType;
            this.annotationMetadata = annotationMetadata;
        }

        @Override
        public String getPropertyName() {
            return this.annotationMetadata.getPropertyName();
        }

        @Override
        public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
            return this.annotationMetadata.isAnnotationPresent(annotationType);
        }

        @Override
        public <T extends Annotation> Optional<T> getAnnotation(Class<T> annotationType) {
            return this.annotationMetadata.getAnnotation(annotationType);
        }

        @Override
        public Optional<Annotation> getAnnotationForCategory(AnnotationCategory category) {
            return Optional.ofNullable((Annotation)this.annotationMetadata.getAnnotations().get((Object)category));
        }

        @Override
        public boolean hasAnnotationForCategory(AnnotationCategory category) {
            return this.annotationMetadata.getAnnotations().get((Object)category) != null;
        }

        @Override
        public Class<? extends Annotation> getPropertyType() {
            return this.propertyType;
        }

        @Override
        public TypeToken<?> getDeclaredType() {
            return this.annotationMetadata.getDeclaredType();
        }

        @Override
        @Nullable
        public Object getPropertyValue(Object object) {
            return this.annotationMetadata.getPropertyValue(object);
        }

        public String toString() {
            return String.format("@%s %s", this.propertyType.getSimpleName(), this.getPropertyName());
        }
    }

    private static class DefaultTypeMetadata
    implements TypeMetadata {
        private final Class<?> type;
        private final ImmutableSet<PropertyMetadata> propertiesMetadata;
        private final ReplayingTypeValidationContext validationProblems;
        private final ImmutableMap<Class<? extends Annotation>, ? extends PropertyAnnotationHandler> annotationHandlers;
        private final TypeAnnotationMetadata typeAnnotationMetadata;

        DefaultTypeMetadata(Class<?> type, ImmutableSet<PropertyMetadata> propertiesMetadata, ReplayingTypeValidationContext validationProblems, ImmutableMap<Class<? extends Annotation>, ? extends PropertyAnnotationHandler> annotationHandlers, TypeAnnotationMetadata typeAnnotationMetadata) {
            this.type = type;
            this.propertiesMetadata = propertiesMetadata;
            this.validationProblems = validationProblems;
            this.annotationHandlers = annotationHandlers;
            this.typeAnnotationMetadata = typeAnnotationMetadata;
        }

        @Override
        public void visitValidationFailures(@Nullable String ownerPropertyPath, TypeValidationContext validationContext) {
            this.validationProblems.replay(ownerPropertyPath, validationContext);
        }

        @Override
        public Set<PropertyMetadata> getPropertiesMetadata() {
            return this.propertiesMetadata;
        }

        @Override
        public boolean hasAnnotatedProperties() {
            return !this.propertiesMetadata.isEmpty();
        }

        @Override
        public PropertyAnnotationHandler getAnnotationHandlerFor(PropertyMetadata propertyMetadata) {
            return (PropertyAnnotationHandler)this.annotationHandlers.get(propertyMetadata.getPropertyType());
        }

        @Override
        public Class<?> getType() {
            return this.type;
        }

        @Override
        public TypeAnnotationMetadata getTypeAnnotationMetadata() {
            return this.typeAnnotationMetadata;
        }
    }
}

