/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile;

import com.google.common.base.Joiner;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.JavaVersion;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.internal.tasks.compile.MinimalJavaCompileOptions;
import org.gradle.api.internal.tasks.compile.MinimalJavaCompilerDaemonForkOptions;
import org.gradle.internal.Cast;
import org.gradle.util.internal.GUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaCompilerArgumentsBuilder {
    public static final Logger LOGGER = LoggerFactory.getLogger(JavaCompilerArgumentsBuilder.class);
    public static final String USE_UNSHARED_COMPILER_TABLE_OPTION = "-XDuseUnsharedTable=true";
    public static final String EMPTY_SOURCE_PATH_REF_DIR = "emptySourcePathRef";
    private final JavaCompileSpec spec;
    private boolean includeLauncherOptions;
    private boolean includeMainOptions = true;
    private boolean includeClasspath = true;
    private boolean includeSourceFiles;
    private boolean allowEmptySourcePath = true;
    private List<String> args;

    public JavaCompilerArgumentsBuilder(JavaCompileSpec spec) {
        this.spec = spec;
    }

    public JavaCompilerArgumentsBuilder includeLauncherOptions(boolean flag) {
        this.includeLauncherOptions = flag;
        return this;
    }

    public JavaCompilerArgumentsBuilder includeMainOptions(boolean flag) {
        this.includeMainOptions = flag;
        return this;
    }

    public JavaCompilerArgumentsBuilder includeClasspath(boolean flag) {
        this.includeClasspath = flag;
        return this;
    }

    public JavaCompilerArgumentsBuilder includeSourceFiles(boolean flag) {
        this.includeSourceFiles = flag;
        return this;
    }

    public JavaCompilerArgumentsBuilder noEmptySourcePath() {
        this.allowEmptySourcePath = false;
        return this;
    }

    public List<String> build() {
        this.args = new ArrayList<String>();
        List compilerArgs = (List)Cast.uncheckedCast(this.spec.getCompileOptions().getCompilerArgs());
        List<String> compArgs = compilerArgs.stream().map(Object::toString).collect(Collectors.toList());
        this.validateCompilerArgs(compArgs);
        this.addLauncherOptions();
        this.addMainOptions(compArgs);
        this.addClasspath();
        this.addUserProvidedArgs(compArgs);
        this.addSourceFiles();
        return this.args;
    }

    private void validateCompilerArgs(List<String> compilerArgs) {
        for (String arg : compilerArgs) {
            if ("-sourcepath".equals(arg) || "--source-path".equals(arg)) {
                throw new InvalidUserDataException("Cannot specify -sourcepath or --source-path via `CompileOptions.compilerArgs`. Use the `CompileOptions.sourcepath` property instead.");
            }
            if ("-processorpath".equals(arg) || "--processor-path".equals(arg)) {
                throw new InvalidUserDataException("Cannot specify -processorpath or --processor-path via `CompileOptions.compilerArgs`. Use the `CompileOptions.annotationProcessorPath` property instead.");
            }
            if (arg != null && arg.startsWith("-J")) {
                throw new InvalidUserDataException("Cannot specify -J flags via `CompileOptions.compilerArgs`. Use the `CompileOptions.forkOptions.jvmArgs` property instead.");
            }
            if (!"--release".equals(arg) || this.spec.getRelease() == null) continue;
            throw new InvalidUserDataException("Cannot specify --release via `CompileOptions.compilerArgs` when using `CompileOptions.release`.");
        }
    }

    private void addLauncherOptions() {
        if (!this.includeLauncherOptions) {
            return;
        }
        MinimalJavaCompilerDaemonForkOptions forkOptions = this.spec.getCompileOptions().getForkOptions();
        if (forkOptions.getMemoryInitialSize() != null) {
            this.args.add("-J-Xms" + forkOptions.getMemoryInitialSize().trim());
        }
        if (forkOptions.getMemoryMaximumSize() != null) {
            this.args.add("-J-Xmx" + forkOptions.getMemoryMaximumSize().trim());
        }
        if (forkOptions.getJvmArgs() != null) {
            this.args.addAll(forkOptions.getJvmArgs());
        }
    }

    private void addMainOptions(List<String> compilerArgs) {
        String bootClasspath;
        if (!this.includeMainOptions) {
            return;
        }
        Integer release = this.spec.getRelease();
        MinimalJavaCompileOptions compileOptions = this.spec.getCompileOptions();
        if (release != null) {
            this.args.add("--release");
            this.args.add(release.toString());
        } else if (!this.releaseOptionIsSet(compilerArgs)) {
            String targetCompatibility;
            String sourceCompatibility = this.spec.getSourceCompatibility();
            if (sourceCompatibility != null) {
                this.args.add("-source");
                this.args.add(sourceCompatibility);
            }
            if ((targetCompatibility = this.spec.getTargetCompatibility()) != null) {
                this.args.add("-target");
                this.args.add(targetCompatibility);
            }
        }
        File destinationDir = this.spec.getDestinationDir();
        if (destinationDir != null) {
            this.args.add("-d");
            this.args.add(destinationDir.getPath());
        }
        if (compileOptions.isVerbose()) {
            this.args.add("-verbose");
        }
        if (compileOptions.isDeprecation()) {
            this.args.add("-deprecation");
        }
        if (!compileOptions.isWarnings()) {
            this.args.add("-nowarn");
        }
        if (compileOptions.getEncoding() != null) {
            this.args.add("-encoding");
            this.args.add(compileOptions.getEncoding());
        }
        if ((bootClasspath = compileOptions.getBootClasspath()) != null) {
            this.args.add("-bootclasspath");
            this.args.add(bootClasspath);
        }
        if (compileOptions.getExtensionDirs() != null) {
            this.args.add("-extdirs");
            this.args.add(compileOptions.getExtensionDirs());
        }
        if (compileOptions.getHeaderOutputDirectory() != null) {
            this.args.add("-h");
            this.args.add(compileOptions.getHeaderOutputDirectory().getPath());
        }
        if (compileOptions.isDebug()) {
            if (compileOptions.getDebugOptions().getDebugLevel() != null) {
                this.args.add("-g:" + compileOptions.getDebugOptions().getDebugLevel().trim());
            } else {
                this.args.add("-g");
            }
        } else {
            this.args.add("-g:none");
        }
        this.addSourcePathArg(compilerArgs, compileOptions);
        if (this.spec.getSourceCompatibility() == null || JavaVersion.toVersion((Object)this.spec.getSourceCompatibility()).compareTo((Enum)JavaVersion.VERSION_1_6) >= 0) {
            List<File> annotationProcessorPath = this.spec.getAnnotationProcessorPath();
            if (annotationProcessorPath == null || annotationProcessorPath.isEmpty()) {
                this.args.add("-proc:none");
            } else {
                this.args.add("-processorpath");
                this.args.add(Joiner.on((String)File.pathSeparator).join(annotationProcessorPath));
            }
            if (compileOptions.getAnnotationProcessorGeneratedSourcesDirectory() != null) {
                this.args.add("-s");
                this.args.add(compileOptions.getAnnotationProcessorGeneratedSourcesDirectory().getPath());
            }
        }
        this.args.add(USE_UNSHARED_COMPILER_TABLE_OPTION);
    }

    private void addSourcePathArg(List<String> compilerArgs, MinimalJavaCompileOptions compileOptions) {
        boolean emptySourcePath;
        List<File> sourcepath = compileOptions.getSourcepath();
        boolean bl = emptySourcePath = sourcepath == null || sourcepath.isEmpty();
        if (compilerArgs.contains("--module-source-path")) {
            if (!emptySourcePath) {
                LOGGER.warn("You specified both --module-source-path and a sourcepath. These options are mutually exclusive. Ignoring sourcepath.");
            }
            return;
        }
        if (emptySourcePath) {
            if (this.allowEmptySourcePath) {
                this.args.add("-sourcepath");
                this.args.add("");
            }
            return;
        }
        this.args.add("-sourcepath");
        this.args.add(GUtil.asPath(sourcepath));
    }

    private void addUserProvidedArgs(List<String> compilerArgs) {
        if (!this.includeMainOptions) {
            return;
        }
        if (compilerArgs != null) {
            this.args.addAll(compilerArgs);
        }
    }

    private boolean releaseOptionIsSet(List<String> compilerArgs) {
        return compilerArgs != null && compilerArgs.contains("--release");
    }

    private void addClasspath() {
        if (!this.includeClasspath) {
            return;
        }
        List classpath = this.spec.getCompileClasspath();
        List<File> modulePath = this.spec.getModulePath();
        String moduleVersion = this.spec.getCompileOptions().getJavaModuleVersion();
        this.args.add("-classpath");
        this.args.add(Joiner.on((char)File.pathSeparatorChar).join((Iterable)classpath));
        if (!modulePath.isEmpty()) {
            if (moduleVersion != null) {
                this.args.add("--module-version");
                this.args.add(moduleVersion);
            }
            this.args.add("--module-path");
            this.args.add(Joiner.on((char)File.pathSeparatorChar).join(modulePath));
        }
    }

    private void addSourceFiles() {
        if (!this.includeSourceFiles) {
            return;
        }
        for (File file : this.spec.getSourceFiles()) {
            this.args.add(file.getPath());
        }
    }
}

