/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.client;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.gradle.api.GradleException;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.classpath.DefaultModuleRegistry;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.installation.CurrentGradleInstallation;
import org.gradle.internal.installation.GradleInstallation;
import org.gradle.internal.io.StreamByteBuffer;
import org.gradle.internal.jvm.JavaInfo;
import org.gradle.internal.jvm.JpmsConfiguration;
import org.gradle.internal.jvm.Jvm;
import org.gradle.internal.jvm.inspection.JvmInstallationMetadata;
import org.gradle.internal.jvm.inspection.JvmVersionDetector;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.internal.serialize.kryo.KryoBackedEncoder;
import org.gradle.internal.stream.EncodedStream;
import org.gradle.internal.time.Time;
import org.gradle.internal.time.Timer;
import org.gradle.launcher.daemon.DaemonExecHandleBuilder;
import org.gradle.launcher.daemon.bootstrap.DaemonOutputConsumer;
import org.gradle.launcher.daemon.client.DaemonGreeter;
import org.gradle.launcher.daemon.client.DaemonStarter;
import org.gradle.launcher.daemon.client.JvmVersionValidator;
import org.gradle.launcher.daemon.configuration.DaemonParameters;
import org.gradle.launcher.daemon.configuration.DaemonPriority;
import org.gradle.launcher.daemon.context.DaemonRequestContext;
import org.gradle.launcher.daemon.diagnostics.DaemonStartupInfo;
import org.gradle.launcher.daemon.registry.DaemonDir;
import org.gradle.launcher.daemon.toolchain.DaemonJavaToolchainQueryService;
import org.gradle.launcher.daemon.toolchain.DaemonJvmCriteria;
import org.gradle.process.internal.DefaultExecActionFactory;
import org.gradle.process.internal.ExecHandle;
import org.gradle.process.internal.JvmOptions;
import org.gradle.util.GradleVersion;
import org.gradle.util.internal.CollectionUtils;
import org.gradle.util.internal.GFileUtils;
import org.gradle.util.internal.IncubationLogger;

public class DefaultDaemonStarter
implements DaemonStarter {
    private static final Logger LOGGER = Logging.getLogger(DefaultDaemonStarter.class);
    private final DaemonDir daemonDir;
    private final DaemonParameters daemonParameters;
    private final DaemonRequestContext daemonRequestContext;
    private final DaemonGreeter daemonGreeter;
    private final JvmVersionValidator versionValidator;
    private final JvmVersionDetector jvmVersionDetector;
    private final DaemonJavaToolchainQueryService daemonJavaToolchainQueryService;

    public DefaultDaemonStarter(DaemonDir daemonDir, DaemonParameters daemonParameters, DaemonRequestContext daemonRequestContext, DaemonGreeter daemonGreeter, JvmVersionValidator versionValidator, JvmVersionDetector jvmVersionDetector, DaemonJavaToolchainQueryService daemonJavaToolchainQueryService) {
        this.daemonDir = daemonDir;
        this.daemonParameters = daemonParameters;
        this.daemonRequestContext = daemonRequestContext;
        this.daemonGreeter = daemonGreeter;
        this.versionValidator = versionValidator;
        this.jvmVersionDetector = jvmVersionDetector;
        this.daemonJavaToolchainQueryService = daemonJavaToolchainQueryService;
    }

    @Override
    public DaemonStartupInfo startDaemon(boolean singleUse) {
        List searchClassPath;
        ClassPath classpath;
        JavaInfo resolvedJvm;
        File resolvedJava;
        int majorJavaVersion;
        String daemonUid = UUID.randomUUID().toString();
        DaemonJvmCriteria criteria = this.daemonRequestContext.getJvmCriteria();
        if (criteria instanceof DaemonJvmCriteria.Spec) {
            IncubationLogger.incubatingFeatureUsed((String)"Daemon JVM discovery");
            JvmInstallationMetadata jvmInstallationMetadata = this.daemonJavaToolchainQueryService.findMatchingToolchain((DaemonJvmCriteria.Spec)criteria);
            JavaInfo resolvedJvm2 = Jvm.forHome((File)jvmInstallationMetadata.getJavaHome().toFile());
            majorJavaVersion = ((DaemonJvmCriteria.Spec)criteria).getJavaVersion().asInt();
            resolvedJava = resolvedJvm2.getJavaExecutable();
        } else if (criteria instanceof DaemonJvmCriteria.JavaHome) {
            resolvedJvm = Jvm.forHome((File)((DaemonJvmCriteria.JavaHome)criteria).getJavaHome());
            majorJavaVersion = this.jvmVersionDetector.getJavaVersionMajor(resolvedJvm);
            resolvedJava = resolvedJvm.getJavaExecutable();
        } else if (criteria instanceof DaemonJvmCriteria.LauncherJvm) {
            resolvedJvm = Jvm.current();
            majorJavaVersion = Jvm.current().getJavaVersionMajor();
            resolvedJava = resolvedJvm.getJavaExecutable();
        } else {
            throw new IllegalStateException("Unknown DaemonJvmCriteria type: " + criteria.getClass().getName());
        }
        GradleInstallation gradleInstallation = CurrentGradleInstallation.get();
        DefaultModuleRegistry registry = new DefaultModuleRegistry(gradleInstallation);
        if (gradleInstallation == null) {
            classpath = registry.getModule("gradle-daemon-server").getAllRequiredModulesClasspath();
            classpath = classpath.plus(registry.getModule("gradle-daemon-main").getImplementationClasspath());
            searchClassPath = registry.getAdditionalClassPath().getAsFiles();
        } else {
            classpath = registry.getModule("gradle-daemon-main").getImplementationClasspath();
            searchClassPath = Collections.emptyList();
        }
        if (classpath.isEmpty()) {
            throw new IllegalStateException("Unable to construct a bootstrap classpath when starting the daemon");
        }
        this.versionValidator.validate(majorJavaVersion);
        ArrayList<String> daemonArgs = new ArrayList<String>();
        daemonArgs.addAll(this.getPriorityArgs(this.daemonRequestContext.getPriority()));
        daemonArgs.add(resolvedJava.getAbsolutePath());
        Collection daemonOpts = this.daemonRequestContext.getDaemonOpts();
        if (majorJavaVersion >= 9) {
            daemonArgs.addAll(JpmsConfiguration.GRADLE_DAEMON_JPMS_ARGS);
        }
        daemonArgs.addAll(daemonOpts);
        daemonArgs.add("-cp");
        daemonArgs.add(CollectionUtils.join((String)File.pathSeparator, (Iterable)classpath.getAsFiles()));
        if (Boolean.getBoolean("org.gradle.daemon.debug")) {
            daemonArgs.add(JvmOptions.getDebugArgument((boolean)true, (boolean)true, (String)"5005"));
        }
        ClassPath agentClasspath = registry.getModule("gradle-instrumentation-agent").getImplementationClasspath();
        if (this.daemonRequestContext.shouldApplyInstrumentationAgent()) {
            if (agentClasspath.isEmpty()) {
                throw new IllegalStateException("Cannot find the agent JAR");
            }
            for (File agentJar : agentClasspath.getAsFiles()) {
                daemonArgs.add("-javaagent:" + agentJar);
            }
        }
        LOGGER.debug("Using daemon args: {}", daemonArgs);
        daemonArgs.add("org.gradle.launcher.daemon.bootstrap.GradleDaemon");
        daemonArgs.add(GradleVersion.current().getVersion());
        StreamByteBuffer buffer = new StreamByteBuffer();
        KryoBackedEncoder encoder = new KryoBackedEncoder((OutputStream)new EncodedStream.EncodedOutput(buffer.getOutputStream()));
        try {
            encoder.writeString((CharSequence)this.daemonParameters.getGradleUserHomeDir().getAbsolutePath());
            encoder.writeString((CharSequence)this.daemonDir.getBaseDir().getAbsolutePath());
            encoder.writeSmallInt(this.daemonParameters.getIdleTimeout());
            encoder.writeSmallInt(this.daemonParameters.getPeriodicCheckInterval());
            encoder.writeBoolean(singleUse);
            encoder.writeSmallInt(this.daemonParameters.getNativeServicesMode().ordinal());
            encoder.writeString((CharSequence)daemonUid);
            encoder.writeSmallInt(this.daemonParameters.getPriority().ordinal());
            encoder.writeSmallInt(daemonOpts.size());
            for (String daemonOpt : daemonOpts) {
                encoder.writeString((CharSequence)daemonOpt);
            }
            encoder.writeSmallInt(searchClassPath.size());
            for (File file : searchClassPath) {
                encoder.writeString((CharSequence)file.getAbsolutePath());
            }
            encoder.flush();
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
        InputStream stdInput = buffer.getInputStream();
        return this.startProcess(daemonArgs, this.daemonDir.getVersionedDir(), this.daemonParameters.getGradleUserHomeDir().getAbsoluteFile(), stdInput);
    }

    private List<String> getPriorityArgs(DaemonPriority priority) {
        if (priority == DaemonPriority.NORMAL) {
            return Collections.emptyList();
        }
        OperatingSystem os = OperatingSystem.current();
        if (os.isUnix()) {
            return Arrays.asList("nice", "-n", "10");
        }
        if (os.isWindows()) {
            return Arrays.asList("cmd.exe", "/d", "/c", "start", "\"Gradle build daemon\"", "/b", "/belownormal", "/wait");
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DaemonStartupInfo startProcess(List<String> args, File workingDir, File gradleUserHome, InputStream stdInput) {
        LOGGER.debug("Starting daemon process: workingDir = {}, daemonArgs: {}", (Object)workingDir, args);
        Timer clock = Time.startTimer();
        try {
            GFileUtils.mkdirs((File)workingDir);
            DaemonOutputConsumer outputConsumer = new DaemonOutputConsumer();
            DefaultExecActionFactory execActionFactory = DefaultExecActionFactory.root((File)gradleUserHome);
            try {
                ExecHandle handle = new DaemonExecHandleBuilder().build(args, workingDir, outputConsumer, stdInput, execActionFactory.newExec());
                handle.start();
                LOGGER.debug("Gradle daemon process is starting. Waiting for the daemon to detach...");
                handle.waitForFinish();
                LOGGER.debug("Gradle daemon process is now detached.");
            }
            catch (Throwable throwable) {
                CompositeStoppable.stoppable((Object[])new Object[]{execActionFactory}).stop();
                throw throwable;
            }
            CompositeStoppable.stoppable((Object[])new Object[]{execActionFactory}).stop();
            DaemonStartupInfo daemonStartupInfo = this.daemonGreeter.parseDaemonOutput(outputConsumer.getProcessOutput(), args);
            return daemonStartupInfo;
        }
        catch (GradleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new GradleException("Could not start Gradle daemon.", (Throwable)e);
        }
        finally {
            LOGGER.info("An attempt to start the daemon took {}.", (Object)clock.getElapsed());
        }
    }
}

