/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.properties;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.util.Locale;
import javax.annotation.Nullable;
import org.gradle.api.internal.tasks.properties.PropertyValidationContext;
import org.gradle.api.internal.tasks.properties.ValidatingProperty;
import org.gradle.api.internal.tasks.properties.ValidationAction;
import org.gradle.api.problems.Severity;
import org.gradle.api.problems.internal.DocLink;
import org.gradle.api.problems.internal.GradleCoreProblemGroup;
import org.gradle.api.problems.internal.InternalProblemSpec;
import org.gradle.api.provider.HasConfigurableValue;
import org.gradle.api.provider.Provider;
import org.gradle.internal.deprecation.Documentation;
import org.gradle.internal.properties.PropertyValue;
import org.gradle.internal.reflect.validation.TypeValidationContext;
import org.gradle.util.internal.DeferredUtil;
import org.gradle.util.internal.TextUtil;

public abstract class AbstractValidatingProperty
implements ValidatingProperty {
    private final String propertyName;
    private final PropertyValue value;
    private final boolean optional;
    private final ValidationAction validationAction;
    private static final String VALUE_NOT_SET = "VALUE_NOT_SET";

    public AbstractValidatingProperty(String propertyName, PropertyValue value, boolean optional, ValidationAction validationAction) {
        this.propertyName = propertyName;
        this.value = value;
        this.optional = optional;
        this.validationAction = validationAction;
    }

    public static void reportValueNotSet(String propertyName, TypeValidationContext context, boolean hasConfigurableValue) {
        context.visitPropertyProblem(problem -> {
            InternalProblemSpec problemSpec = problem.forProperty(propertyName).id(TextUtil.screamingSnakeToKebabCase((String)VALUE_NOT_SET), "Value not set", GradleCoreProblemGroup.validation().property()).contextualLabel("doesn't have a configured value").documentedAt((DocLink)Documentation.userManual((String)"validation_problems", (String)VALUE_NOT_SET.toLowerCase(Locale.ROOT))).severity(Severity.ERROR).details("This property isn't marked as optional and no value has been configured");
            if (hasConfigurableValue) {
                problemSpec.solution("Assign a value to '" + propertyName + "'");
            } else {
                problemSpec.solution("The value of '" + propertyName + "' is calculated, make sure a valid value can be calculated");
            }
            problemSpec.solution("Mark property '" + propertyName + "' as optional");
        });
    }

    @Override
    public void validate(PropertyValidationContext context) {
        Object unnested = DeferredUtil.unpackNestableDeferred((Object)this.value.call());
        if (AbstractValidatingProperty.isPresent(unnested)) {
            Supplier valueSupplier = Suppliers.memoize(() -> DeferredUtil.unpack((Object)unnested));
            this.validationAction.validate(this.propertyName, (java.util.function.Supplier<Object>)valueSupplier, context);
        } else if (!this.optional) {
            AbstractValidatingProperty.reportValueNotSet(this.propertyName, context, AbstractValidatingProperty.hasConfigurableValue(unnested));
        }
    }

    private static boolean isPresent(@Nullable Object value) {
        if (value instanceof Provider) {
            return ((Provider)value).isPresent();
        }
        return value != null;
    }

    private static boolean hasConfigurableValue(@Nullable Object value) {
        return value == null || HasConfigurableValue.class.isAssignableFrom(value.getClass());
    }

    public void prepareValue() {
        this.value.maybeFinalizeValue();
    }

    public void cleanupValue() {
    }
}

