/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.transformers.irToJs;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.serialization.CityHashKt;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.CrossModuleImport;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.CrossModuleImportWithEffect;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.CrossModuleRef;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.CrossModuleReferences;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.CrossModuleTransitiveExport;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.JsIrModuleHeader;
import org.jetbrains.kotlin.ir.backend.js.utils.NameTablesKt;
import org.jetbrains.kotlin.js.backend.ast.JsImportedModule;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.serialization.js.ModuleKind;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\r\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010%\u001a\u00020&2\b\b\u0002\u0010'\u001a\u00020(J\u0006\u0010)\u001a\u00020*J\f\u0010+\u001a\u00020,*\u00020\u0005H\u0002J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u001c2\u0006\u0010-\u001a\u00020\u0005H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0014R\u0017\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR&\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001c0 X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$\u00a8\u0006."}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/JsIrModuleCrossModuleReferenceBuilder;", "", "moduleKind", "Lorg/jetbrains/kotlin/serialization/js/ModuleKind;", "header", "Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/JsIrModuleHeader;", "relativeRequirePath", "", "transitiveExportFrom", "", "importWithEffectFrom", "<init>", "(Lorg/jetbrains/kotlin/serialization/js/ModuleKind;Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/JsIrModuleHeader;ZLjava/util/List;Ljava/util/List;)V", "getModuleKind", "()Lorg/jetbrains/kotlin/serialization/js/ModuleKind;", "getHeader", "()Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/JsIrModuleHeader;", "getRelativeRequirePath", "()Z", "getTransitiveExportFrom", "()Ljava/util/List;", "getImportWithEffectFrom", "imports", "", "Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/CrossModuleRef;", "getImports", "exports", "", "", "getExports", "()Ljava/util/Set;", "exportNames", "", "getExportNames", "()Ljava/util/Map;", "setExportNames", "(Ljava/util/Map;)V", "buildExportNames", "", "startIndex", "", "buildCrossModuleRefs", "Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/CrossModuleReferences;", "toJsImportedModule", "Lorg/jetbrains/kotlin/js/backend/ast/JsImportedModule;", "moduleHeader", "backend.js"})
@SourceDebugExtension(value={"SMAP\nJsIrProgramFragment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsIrProgramFragment.kt\norg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/JsIrModuleCrossModuleReferenceBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,312:1\n1279#2,2:313\n1293#2,4:315\n1187#2,2:319\n1261#2,4:321\n1611#2,9:325\n1863#2:334\n1864#2:336\n1620#2:337\n1557#2:338\n1628#2,3:339\n1#3:335\n1#3:342\n381#4,7:343\n*S KotlinDebug\n*F\n+ 1 JsIrProgramFragment.kt\norg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/JsIrModuleCrossModuleReferenceBuilder\n*L\n167#1:313,2\n167#1:315,4\n189#1:319,2\n189#1:321,4\n197#1:325,9\n197#1:334\n197#1:336\n197#1:337\n203#1:338\n203#1:339,3\n197#1:335\n185#1:343,7\n*E\n"})
final class JsIrModuleCrossModuleReferenceBuilder {
    @NotNull
    private final ModuleKind moduleKind;
    @NotNull
    private final JsIrModuleHeader header;
    private final boolean relativeRequirePath;
    @NotNull
    private final List<JsIrModuleHeader> transitiveExportFrom;
    @NotNull
    private final List<JsIrModuleHeader> importWithEffectFrom;
    @NotNull
    private final List<CrossModuleRef> imports;
    @NotNull
    private final Set<String> exports;
    public Map<String, String> exportNames;

    public JsIrModuleCrossModuleReferenceBuilder(@NotNull ModuleKind moduleKind, @NotNull JsIrModuleHeader header, boolean relativeRequirePath, @NotNull List<JsIrModuleHeader> transitiveExportFrom, @NotNull List<JsIrModuleHeader> importWithEffectFrom) {
        Intrinsics.checkNotNullParameter((Object)((Object)moduleKind), (String)"moduleKind");
        Intrinsics.checkNotNullParameter((Object)header, (String)"header");
        Intrinsics.checkNotNullParameter(transitiveExportFrom, (String)"transitiveExportFrom");
        Intrinsics.checkNotNullParameter(importWithEffectFrom, (String)"importWithEffectFrom");
        this.moduleKind = moduleKind;
        this.header = header;
        this.relativeRequirePath = relativeRequirePath;
        this.transitiveExportFrom = transitiveExportFrom;
        this.importWithEffectFrom = importWithEffectFrom;
        this.imports = new ArrayList();
        this.exports = new LinkedHashSet();
    }

    @NotNull
    public final ModuleKind getModuleKind() {
        return this.moduleKind;
    }

    @NotNull
    public final JsIrModuleHeader getHeader() {
        return this.header;
    }

    public final boolean getRelativeRequirePath() {
        return this.relativeRequirePath;
    }

    @NotNull
    public final List<JsIrModuleHeader> getTransitiveExportFrom() {
        return this.transitiveExportFrom;
    }

    @NotNull
    public final List<JsIrModuleHeader> getImportWithEffectFrom() {
        return this.importWithEffectFrom;
    }

    @NotNull
    public final List<CrossModuleRef> getImports() {
        return this.imports;
    }

    @NotNull
    public final Set<String> getExports() {
        return this.exports;
    }

    @NotNull
    public final Map<String, String> getExportNames() {
        Map<String, String> map = this.exportNames;
        if (map != null) {
            return map;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"exportNames");
        return null;
    }

    public final void setExportNames(@NotNull Map<String, String> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.exportNames = map;
    }

    /*
     * WARNING - void declaration
     */
    public final void buildExportNames(int startIndex) {
        void $this$associateWith$iv;
        int index = 0;
        index = startIndex;
        Iterable iterable = CollectionsKt.sorted((Iterable)this.exports);
        JsIrModuleCrossModuleReferenceBuilder jsIrModuleCrossModuleReferenceBuilder = this;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        void $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            String string2;
            String string3 = (String)element$iv$iv;
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            if (this.moduleKind == ModuleKind.ES) {
                void tag;
                string2 = this.header.getNameBindings().get(tag) + CityHashKt.cityHash64String((String)tag);
            } else {
                int n = index;
                index = n + 1;
                string2 = NameTablesKt.toJsIdentifier(n);
            }
            String string4 = string2;
            map.put(t, string4);
        }
        jsIrModuleCrossModuleReferenceBuilder.setExportNames(result$iv);
    }

    public static /* synthetic */ void buildExportNames$default(JsIrModuleCrossModuleReferenceBuilder jsIrModuleCrossModuleReferenceBuilder, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        jsIrModuleCrossModuleReferenceBuilder.buildExportNames(n);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CrossModuleReferences buildCrossModuleRefs() {
        void $this$mapTo$iv$iv;
        Object element$iv$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        Object object;
        Iterable $this$associateTo$iv$iv;
        boolean isImportOptional = this.moduleKind == ModuleKind.ES;
        Map importedModules = new LinkedHashMap();
        Iterable $this$associate$iv = this.imports;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Object destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            String exportedAs;
            object = destination$iv$iv;
            CrossModuleRef crossModuleRef = (CrossModuleRef)element$iv$iv;
            boolean bl = false;
            String tag = crossModuleRef.getTag();
            Intrinsics.checkNotNull((Object)crossModuleRef.getModule().getExportNames().get(tag));
            JsImportedModule importedModule = JsIrModuleCrossModuleReferenceBuilder.buildCrossModuleRefs$import(isImportOptional, this, importedModules, crossModuleRef.getModule().header);
            crossModuleRef = TuplesKt.to((Object)tag, (Object)new CrossModuleImport(exportedAs, importedModule));
            object.put(crossModuleRef.getFirst(), crossModuleRef.getSecond());
        }
        Map resultImports = destination$iv$iv;
        Iterable $this$mapNotNull$iv = this.transitiveExportFrom;
        boolean $i$f$mapNotNull = false;
        $this$associateTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        object = $this$forEach$iv$iv$iv.iterator();
        while (object.hasNext()) {
            CrossModuleTransitiveExport crossModuleTransitiveExport;
            Object element$iv$iv = element$iv$iv$iv = object.next();
            boolean bl = false;
            JsIrModuleHeader it = (JsIrModuleHeader)element$iv$iv;
            boolean bl2 = false;
            if (it.getReexportedInModuleWithName() != null) {
                boolean bl3 = false;
                JsName jsName = JsIrModuleCrossModuleReferenceBuilder.buildCrossModuleRefs$import(isImportOptional, this, importedModules, it).getInternalName();
                String string2 = this.relativeRequirePath(it);
                if (string2 == null) {
                    string2 = it.getExternalModuleName();
                }
                crossModuleTransitiveExport = new CrossModuleTransitiveExport(jsName, string2);
            } else {
                crossModuleTransitiveExport = null;
            }
            if (crossModuleTransitiveExport == null) continue;
            CrossModuleTransitiveExport it$iv$iv = crossModuleTransitiveExport;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List transitiveExport = (List)destination$iv$iv;
        Iterable $this$map$iv = this.importWithEffectFrom;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            element$iv$iv$iv = (JsIrModuleHeader)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(new CrossModuleImportWithEffect(JsIrModuleCrossModuleReferenceBuilder.buildCrossModuleRefs$import(isImportOptional, this, importedModules, (JsIrModuleHeader)it)));
        }
        List importsWithEffect = (List)destination$iv$iv2;
        return new CrossModuleReferences(this.moduleKind, CollectionsKt.toList((Iterable)importedModules.values()), transitiveExport, importsWithEffect, this.getExportNames(), resultImports);
    }

    private final JsImportedModule toJsImportedModule(JsIrModuleHeader $this$toJsImportedModule) {
        JsName jsModuleName = new JsName($this$toJsImportedModule.getModuleName(), false);
        String relativeRequirePath = this.relativeRequirePath($this$toJsImportedModule);
        return new JsImportedModule($this$toJsImportedModule.getExternalModuleName(), jsModuleName, null, relativeRequirePath);
    }

    private final String relativeRequirePath(JsIrModuleHeader moduleHeader) {
        String relativePath;
        String string2;
        if (!this.relativeRequirePath) {
            return null;
        }
        File file2 = new File(this.header.getExternalModuleName()).getParentFile();
        if (file2 == null) {
            return "./" + moduleHeader.getExternalModuleName();
        }
        File parentMain = file2;
        String string3 = FilesKt.toRelativeString((File)new File(moduleHeader.getExternalModuleName()), (File)parentMain);
        String string4 = File.separator;
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"separator");
        String it = string2 = (relativePath = StringsKt.replace$default((String)string3, (String)string4, (String)"/", (boolean)false, (int)4, null));
        boolean bl = false;
        String string5 = StringsKt.startsWith$default((String)it, (String)"../", (boolean)false, (int)2, null) ? string2 : null;
        if (string5 == null) {
            string5 = "./" + relativePath;
        }
        return string5;
    }

    private static final JsImportedModule buildCrossModuleRefs$import(boolean isImportOptional, JsIrModuleCrossModuleReferenceBuilder this$0, Map<JsIrModuleHeader, JsImportedModule> importedModules, JsIrModuleHeader moduleHeader) {
        JsImportedModule jsImportedModule;
        if (isImportOptional) {
            jsImportedModule = this$0.toJsImportedModule(moduleHeader);
        } else {
            JsImportedModule jsImportedModule2;
            Map<JsIrModuleHeader, JsImportedModule> $this$getOrPut$iv = importedModules;
            boolean $i$f$getOrPut = false;
            JsImportedModule value$iv = $this$getOrPut$iv.get(moduleHeader);
            if (value$iv == null) {
                boolean bl = false;
                JsImportedModule answer$iv = this$0.toJsImportedModule(moduleHeader);
                $this$getOrPut$iv.put(moduleHeader, answer$iv);
                jsImportedModule2 = answer$iv;
            } else {
                jsImportedModule2 = value$iv;
            }
            jsImportedModule = jsImportedModule2;
        }
        return jsImportedModule;
    }
}

