/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.cc.impl;

import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.internal.artifacts.configurations.ProjectComponentObservationListener;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.execution.plan.Node;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.service.scopes.ParallelListener;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.util.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParallelListener
@ServiceScope(value={Scope.Build.class})
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\bH\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000fH\u0002J\u001a\u0010\u0014\u001a\u00020\r2\b\u0010\u0015\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0016\u001a\u00020\tH\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000b2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00190\u001cR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R0\u0010\u0007\u001a$\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t \n*\u0010\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t0\u000b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/gradle/internal/cc/impl/RelevantProjectsRegistry;", "Lorg/gradle/api/internal/artifacts/configurations/ProjectComponentObservationListener;", "build", "Lorg/gradle/internal/build/BuildState;", "projectStateRegistry", "Lorg/gradle/api/internal/project/ProjectStateRegistry;", "(Lorg/gradle/internal/build/BuildState;Lorg/gradle/api/internal/project/ProjectStateRegistry;)V", "targetProjects", "", "Lorg/gradle/util/Path;", "kotlin.jvm.PlatformType", "", "collect", "", "project", "Lorg/gradle/api/internal/project/ProjectState;", "projects", "isLocalProject", "", "projectState", "projectObserved", "consumingProjectPath", "targetProjectPath", "projectStateOf", "node", "Lorg/gradle/execution/plan/Node;", "relevantProjects", "nodes", "", "configuration-cache"})
public final class RelevantProjectsRegistry
implements ProjectComponentObservationListener {
    @NotNull
    private final BuildState build;
    @NotNull
    private final ProjectStateRegistry projectStateRegistry;
    @NotNull
    private final Set<Path> targetProjects;

    public RelevantProjectsRegistry(@NotNull BuildState build, @NotNull ProjectStateRegistry projectStateRegistry) {
        Intrinsics.checkNotNullParameter((Object)build, (String)"build");
        Intrinsics.checkNotNullParameter((Object)projectStateRegistry, (String)"projectStateRegistry");
        this.build = build;
        this.projectStateRegistry = projectStateRegistry;
        Set set = Sets.newConcurrentHashSet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"newConcurrentHashSet<Path>()");
        this.targetProjects = set;
    }

    @NotNull
    public final Set<ProjectState> relevantProjects(@NotNull List<? extends Node> nodes) {
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        Set result2 = new LinkedHashSet();
        for (Path path : this.targetProjects) {
            ProjectState projectState = this.projectStateRegistry.stateFor(path);
            Intrinsics.checkNotNullExpressionValue((Object)projectState, (String)"projectStateRegistry.stateFor(project)");
            this.collect(projectState, result2);
        }
        for (Node node : nodes) {
            ProjectState project = this.projectStateOf(node);
            if (project == null || !this.isLocalProject(project)) continue;
            this.collect(project, result2);
        }
        return result2;
    }

    private final void collect(ProjectState project, Set<ProjectState> projects) {
        if (!projects.add(project)) {
            return;
        }
        ProjectState parent = project.getParent();
        if (parent != null) {
            this.collect(parent, projects);
        }
    }

    private final ProjectState projectStateOf(Node node) {
        ProjectInternal projectInternal = node.getOwningProject();
        return projectInternal != null ? projectInternal.getOwner() : null;
    }

    private final boolean isLocalProject(ProjectState projectState) {
        return projectState.getOwner() == this.build;
    }

    public void projectObserved(@Nullable Path consumingProjectPath, @NotNull Path targetProjectPath) {
        Intrinsics.checkNotNullParameter((Object)targetProjectPath, (String)"targetProjectPath");
        this.targetProjects.add(targetProjectPath);
    }
}

