/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.concurrent.ThreadSafe;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvableArtifact;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariant;
import org.gradle.api.internal.artifacts.transform.ComponentVariantIdentifier;
import org.gradle.api.internal.artifacts.transform.TransformChain;
import org.gradle.api.internal.artifacts.transform.TransformStep;
import org.gradle.api.internal.artifacts.transform.TransformStepNode;
import org.gradle.api.internal.artifacts.transform.TransformStepNodeFactory;
import org.gradle.api.internal.artifacts.transform.TransformUpstreamDependencies;
import org.gradle.api.internal.artifacts.transform.TransformUpstreamDependenciesResolver;
import org.gradle.api.internal.artifacts.transform.TransformedExternalArtifactSet;
import org.gradle.api.internal.artifacts.transform.TransformedProjectArtifactSet;
import org.gradle.api.internal.artifacts.transform.TransformedVariantFactory;
import org.gradle.api.internal.artifacts.transform.VariantDefinition;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.component.model.VariantResolveMetadata;
import org.gradle.internal.model.CalculatedValueContainerFactory;
import org.gradle.internal.operations.BuildOperationRunner;

@ThreadSafe
public class DefaultTransformedVariantFactory
implements TransformedVariantFactory {
    private final BuildOperationRunner buildOperationRunner;
    private final CalculatedValueContainerFactory calculatedValueContainerFactory;
    private final TransformStepNodeFactory transformStepNodeFactory;
    private final ConcurrentMap<VariantKey, ResolvedArtifactSet> variants = new ConcurrentHashMap<VariantKey, ResolvedArtifactSet>();

    public DefaultTransformedVariantFactory(BuildOperationRunner buildOperationRunner, CalculatedValueContainerFactory calculatedValueContainerFactory, TransformStepNodeFactory transformStepNodeFactory) {
        this.buildOperationRunner = buildOperationRunner;
        this.calculatedValueContainerFactory = calculatedValueContainerFactory;
        this.transformStepNodeFactory = transformStepNodeFactory;
    }

    @Override
    public ResolvedArtifactSet transformedExternalArtifacts(ComponentIdentifier componentIdentifier, ResolvedVariant sourceVariant, VariantDefinition variantDefinition, TransformUpstreamDependenciesResolver dependenciesResolver) {
        return this.locateOrCreate(this::doCreateExternal, componentIdentifier, sourceVariant, variantDefinition, dependenciesResolver);
    }

    @Override
    public ResolvedArtifactSet transformedProjectArtifacts(ComponentIdentifier componentIdentifier, ResolvedVariant sourceVariant, VariantDefinition variantDefinition, TransformUpstreamDependenciesResolver dependenciesResolver) {
        return this.locateOrCreate(this::doCreateProject, componentIdentifier, sourceVariant, variantDefinition, dependenciesResolver);
    }

    private ResolvedArtifactSet locateOrCreate(Factory factory, ComponentIdentifier componentIdentifier, ResolvedVariant sourceVariant, VariantDefinition variantDefinition, TransformUpstreamDependenciesResolver dependenciesResolver) {
        ResolvedArtifactSet newResult;
        ImmutableAttributes target = variantDefinition.getTargetAttributes();
        TransformChain transformChain = variantDefinition.getTransformChain();
        VariantResolveMetadata.Identifier identifier = sourceVariant.getIdentifier();
        if (identifier == null) {
            return factory.create(componentIdentifier, sourceVariant, variantDefinition, dependenciesResolver);
        }
        VariantKey variantKey = transformChain.requiresDependencies() ? new VariantWithUpstreamDependenciesKey(identifier, target, dependenciesResolver) : new VariantKey(identifier, target);
        ResolvedArtifactSet result = (ResolvedArtifactSet)this.variants.get(variantKey);
        if (result == null && (result = this.variants.putIfAbsent(variantKey, newResult = factory.create(componentIdentifier, sourceVariant, variantDefinition, dependenciesResolver))) == null) {
            result = newResult;
        }
        return result;
    }

    private TransformedExternalArtifactSet doCreateExternal(ComponentIdentifier componentIdentifier, ResolvedVariant sourceVariant, VariantDefinition variantDefinition, TransformUpstreamDependenciesResolver dependenciesResolver) {
        return new TransformedExternalArtifactSet(componentIdentifier, sourceVariant.getArtifacts(), variantDefinition.getTargetAttributes(), sourceVariant.getCapabilities(), variantDefinition.getTransformChain(), dependenciesResolver, this.calculatedValueContainerFactory);
    }

    private TransformedProjectArtifactSet doCreateProject(ComponentIdentifier componentIdentifier, ResolvedVariant sourceVariant, VariantDefinition variantDefinition, TransformUpstreamDependenciesResolver dependenciesResolver) {
        ResolvedArtifactSet sourceArtifacts;
        ImmutableAttributes sourceAttributes;
        VariantDefinition previous = variantDefinition.getPrevious();
        if (previous != null) {
            sourceAttributes = previous.getTargetAttributes();
            sourceArtifacts = this.transformedProjectArtifacts(componentIdentifier, sourceVariant, previous, dependenciesResolver);
        } else {
            sourceAttributes = sourceVariant.getAttributes();
            sourceArtifacts = sourceVariant.getArtifacts();
        }
        ComponentVariantIdentifier targetComponentVariant = new ComponentVariantIdentifier(componentIdentifier, (AttributeContainer)variantDefinition.getTargetAttributes(), sourceVariant.getCapabilities());
        List<TransformStepNode> transformStepNodes = this.createTransformStepNodes(sourceArtifacts, (AttributeContainer)sourceAttributes, targetComponentVariant, variantDefinition, dependenciesResolver);
        return new TransformedProjectArtifactSet(targetComponentVariant, transformStepNodes);
    }

    private List<TransformStepNode> createTransformStepNodes(ResolvedArtifactSet sourceArtifacts, final AttributeContainer sourceAttributes, final ComponentVariantIdentifier targetComponentVariant, VariantDefinition variantDefinition, final TransformUpstreamDependenciesResolver dependenciesResolver) {
        final ComponentIdentifier componentId = targetComponentVariant.getComponentId();
        final TransformStep transformStep = variantDefinition.getTransformStep();
        final ImmutableList.Builder builder = ImmutableList.builder();
        sourceArtifacts.visitTransformSources(new ResolvedArtifactSet.TransformSourceVisitor(){

            @Override
            public void visitArtifact(ResolvableArtifact artifact) {
                TransformUpstreamDependencies upstreamDependencies = dependenciesResolver.dependenciesFor(componentId, transformStep);
                TransformStepNode.InitialTransformStepNode transformStepNode = DefaultTransformedVariantFactory.this.transformStepNodeFactory.createInitial(targetComponentVariant, sourceAttributes, transformStep, artifact, upstreamDependencies, DefaultTransformedVariantFactory.this.buildOperationRunner, DefaultTransformedVariantFactory.this.calculatedValueContainerFactory);
                builder.add((Object)transformStepNode);
            }

            @Override
            public void visitTransform(TransformStepNode source) {
                TransformUpstreamDependencies upstreamDependencies = dependenciesResolver.dependenciesFor(componentId, transformStep);
                TransformStepNode.ChainedTransformStepNode transformStepNode = DefaultTransformedVariantFactory.this.transformStepNodeFactory.createChained(targetComponentVariant, sourceAttributes, transformStep, source, upstreamDependencies, DefaultTransformedVariantFactory.this.buildOperationRunner, DefaultTransformedVariantFactory.this.calculatedValueContainerFactory);
                builder.add((Object)transformStepNode);
            }
        });
        return builder.build();
    }

    private static interface Factory {
        public ResolvedArtifactSet create(ComponentIdentifier var1, ResolvedVariant var2, VariantDefinition var3, TransformUpstreamDependenciesResolver var4);
    }

    private static class VariantWithUpstreamDependenciesKey
    extends VariantKey {
        private final TransformUpstreamDependenciesResolver dependenciesResolver;

        public VariantWithUpstreamDependenciesKey(VariantResolveMetadata.Identifier sourceVariant, ImmutableAttributes target, TransformUpstreamDependenciesResolver dependenciesResolver) {
            super(sourceVariant, target);
            this.dependenciesResolver = dependenciesResolver;
        }

        @Override
        public int hashCode() {
            return super.hashCode() ^ this.dependenciesResolver.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            VariantWithUpstreamDependenciesKey other = (VariantWithUpstreamDependenciesKey)obj;
            return this.dependenciesResolver.equals(other.dependenciesResolver);
        }
    }

    private static class VariantKey {
        private final VariantResolveMetadata.Identifier sourceVariant;
        private final ImmutableAttributes target;

        public VariantKey(VariantResolveMetadata.Identifier sourceVariant, ImmutableAttributes target) {
            this.sourceVariant = sourceVariant;
            this.target = target;
        }

        public int hashCode() {
            return this.sourceVariant.hashCode() ^ this.target.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            VariantKey other = (VariantKey)obj;
            return this.sourceVariant.equals(other.sourceVariant) && this.target.equals(other.target);
        }
    }
}

