/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.plan;

import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.NonNullApi;
import org.gradle.api.Task;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.tasks.CachingTaskDependencyResolveContext;
import org.gradle.execution.plan.DependencyResolver;
import org.gradle.execution.plan.Node;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;

@NonNullApi
@ServiceScope(value={Scope.Build.class})
public class TaskDependencyResolver {
    private final List<DependencyResolver> dependencyResolvers;
    private CachingTaskDependencyResolveContext<Node> context;

    public TaskDependencyResolver(List<DependencyResolver> dependencyResolvers) {
        this.dependencyResolvers = dependencyResolvers;
        this.context = TaskDependencyResolver.createTaskDependencyResolverContext(dependencyResolvers);
    }

    public void clear() {
        this.context = TaskDependencyResolver.createTaskDependencyResolverContext(this.dependencyResolvers);
    }

    private static CachingTaskDependencyResolveContext<Node> createTaskDependencyResolverContext(List<DependencyResolver> workResolvers) {
        return new CachingTaskDependencyResolveContext(workResolvers);
    }

    public Set<Node> resolveDependenciesFor(@Nullable TaskInternal task, Object dependencies) {
        return this.context.getDependencies((Task)task, dependencies);
    }
}

