/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.devel.tasks.internal;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.gradle.api.problems.AdditionalData;
import org.gradle.api.problems.DocLink;
import org.gradle.api.problems.FileLocation;
import org.gradle.api.problems.LineInFileLocation;
import org.gradle.api.problems.OffsetInFileLocation;
import org.gradle.api.problems.ProblemGroup;
import org.gradle.api.problems.ProblemId;
import org.gradle.api.problems.ProblemLocation;
import org.gradle.api.problems.internal.DefaultDeprecationData;
import org.gradle.api.problems.internal.DefaultFileLocation;
import org.gradle.api.problems.internal.DefaultGeneralData;
import org.gradle.api.problems.internal.DefaultLineInFileLocation;
import org.gradle.api.problems.internal.DefaultOffsetInFileLocation;
import org.gradle.api.problems.internal.DefaultPluginIdLocation;
import org.gradle.api.problems.internal.DefaultProblem;
import org.gradle.api.problems.internal.DefaultPropertyTraceData;
import org.gradle.api.problems.internal.DefaultTaskPathLocation;
import org.gradle.api.problems.internal.DefaultTypeValidationData;
import org.gradle.api.problems.internal.DeprecationData;
import org.gradle.api.problems.internal.GeneralData;
import org.gradle.api.problems.internal.InternalDocLink;
import org.gradle.api.problems.internal.InternalProblem;
import org.gradle.api.problems.internal.PropertyTraceData;
import org.gradle.api.problems.internal.TypeValidationData;
import org.gradle.internal.reflect.validation.TypeValidationProblemRenderer;
import org.gradle.plugin.devel.tasks.internal.ProblemReportAdapterFactory;

@Nonnull
public class ValidationProblemSerialization {
    private static final GsonBuilder GSON_BUILDER = ValidationProblemSerialization.createGsonBuilder();

    public static List<? extends InternalProblem> parseMessageList(String lines) {
        Gson gson = GSON_BUILDER.create();
        Type type = new TypeToken<List<DefaultProblem>>(){}.getType();
        return (List)gson.fromJson(lines, type);
    }

    public static GsonBuilder createGsonBuilder() {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new ProblemReportAdapterFactory());
        gsonBuilder.registerTypeAdapter(ProblemId.class, (Object)new ProblemIdInstanceCreator());
        gsonBuilder.registerTypeHierarchyAdapter(DocLink.class, (Object)new DocLinkAdapter());
        gsonBuilder.registerTypeHierarchyAdapter(ProblemLocation.class, (Object)new LocationAdapter());
        gsonBuilder.registerTypeHierarchyAdapter(AdditionalData.class, (Object)new AdditionalDataAdapter());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new ThrowableAdapterFactory());
        return gsonBuilder;
    }

    public static Stream<String> toPlainMessage(List<? extends InternalProblem> problems) {
        return problems.stream().map(problem -> problem.getDefinition().getSeverity() + ": " + TypeValidationProblemRenderer.renderMinimalInformationAbout((InternalProblem)problem));
    }

    private static class ProblemIdInstanceCreator
    implements JsonDeserializer<ProblemId>,
    JsonSerializer<ProblemId> {
        private ProblemIdInstanceCreator() {
        }

        public ProblemId deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            JsonObject problemObject = jsonElement.getAsJsonObject();
            String name = problemObject.get("name").getAsString();
            String displayName = problemObject.get("displayName").getAsString();
            ProblemGroup group = ProblemIdInstanceCreator.deserializeGroup(problemObject.get("group"));
            return ProblemId.create((String)name, (String)displayName, (ProblemGroup)group);
        }

        private static ProblemGroup deserializeGroup(JsonElement groupObject) {
            JsonObject group = groupObject.getAsJsonObject();
            String name = group.get("name").getAsString();
            String displayName = group.get("displayName").getAsString();
            JsonElement parent = group.get("parent");
            if (parent == null) {
                return ProblemGroup.create((String)name, (String)displayName);
            }
            return ProblemGroup.create((String)name, (String)displayName, (ProblemGroup)ProblemIdInstanceCreator.deserializeGroup(parent));
        }

        public JsonElement serialize(ProblemId problemId, Type type, JsonSerializationContext jsonSerializationContext) {
            JsonObject result = new JsonObject();
            result.addProperty("name", problemId.getName());
            result.addProperty("displayName", problemId.getDisplayName());
            result.add("group", (JsonElement)ProblemIdInstanceCreator.serializeGroup(problemId.getGroup()));
            return result;
        }

        private static JsonObject serializeGroup(ProblemGroup group) {
            JsonObject groupObject = new JsonObject();
            groupObject.addProperty("name", group.getName());
            groupObject.addProperty("displayName", group.getDisplayName());
            ProblemGroup parent = group.getParent();
            if (parent != null) {
                groupObject.add("parent", (JsonElement)ProblemIdInstanceCreator.serializeGroup(parent));
            }
            return groupObject;
        }
    }

    public static class DocLinkAdapter
    extends TypeAdapter<DocLink> {
        public void write(JsonWriter out, @Nullable DocLink value) throws IOException {
            if (value == null) {
                out.nullValue();
                return;
            }
            out.beginObject();
            out.name("url").value(value.getUrl());
            out.name("consultDocumentationMessage").value(((InternalDocLink)value).getConsultDocumentationMessage());
            out.endObject();
        }

        public DocLink read(JsonReader in) throws IOException {
            in.beginObject();
            String url = null;
            String consultDocumentationMessage = null;
            block8: while (in.hasNext()) {
                String name;
                switch (name = in.nextName()) {
                    case "url": {
                        url = in.nextString();
                        continue block8;
                    }
                    case "consultDocumentationMessage": {
                        consultDocumentationMessage = in.nextString();
                        continue block8;
                    }
                }
                in.skipValue();
            }
            in.endObject();
            final String finalUrl = url;
            final String finalConsultDocumentationMessage = consultDocumentationMessage;
            return new InternalDocLink(){

                public String getUrl() {
                    return finalUrl;
                }

                public String getConsultDocumentationMessage() {
                    return finalConsultDocumentationMessage;
                }
            };
        }
    }

    private static class LocationAdapter
    extends TypeAdapter<ProblemLocation> {
        private LocationAdapter() {
        }

        public void write(JsonWriter out, ProblemLocation value) throws IOException {
            if (value == null) {
                out.nullValue();
                return;
            }
            if (value instanceof DefaultFileLocation) {
                new FileLocationAdapter().write(out, (FileLocation)((DefaultFileLocation)value));
                return;
            }
            if (value instanceof DefaultPluginIdLocation) {
                new PluginIdLocationAdapter().write(out, (DefaultPluginIdLocation)value);
                return;
            }
            if (value instanceof DefaultTaskPathLocation) {
                new TaskLocationAdapter().write(out, (DefaultTaskPathLocation)value);
            }
        }

        public ProblemLocation read(JsonReader in) throws IOException {
            if (in.hasNext()) {
                in.beginObject();
                try {
                    String type = null;
                    String name = in.nextName();
                    if (name.equals("type")) {
                        type = in.nextString();
                    }
                    if (type == null) {
                        throw new JsonParseException("type must not be null");
                    }
                    switch (type) {
                        case "file": {
                            FileLocation fileLocation = FileLocationAdapter.readObject(in);
                            return fileLocation;
                        }
                        case "pluginId": {
                            DefaultPluginIdLocation defaultPluginIdLocation = PluginIdLocationAdapter.readObject(in);
                            return defaultPluginIdLocation;
                        }
                        case "task": {
                            DefaultTaskPathLocation defaultTaskPathLocation = TaskLocationAdapter.readObject(in);
                            return defaultTaskPathLocation;
                        }
                    }
                    throw new JsonParseException("Unknown type: " + type);
                }
                finally {
                    in.endObject();
                }
            }
            return null;
        }
    }

    private static class AdditionalDataAdapter
    extends TypeAdapter<AdditionalData> {
        public static final String PROPERTY_TRACE_DATA = "propertyTraceData";
        public static final String PROPERTY_TRACE = "propertyTrace";
        public static final String ADDITIONAL_DATA_TYPE = "type";
        public static final String DEPRECATION_DATA = "deprecationData";
        public static final String TYPE_VALIDATION_DATA = "typeValidationData";
        public static final String GENERAL_DATA = "generalData";
        public static final String FEATURE_USAGE = "featureUsage";
        public static final String PLUGIN_ID = "pluginId";
        public static final String PROPERTY_NAME = "propertyName";
        public static final String FUNCTION_NAME = "functionName";
        public static final String PARENT_PROPERTY_NAME = "parentPropertyName";
        public static final String TYPE_NAME = "typeName";
        public static final String GENERAL_DATA_DATA = "data";

        private AdditionalDataAdapter() {
        }

        public void write(JsonWriter out, AdditionalData value) throws IOException {
            if (value == null) {
                out.nullValue();
                return;
            }
            out.beginObject();
            if (value instanceof DeprecationData) {
                out.name(ADDITIONAL_DATA_TYPE).value(DEPRECATION_DATA);
                out.name(FEATURE_USAGE).value(((DeprecationData)value).getType().name());
            } else if (value instanceof TypeValidationData) {
                out.name(ADDITIONAL_DATA_TYPE).value(TYPE_VALIDATION_DATA);
                TypeValidationData typeValidationData = (TypeValidationData)value;
                out.name(PLUGIN_ID).value(typeValidationData.getPluginId());
                out.name(PROPERTY_NAME).value(typeValidationData.getPropertyName());
                out.name(FUNCTION_NAME).value(typeValidationData.getFunctionName());
                out.name(PARENT_PROPERTY_NAME).value(typeValidationData.getParentPropertyName());
                out.name(TYPE_NAME).value(typeValidationData.getTypeName());
            } else if (value instanceof GeneralData) {
                out.name(ADDITIONAL_DATA_TYPE).value(GENERAL_DATA);
                out.name(GENERAL_DATA_DATA);
                out.beginObject();
                Map map = ((GeneralData)value).getAsMap();
                for (String key : map.keySet()) {
                    out.name(key).value((String)map.get(key));
                }
                out.endObject();
            } else if (value instanceof PropertyTraceData) {
                out.name(ADDITIONAL_DATA_TYPE).value(PROPERTY_TRACE_DATA);
                out.name(PROPERTY_TRACE).value(((PropertyTraceData)value).getTrace());
            }
            out.endObject();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AdditionalData read(JsonReader in) throws IOException {
            if (!in.hasNext()) {
                return null;
            }
            in.beginObject();
            try {
                String type = null;
                String featureUsage = null;
                String pluginId = null;
                String propertyName = null;
                String functionName = null;
                String parentPropertyName = null;
                String typeName = null;
                HashMap<String, String> generalData = null;
                String propertyTrace = null;
                block28: while (in.hasNext()) {
                    String name;
                    switch (name = in.nextName()) {
                        case "type": {
                            type = in.nextString();
                            break;
                        }
                        case "featureUsage": {
                            featureUsage = in.nextString();
                            break;
                        }
                        case "pluginId": {
                            pluginId = in.nextString();
                            break;
                        }
                        case "propertyName": {
                            propertyName = in.nextString();
                            break;
                        }
                        case "functionName": {
                            functionName = in.nextString();
                            break;
                        }
                        case "parentPropertyName": {
                            parentPropertyName = in.nextString();
                            break;
                        }
                        case "typeName": {
                            typeName = in.nextString();
                            break;
                        }
                        case "propertyTrace": {
                            propertyTrace = in.nextString();
                            break;
                        }
                        case "data": {
                            try {
                                in.beginObject();
                                generalData = new HashMap<String, String>();
                                while (in.hasNext()) {
                                    String key = in.nextName();
                                    String value = in.nextString();
                                    generalData.put(key, value);
                                }
                                continue block28;
                            }
                            finally {
                                in.endObject();
                                continue block28;
                            }
                        }
                        default: {
                            in.skipValue();
                        }
                    }
                }
                if (type == null) {
                    throw new JsonParseException("type must not be null");
                }
                String string = AdditionalDataAdapter.createAdditionalData(type, featureUsage, pluginId, propertyName, functionName, parentPropertyName, typeName, generalData, propertyTrace);
                return string;
            }
            finally {
                in.endObject();
            }
        }

        @Nonnull
        private static AdditionalData createAdditionalData(String type, String featureUsage, String pluginId, String propertyName, String methodName, String parentPropertyName, String typeName, Map<String, String> generalData, String propertyTrace) {
            switch (type) {
                case "deprecationData": {
                    return new DefaultDeprecationData(DeprecationData.Type.valueOf((String)featureUsage));
                }
                case "typeValidationData": {
                    return new DefaultTypeValidationData(pluginId, propertyName, methodName, parentPropertyName, typeName);
                }
                case "generalData": {
                    return new DefaultGeneralData(generalData);
                }
                case "propertyTraceData": {
                    return new DefaultPropertyTraceData(propertyTrace);
                }
            }
            throw new JsonParseException("Unknown type: " + type);
        }
    }

    public static class ThrowableAdapterFactory
    implements TypeAdapterFactory {
        @Nullable
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
            if (!Throwable.class.isAssignableFrom(typeToken.getRawType())) {
                return null;
            }
            return new ThrowableTypeAdapter(typeToken);
        }
    }

    public static class TaskLocationAdapter
    extends TypeAdapter<DefaultTaskPathLocation> {
        public void write(JsonWriter out, @Nullable DefaultTaskPathLocation value) throws IOException {
            if (value == null) {
                out.nullValue();
                return;
            }
            out.beginArray();
            out.name("type").value("task");
            out.name("buildTreePath").value(value.getBuildTreePath());
            out.endObject();
        }

        public DefaultTaskPathLocation read(JsonReader in) throws IOException {
            in.beginObject();
            DefaultTaskPathLocation buildTreePath = TaskLocationAdapter.readObject(in);
            in.endObject();
            Objects.requireNonNull(buildTreePath, "buildTreePath must not be null");
            return buildTreePath;
        }

        @Nonnull
        private static DefaultTaskPathLocation readObject(JsonReader in) throws IOException {
            String buildTreePath = null;
            while (in.hasNext()) {
                String name = in.nextName();
                if (name.equals("buildTreePath")) {
                    buildTreePath = in.nextString();
                    continue;
                }
                in.skipValue();
            }
            return new DefaultTaskPathLocation(buildTreePath);
        }
    }

    public static class PluginIdLocationAdapter
    extends TypeAdapter<DefaultPluginIdLocation> {
        public void write(JsonWriter out, @Nullable DefaultPluginIdLocation value) throws IOException {
            if (value == null) {
                out.nullValue();
                return;
            }
            out.beginArray();
            out.name("type").value("pluginId");
            out.name("pluginId").value(value.getPluginId());
            out.endObject();
        }

        public DefaultPluginIdLocation read(JsonReader in) throws IOException {
            in.beginObject();
            DefaultPluginIdLocation problemLocation = PluginIdLocationAdapter.readObject(in);
            in.endObject();
            Objects.requireNonNull(problemLocation, "pluginId must not be null");
            return problemLocation;
        }

        private static DefaultPluginIdLocation readObject(JsonReader in) throws IOException {
            String pluginId = null;
            while (in.hasNext()) {
                String name = in.nextName();
                if (name.equals("pluginId")) {
                    pluginId = in.nextString();
                    continue;
                }
                in.skipValue();
            }
            return new DefaultPluginIdLocation(pluginId);
        }
    }

    public static class FileLocationAdapter
    extends TypeAdapter<FileLocation> {
        public void write(JsonWriter out, @Nullable FileLocation value) throws IOException {
            if (value == null) {
                out.nullValue();
                return;
            }
            out.beginObject();
            out.name("type").value("file");
            out.name("path").value(value.getPath());
            if (value instanceof LineInFileLocation) {
                out.name("subtype").value("lineInFile");
                LineInFileLocation l = (LineInFileLocation)value;
                out.name("line").value((long)l.getLine());
                out.name("column").value((long)l.getColumn());
                out.name("length").value((long)l.getLength());
            } else if (value instanceof OffsetInFileLocation) {
                out.name("subtype").value("offsetInFile");
                OffsetInFileLocation l = (OffsetInFileLocation)value;
                out.name("offset").value((long)l.getOffset());
                out.name("length").value((long)l.getLength());
            } else {
                out.name("subtype").value("file");
            }
            out.endObject();
        }

        public FileLocation read(JsonReader in) throws IOException {
            in.beginObject();
            FileLocation fileLocation = FileLocationAdapter.readObject(in);
            in.endObject();
            Objects.requireNonNull(fileLocation, "path must not be null");
            return fileLocation;
        }

        @Nonnull
        private static FileLocation readObject(JsonReader in) throws IOException {
            String subtype = null;
            String path = null;
            Integer offset = null;
            Integer line = null;
            Integer column = null;
            Integer length = null;
            block16: while (in.hasNext()) {
                String name;
                switch (name = in.nextName()) {
                    case "subtype": {
                        subtype = in.nextString();
                        continue block16;
                    }
                    case "path": {
                        path = in.nextString();
                        continue block16;
                    }
                    case "offset": {
                        offset = in.nextInt();
                        continue block16;
                    }
                    case "line": {
                        line = in.nextInt();
                        continue block16;
                    }
                    case "column": {
                        column = in.nextInt();
                        continue block16;
                    }
                    case "length": {
                        length = in.nextInt();
                        continue block16;
                    }
                }
                in.skipValue();
            }
            if (subtype.equals("lineInFile")) {
                return DefaultLineInFileLocation.from(path, line, column, length);
            }
            if (subtype.equals("offsetInFile")) {
                return DefaultOffsetInFileLocation.from(path, (int)offset, (int)length);
            }
            return DefaultFileLocation.from(path);
        }
    }

    public static class ThrowableTypeAdapter
    extends TypeAdapter<Throwable> {
        private final TypeToken<Throwable> typeToken;

        public ThrowableTypeAdapter(TypeToken<Throwable> typeToken) {
            this.typeToken = typeToken;
        }

        @Nullable
        public Throwable read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            in.beginObject();
            String message = null;
            Throwable cause = null;
            block11: while (in.hasNext()) {
                String name;
                switch (name = in.nextName()) {
                    case "message": {
                        message = in.nextString();
                        continue block11;
                    }
                    case "cause": {
                        cause = this.read(in);
                        continue block11;
                    }
                }
                in.skipValue();
            }
            in.endObject();
            try {
                Constructor constructor;
                if (message == null && cause == null) {
                    constructor = this.typeToken.getRawType().getDeclaredConstructor(new Class[0]);
                    return (Throwable)constructor.newInstance(new Object[0]);
                }
                if (message == null) {
                    constructor = this.typeToken.getRawType().getDeclaredConstructor(Throwable.class);
                    return (Throwable)constructor.newInstance(cause);
                }
                if (cause == null) {
                    constructor = this.typeToken.getRawType().getDeclaredConstructor(String.class);
                    return (Throwable)constructor.newInstance(message);
                }
                constructor = this.typeToken.getRawType().getDeclaredConstructor(String.class, Throwable.class);
                return (Throwable)constructor.newInstance(message, cause);
            }
            catch (NoSuchMethodException e) {
                if (message == null && cause == null) {
                    return new RuntimeException();
                }
                if (message == null) {
                    return new RuntimeException(cause);
                }
                if (cause == null) {
                    return new RuntimeException(message);
                }
                return new RuntimeException(message, cause);
            }
            catch (Exception e) {
                throw new JsonParseException((Throwable)e);
            }
        }

        public void write(JsonWriter out, @Nullable Throwable throwable) throws IOException {
            if (throwable == null) {
                out.nullValue();
            } else if (throwable.getMessage() == null && throwable.getCause() != null) {
                this.write(out, throwable.getCause());
            } else {
                out.beginObject();
                if (throwable.getMessage() != null) {
                    out.name("message");
                    out.value(throwable.getMessage());
                }
                if (ThrowableTypeAdapter.shouldWriteCause(throwable)) {
                    out.name("cause");
                    this.write(out, throwable.getCause());
                }
                out.endObject();
            }
        }

        private static boolean shouldWriteCause(Throwable throwable) {
            Throwable cause = throwable.getCause();
            if (cause == null || cause.getMessage() == null || cause == throwable) {
                return false;
            }
            return throwable.getMessage() == null || !throwable.getMessage().contains(cause.getMessage());
        }
    }
}

