/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import org.gradle.initialization.BuildEventConsumer;
import org.gradle.internal.build.event.types.DefaultInternalProxiedAdditionalData;
import org.gradle.internal.build.event.types.DefaultProblemDetails;
import org.gradle.internal.build.event.types.DefaultProblemEvent;
import org.gradle.tooling.internal.protocol.problem.InternalAdditionalData;
import org.gradle.tooling.internal.protocol.problem.InternalPayloadSerializedAdditionalData;
import org.gradle.tooling.internal.protocol.problem.InternalProblemDetailsVersion2;
import org.gradle.tooling.internal.provider.serialization.PayloadSerializer;
import org.gradle.tooling.internal.provider.serialization.SerializedPayload;

public class ProblemAdditionalDataRemapper
implements BuildEventConsumer {
    private final PayloadSerializer payloadSerializer;
    private final BuildEventConsumer delegate;

    public ProblemAdditionalDataRemapper(PayloadSerializer payloadSerializer, BuildEventConsumer delegate) {
        this.payloadSerializer = payloadSerializer;
        this.delegate = delegate;
    }

    public void dispatch(Object message) {
        this.remapAdditionalData(message);
        this.delegate.dispatch(message);
    }

    private void remapAdditionalData(Object message) {
        if (!(message instanceof DefaultProblemEvent)) {
            return;
        }
        DefaultProblemEvent problemEvent = (DefaultProblemEvent)message;
        InternalProblemDetailsVersion2 details = problemEvent.getDetails();
        if (!(details instanceof DefaultProblemDetails)) {
            return;
        }
        InternalAdditionalData additionalData = ((DefaultProblemDetails)details).getAdditionalData();
        if (!(additionalData instanceof InternalPayloadSerializedAdditionalData)) {
            return;
        }
        InternalPayloadSerializedAdditionalData serializedAdditionalData = (InternalPayloadSerializedAdditionalData)additionalData;
        SerializedPayload serializedType = (SerializedPayload)serializedAdditionalData.getSerializedType();
        Map state = serializedAdditionalData.getAsMap();
        Class type = (Class)this.payloadSerializer.deserialize(serializedType);
        if (type == null) {
            return;
        }
        Object proxy = ProblemAdditionalDataRemapper.createProxy(type, state);
        ((DefaultProblemDetails)details).setAdditionalData((InternalAdditionalData)new DefaultInternalProxiedAdditionalData(state, proxy, serializedType));
    }

    public static <T> T createProxy(Class<T> interfaceType, Map<String, Object> state) {
        return (T)Proxy.newProxyInstance(interfaceType.getClassLoader(), new Class[]{interfaceType}, (InvocationHandler)new DeepCopyInvocationHandler(state));
    }

    private static class DeepCopyInvocationHandler
    implements InvocationHandler {
        private final Map<String, Object> state;

        public DeepCopyInvocationHandler(Map<String, Object> state) {
            this.state = state;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            return this.state.get(method.getName());
        }
    }
}

