/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics.internal.artifact.transforms.renderer;

import com.google.common.collect.Streams;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.tasks.diagnostics.internal.artifact.transforms.model.ArtifactTransformReportModel;
import org.gradle.api.tasks.diagnostics.internal.artifact.transforms.model.ReportArtifactTransform;
import org.gradle.api.tasks.diagnostics.internal.artifact.transforms.renderer.AbstractArtifactTransformReportRenderer;
import org.gradle.api.tasks.diagnostics.internal.artifact.transforms.spec.ArtifactTransformReportSpec;
import org.gradle.internal.logging.text.StyledTextOutput;

public final class ConsoleArtifactTransformReportRenderer
extends AbstractArtifactTransformReportRenderer<StyledTextOutput> {
    private final DocumentationRegistry documentationRegistry;
    private StyledTextOutput output;
    private int depth;

    public ConsoleArtifactTransformReportRenderer(ArtifactTransformReportSpec spec, DocumentationRegistry documentationRegistry) {
        super(spec);
        this.documentationRegistry = documentationRegistry;
    }

    public void render(ArtifactTransformReportModel model, StyledTextOutput output) {
        boolean hasAnyTransforms;
        this.depth = 0;
        this.output = output;
        boolean searchingByType = this.spec.getSearchTarget().isPresent();
        ArtifactTransformReportModel modelToReport = searchingByType ? this.spec.getSearchTarget().map(model::filterTransformsByType).orElse(model) : model;
        boolean bl = hasAnyTransforms = !modelToReport.getTransforms().isEmpty();
        if (hasAnyTransforms) {
            this.writeResults(modelToReport);
        } else {
            this.writeCompleteAbsenceOfResults(modelToReport, searchingByType);
        }
    }

    private void writeResults(ArtifactTransformReportModel data) {
        this.writeArtifactTransforms(data.getTransforms());
        this.writeSuggestions(data.getTransforms());
    }

    private void writeArtifactTransforms(List<ReportArtifactTransform> artifactTransforms) {
        artifactTransforms.forEach(this::writeArtifactTransform);
    }

    private void writeArtifactTransform(ReportArtifactTransform artifactTransform) {
        this.writeArtifactTransformNameHeader(artifactTransform);
        this.writeType(artifactTransform);
        this.writeAttributes(artifactTransform);
        this.newLine();
    }

    private void writeArtifactTransformNameHeader(ReportArtifactTransform artifactTransform) {
        this.printHeader(() -> this.output.style(StyledTextOutput.Style.Identifier).println((Object)artifactTransform.getDisplayName()));
    }

    private void writeType(ReportArtifactTransform artifactTransform) {
        this.output.style(StyledTextOutput.Style.Description).text((Object)"Type: ");
        this.output.style(StyledTextOutput.Style.Normal).println((Object)artifactTransform.getTransformClass().getName());
        this.output.style(StyledTextOutput.Style.Description).text((Object)"Cacheable: ");
        this.output.style(StyledTextOutput.Style.Normal).println((Object)(artifactTransform.isCacheable() ? "Yes" : "No"));
    }

    private void writeAttributes(ReportArtifactTransform artifactTransform) {
        Integer maxNameLength = Streams.concat((Stream[])new Stream[]{artifactTransform.getFromAttributes().keySet().stream(), artifactTransform.getToAttributes().keySet().stream()}).map(a -> a.getName().length()).max(Integer::compare).orElse(0);
        this.printSection("From Attributes:", () -> artifactTransform.getFromAttributes().asMap().forEach((key, value) -> this.writeAttribute(maxNameLength, key.getName(), value)));
        this.printSection("To Attributes:", () -> artifactTransform.getToAttributes().asMap().forEach((key, value) -> this.writeAttribute(maxNameLength, key.getName(), value)));
    }

    private void writeAttribute(Integer max, String name, Object value) {
        this.indent(true);
        this.valuePair(StringUtils.rightPad((String)name, (int)max), value.toString());
        this.newLine();
    }

    private void writeSuggestions(List<ReportArtifactTransform> transforms) {
        this.output.style(StyledTextOutput.Style.Info);
        if (transforms.stream().anyMatch(t -> !t.isCacheable())) {
            this.output.println((Object)("Some artifact transforms are not cacheable.  This can have negative performance impacts.  See more documentation here: " + this.documentationRegistry.getDocumentationFor("artifact_transforms", "artifact_transforms_with_caching") + "."));
        }
    }

    private void writeCompleteAbsenceOfResults(ArtifactTransformReportModel model, boolean searchingByType) {
        this.message("There are no transforms registered in " + model.getProjectDisplayName() + (searchingByType ? " with this type." : "."));
    }

    private void printHeader(Runnable action) {
        this.output.style(StyledTextOutput.Style.Header);
        this.indent(false);
        this.output.println((Object)"--------------------------------------------------");
        this.indent(false);
        action.run();
        this.output.style(StyledTextOutput.Style.Header);
        this.indent(false);
        this.output.println((Object)"--------------------------------------------------");
        this.output.style(StyledTextOutput.Style.Normal);
    }

    private void printSection(String title, Runnable action) {
        this.indent(false);
        this.output.style(StyledTextOutput.Style.Description).text((Object)title);
        this.output.style(StyledTextOutput.Style.Normal);
        try {
            ++this.depth;
            this.newLine();
            action.run();
        }
        finally {
            --this.depth;
        }
    }

    private void valuePair(String key, String value) {
        this.output.style(StyledTextOutput.Style.Identifier).text((Object)key);
        this.output.style(StyledTextOutput.Style.Normal).text((Object)(" = " + value));
    }

    private void indent(boolean bullet) {
        this.output.text((Object)StringUtils.repeat((String)"    ", (int)this.depth));
        if (this.depth > 0 && bullet) {
            this.output.withStyle(StyledTextOutput.Style.Normal).text((Object)"- ");
        }
    }

    private void message(String msg) {
        this.output.text((Object)msg).println();
    }

    private void newLine() {
        this.output.println();
    }
}

