/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.declarativedsl.evaluator.conversion;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.declarative.dsl.evaluation.InterpretationSequenceStep;
import org.gradle.internal.declarativedsl.analysis.ObjectOrigin;
import org.gradle.internal.declarativedsl.analysis.SchemaTypeRefContext;
import org.gradle.internal.declarativedsl.analysis.TypeRefContext;
import org.gradle.internal.declarativedsl.evaluator.conversion.ConversionSchema;
import org.gradle.internal.declarativedsl.evaluator.conversion.ConversionStepContext;
import org.gradle.internal.declarativedsl.evaluator.conversion.ConversionStepResult;
import org.gradle.internal.declarativedsl.evaluator.conversion.EvaluationAndConversionSchema;
import org.gradle.internal.declarativedsl.evaluator.conversion.InterpretationSequenceStepWithConversion;
import org.gradle.internal.declarativedsl.evaluator.runner.AnalysisStepContext;
import org.gradle.internal.declarativedsl.evaluator.runner.AnalysisStepResult;
import org.gradle.internal.declarativedsl.evaluator.runner.EvaluationResult;
import org.gradle.internal.declarativedsl.evaluator.runner.InterpretationSequenceStepRunner;
import org.gradle.internal.declarativedsl.evaluator.runner.StepContext;
import org.gradle.internal.declarativedsl.evaluator.runner.StepResult;
import org.gradle.internal.declarativedsl.mappingToJvm.CompositeCustomAccessors;
import org.gradle.internal.declarativedsl.mappingToJvm.CompositeFunctionResolver;
import org.gradle.internal.declarativedsl.mappingToJvm.CompositePropertyResolver;
import org.gradle.internal.declarativedsl.mappingToJvm.DeclarativeReflectionToObjectConverter;
import org.gradle.internal.declarativedsl.mappingToJvm.ReflectionToObjectConverter;
import org.gradle.internal.declarativedsl.mappingToJvm.RuntimeCustomAccessors;
import org.gradle.internal.declarativedsl.mappingToJvm.RuntimeFunctionResolver;
import org.gradle.internal.declarativedsl.mappingToJvm.RuntimePropertyResolver;
import org.gradle.internal.declarativedsl.objectGraph.ObjectReflection;
import org.gradle.internal.declarativedsl.objectGraph.ReflectObjectKt;
import org.gradle.internal.declarativedsl.objectGraph.ReflectionContext;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0019\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0001\u00a2\u0006\u0002\u0010\u0007JF\u0010\b\u001a\u00020\t\"\b\b\u0000\u0010\n*\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\n0\u000f2\u0006\u0010\u0010\u001a\u00020\u000b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J.\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0002H\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/gradle/internal/declarativedsl/evaluator/conversion/AnalysisAndConversionStepRunner;", "Lorg/gradle/internal/declarativedsl/evaluator/runner/InterpretationSequenceStepRunner;", "Lorg/gradle/internal/declarativedsl/evaluator/conversion/ConversionStepContext;", "Lorg/gradle/internal/declarativedsl/evaluator/conversion/ConversionStepResult;", "analysisStepRunner", "Lorg/gradle/internal/declarativedsl/evaluator/runner/AnalysisStepContext;", "Lorg/gradle/internal/declarativedsl/evaluator/runner/AnalysisStepResult;", "(Lorg/gradle/internal/declarativedsl/evaluator/runner/InterpretationSequenceStepRunner;)V", "applyReflectionToJvmObjectConversion", "", "R", "", "evaluationSchema", "Lorg/gradle/internal/declarativedsl/evaluator/conversion/EvaluationAndConversionSchema;", "step", "Lorg/gradle/internal/declarativedsl/evaluator/conversion/InterpretationSequenceStepWithConversion;", "target", "getScopeClassLoader", "Lkotlin/Function0;", "Ljava/lang/ClassLoader;", "topLevelObjectReflection", "Lorg/gradle/internal/declarativedsl/objectGraph/ObjectReflection;", "runInterpretationSequenceStep", "Lorg/gradle/internal/declarativedsl/evaluator/runner/EvaluationResult;", "scriptIdentifier", "", "scriptSource", "Lorg/gradle/declarative/dsl/evaluation/InterpretationSequenceStep;", "stepContext", "declarative-dsl-evaluator"})
public final class AnalysisAndConversionStepRunner
implements InterpretationSequenceStepRunner<ConversionStepContext, ConversionStepResult> {
    @NotNull
    private final InterpretationSequenceStepRunner<AnalysisStepContext, AnalysisStepResult> analysisStepRunner;

    public AnalysisAndConversionStepRunner(@NotNull InterpretationSequenceStepRunner<? super AnalysisStepContext, AnalysisStepResult> analysisStepRunner) {
        Intrinsics.checkNotNullParameter(analysisStepRunner, (String)"analysisStepRunner");
        this.analysisStepRunner = analysisStepRunner;
    }

    @Override
    @NotNull
    public EvaluationResult<ConversionStepResult> runInterpretationSequenceStep(@NotNull String scriptIdentifier, @NotNull String scriptSource, @NotNull InterpretationSequenceStep step, @NotNull ConversionStepContext stepContext) {
        EvaluationResult evaluationResult;
        Intrinsics.checkNotNullParameter((Object)scriptIdentifier, (String)"scriptIdentifier");
        Intrinsics.checkNotNullParameter((Object)scriptSource, (String)"scriptSource");
        Intrinsics.checkNotNullParameter((Object)step, (String)"step");
        Intrinsics.checkNotNullParameter((Object)stepContext, (String)"stepContext");
        EvaluationResult<AnalysisStepResult> analysisResult = this.analysisStepRunner.runInterpretationSequenceStep(scriptIdentifier, scriptSource, step, (AnalysisStepContext)((StepContext)stepContext.getAnalysisStepContext()));
        if (analysisResult instanceof EvaluationResult.NotEvaluated) {
            evaluationResult = new EvaluationResult.NotEvaluated<StepResult>(((EvaluationResult.NotEvaluated)analysisResult).getStageFailures(), new ConversionStepResult.AnalysisFailed((AnalysisStepResult)((EvaluationResult.NotEvaluated)analysisResult).getPartialStepResult()));
        } else if (analysisResult instanceof EvaluationResult.Evaluated) {
            EvaluationResult.Evaluated<StepResult> evaluated;
            if (step instanceof InterpretationSequenceStepWithConversion) {
                EvaluationAndConversionSchema evaluationSchema = ((InterpretationSequenceStepWithConversion)step).getEvaluationSchemaForStep();
                ReflectionContext context = new ReflectionContext((TypeRefContext)new SchemaTypeRefContext(evaluationSchema.getAnalysisSchema()), ((AnalysisStepResult)((EvaluationResult.Evaluated)analysisResult).getStepResult()).getResolutionResult(), ((AnalysisStepResult)((EvaluationResult.Evaluated)analysisResult).getStepResult()).getAssignmentTrace());
                ObjectReflection topLevelObjectReflection = ReflectObjectKt.reflect((ObjectOrigin)((ObjectOrigin)((AnalysisStepResult)((EvaluationResult.Evaluated)analysisResult).getStepResult()).getResolutionResult().getTopLevelReceiver()), (ReflectionContext)context);
                this.applyReflectionToJvmObjectConversion(evaluationSchema, (InterpretationSequenceStepWithConversion)step, stepContext.getTargetObject(), stepContext.getScopeClassLoader(), topLevelObjectReflection);
                evaluated = new EvaluationResult.Evaluated<StepResult>(new ConversionStepResult.ConversionSucceeded((AnalysisStepResult)((EvaluationResult.Evaluated)analysisResult).getStepResult()));
            } else {
                evaluated = new EvaluationResult.Evaluated<StepResult>(new ConversionStepResult.ConversionNotApplicable((AnalysisStepResult)((EvaluationResult.Evaluated)analysisResult).getStepResult()));
            }
            evaluationResult = evaluated;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return evaluationResult;
    }

    private final <R> void applyReflectionToJvmObjectConversion(EvaluationAndConversionSchema evaluationSchema, InterpretationSequenceStepWithConversion<R> step, Object target, Function0<? extends ClassLoader> getScopeClassLoader, ObjectReflection topLevelObjectReflection) {
        ConversionSchema conversionSchema = evaluationSchema.conversionSchemaForScriptTarget(target);
        CompositePropertyResolver propertyResolver = new CompositePropertyResolver(conversionSchema.getRuntimePropertyResolvers());
        CompositeFunctionResolver functionResolver = new CompositeFunctionResolver(conversionSchema.getRuntimeFunctionResolvers());
        CompositeCustomAccessors customAccessors = new CompositeCustomAccessors(conversionSchema.getRuntimeCustomAccessors());
        R topLevelReceiver = step.getTopLevelReceiverFromTarget(target);
        DeclarativeReflectionToObjectConverter converter = new DeclarativeReflectionToObjectConverter(MapsKt.emptyMap(), topLevelReceiver, (RuntimeFunctionResolver)functionResolver, (RuntimePropertyResolver)propertyResolver, (RuntimeCustomAccessors)customAccessors, getScopeClassLoader);
        ReflectionToObjectConverter.DefaultImpls.apply$default((ReflectionToObjectConverter)((ReflectionToObjectConverter)converter), (ObjectReflection)topLevelObjectReflection, null, (int)2, null);
        step.whenEvaluated(target, topLevelReceiver);
    }
}

