/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.cfa.util;

import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.analysis.cfa.util.DeclaredVariableCollector;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.expressions.FirDoWhileLoop;
import org.jetbrains.kotlin.fir.expressions.FirLoop;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.FirWhileLoop;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.util.MultimapKt;
import org.jetbrains.kotlin.fir.util.SetMultimap;
import org.jetbrains.kotlin.fir.visitors.FirVisitor;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002*\u0001\n\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\r2\u0006\u0010\u000e\u001a\u00020\u0005J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u0005J\u0006\u0010\u0011\u001a\u00020\u0010R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/cfa/util/DeclaredVariableCollector;", "", "()V", "declaredVariablesPerElement", "Lorg/jetbrains/kotlin/fir/util/SetMultimap;", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "getDeclaredVariablesPerElement", "()Lorg/jetbrains/kotlin/fir/util/SetMultimap;", "visitor", "org/jetbrains/kotlin/fir/analysis/cfa/util/DeclaredVariableCollector$visitor$1", "Lorg/jetbrains/kotlin/fir/analysis/cfa/util/DeclaredVariableCollector$visitor$1;", "enterCapturingStatement", "", "statement", "exitCapturingStatement", "", "resetState", "checkers"})
public final class DeclaredVariableCollector {
    @NotNull
    private final SetMultimap<FirStatement, FirPropertySymbol> declaredVariablesPerElement = MultimapKt.setMultimapOf();
    @NotNull
    private final visitor.1 visitor = new FirVisitor<Unit, FirStatement>(this){
        final /* synthetic */ DeclaredVariableCollector this$0;
        {
            this.this$0 = $receiver;
        }

        public void visitElement(@NotNull FirElement element, @Nullable FirStatement data2) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            element.acceptChildren(this, data2);
        }

        public void visitProperty(@NotNull FirProperty property2, @Nullable FirStatement data2) {
            Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
            if (property2.isLocal()) {
                if (data2 == null) {
                    String string2 = "Required value was null.";
                    throw new IllegalArgumentException(string2.toString());
                }
                this.this$0.getDeclaredVariablesPerElement().put(data2, property2.getSymbol());
            }
            this.visitElement((FirElement)property2, data2);
        }

        public void visitWhileLoop(@NotNull FirWhileLoop whileLoop, @Nullable FirStatement data2) {
            Intrinsics.checkNotNullParameter((Object)whileLoop, (String)"whileLoop");
            this.visitCapturingStatement(whileLoop, data2);
        }

        public void visitDoWhileLoop(@NotNull FirDoWhileLoop doWhileLoop, @Nullable FirStatement data2) {
            Intrinsics.checkNotNullParameter((Object)doWhileLoop, (String)"doWhileLoop");
            this.visitCapturingStatement(doWhileLoop, data2);
        }

        public void visitAnonymousFunction(@NotNull FirAnonymousFunction anonymousFunction2, @Nullable FirStatement data2) {
            Intrinsics.checkNotNullParameter((Object)anonymousFunction2, (String)"anonymousFunction");
            this.visitCapturingStatement(anonymousFunction2, data2);
        }

        public void visitSimpleFunction(@NotNull FirSimpleFunction simpleFunction, @Nullable FirStatement data2) {
            Intrinsics.checkNotNullParameter((Object)simpleFunction, (String)"simpleFunction");
            this.visitCapturingStatement(simpleFunction, data2);
        }

        public void visitRegularClass(@NotNull FirRegularClass regularClass, @Nullable FirStatement data2) {
            Intrinsics.checkNotNullParameter((Object)regularClass, (String)"regularClass");
            this.visitCapturingStatement(regularClass, data2);
        }

        public void visitAnonymousObject(@NotNull FirAnonymousObject anonymousObject, @Nullable FirStatement data2) {
            Intrinsics.checkNotNullParameter((Object)anonymousObject, (String)"anonymousObject");
            this.visitCapturingStatement(anonymousObject, data2);
        }

        private final void visitCapturingStatement(FirStatement statement2, FirStatement parent2) {
            this.visitElement((FirElement)statement2, statement2);
            if (parent2 != null) {
                this.this$0.getDeclaredVariablesPerElement().putAll(parent2, (Collection<FirPropertySymbol>)this.this$0.getDeclaredVariablesPerElement().get(statement2));
            }
        }
    };

    @NotNull
    public final SetMultimap<FirStatement, FirPropertySymbol> getDeclaredVariablesPerElement() {
        return this.declaredVariablesPerElement;
    }

    @NotNull
    public final Set<FirPropertySymbol> enterCapturingStatement(@NotNull FirStatement statement2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)statement2, (String)"statement");
        boolean bl2 = bl = statement2 instanceof FirLoop || statement2 instanceof FirClass || statement2 instanceof FirFunction;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        if (!this.declaredVariablesPerElement.contains(statement2)) {
            statement2.accept(this.visitor, null);
        }
        return (Set)this.declaredVariablesPerElement.get(statement2);
    }

    public final void exitCapturingStatement(@NotNull FirStatement statement2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)statement2, (String)"statement");
        boolean bl2 = bl = statement2 instanceof FirLoop || statement2 instanceof FirClass || statement2 instanceof FirFunction;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        this.declaredVariablesPerElement.removeKey(statement2);
    }

    public final void resetState() {
        this.declaredVariablesPerElement.clear();
    }
}

