/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.featurelifecycle;

import javax.annotation.concurrent.ThreadSafe;
import org.gradle.internal.featurelifecycle.FeatureUsage;
import org.gradle.internal.featurelifecycle.UsageLocationReporter;
import org.gradle.internal.service.scopes.Scopes;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.problems.Location;
import org.gradle.problems.buildtree.ProblemLocationAnalyzer;

@ServiceScope(value=Scopes.BuildTree.class)
@ThreadSafe
public class ScriptUsageLocationReporter
implements UsageLocationReporter {
    private final ProblemLocationAnalyzer locationAnalyzer;

    public ScriptUsageLocationReporter(ProblemLocationAnalyzer locationAnalyzer) {
        this.locationAnalyzer = locationAnalyzer;
    }

    public void reportLocation(FeatureUsage usage, StringBuilder target) {
        Location location = this.locationAnalyzer.locationForUsage(usage.getStack(), false);
        if (location != null) {
            target.append(location.getFormatted());
        }
    }
}

