/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks;

import com.google.common.collect.Iterables;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.gradle.api.Buildable;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.attributes.HasConfigurableAttributes;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.collections.FailingFileCollection;
import org.gradle.api.internal.file.collections.LazilyInitializedFileCollection;
import org.gradle.api.internal.plugins.GroovyJarFile;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.plugins.jvm.internal.JvmEcosystemUtilities;
import org.gradle.util.internal.GroovyDependencyUtil;
import org.gradle.util.internal.VersionNumber;

public abstract class GroovyRuntime {
    private static final VersionNumber GROOVY_VERSION_WITH_SEPARATE_ANT = VersionNumber.parse((String)"2.0");
    private static final VersionNumber GROOVY_VERSION_REQUIRING_TEMPLATES = VersionNumber.parse((String)"2.5");
    private static final List<String> GROOVY_LIBS = Arrays.asList("groovy", "groovy-ant", "groovy-astbuilder", "groovy-console", "groovy-datetime", "groovy-dateutil", "groovy-nio", "groovy-sql", "groovy-test", "groovy-templates", "groovy-json", "groovy-xml", "groovy-groovydoc");
    private final ProjectInternal project;

    public GroovyRuntime(Project project) {
        this.project = (ProjectInternal)project;
    }

    public FileCollection inferGroovyClasspath(final Iterable<File> classpath) {
        return new LazilyInitializedFileCollection(this.project.getTaskDependencyFactory()){

            public String getDisplayName() {
                return "Groovy runtime classpath";
            }

            public FileCollection createDelegate() {
                try {
                    return this.inferGroovyClasspath();
                }
                catch (RuntimeException e) {
                    return new FailingFileCollection(this.getDisplayName(), e);
                }
            }

            private FileCollection inferGroovyClasspath() {
                GroovyJarFile groovyJar = GroovyRuntime.findGroovyJarFile(classpath);
                if (groovyJar == null) {
                    throw new GradleException(String.format("Cannot infer Groovy class path because no Groovy Jar was found on class path: %s", Iterables.toString((Iterable)classpath)));
                }
                if (groovyJar.isGroovyAll()) {
                    return GroovyRuntime.this.project.getLayout().files(new Object[]{groovyJar.getFile()});
                }
                VersionNumber groovyVersion = groovyJar.getVersion();
                if (groovyVersion.getMajor() <= 2) {
                    return this.inferGroovyAllClasspath(groovyJar.getDependencyNotation(), groovyVersion);
                }
                return this.inferGroovyClasspath(groovyVersion);
            }

            private void addGroovyDependency(String groovyDependencyNotion, List<Dependency> dependencies, String otherDependency) {
                String notation = groovyDependencyNotion.replace(":groovy:", ":" + otherDependency + ":");
                this.addDependencyTo(dependencies, notation);
            }

            private void addDependencyTo(List<Dependency> dependencies, String notation) {
                dependencies.add(GroovyRuntime.this.project.getDependencies().create((Object)notation));
            }

            private FileCollection inferGroovyAllClasspath(String notation, VersionNumber groovyVersion) {
                ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
                this.addDependencyTo(dependencies, notation);
                if (groovyVersion.compareTo(GROOVY_VERSION_WITH_SEPARATE_ANT) >= 0) {
                    this.addGroovyDependency(notation, dependencies, "groovy-ant");
                }
                if (groovyVersion.compareTo(GROOVY_VERSION_REQUIRING_TEMPLATES) >= 0) {
                    this.addGroovyDependency(notation, dependencies, "groovy-templates");
                }
                return this.detachedRuntimeClasspath(dependencies.toArray(new Dependency[0]));
            }

            private FileCollection inferGroovyClasspath(VersionNumber groovyVersion) {
                Set groovyJarNames = GroovyRuntime.groovyJarNamesFor(groovyVersion);
                List groovyClasspath = GroovyRuntime.collectJarsFromClasspath(classpath, groovyJarNames);
                if (groovyClasspath.size() == GROOVY_LIBS.size()) {
                    return GroovyRuntime.this.project.getLayout().files(new Object[]{groovyClasspath});
                }
                return this.detachedRuntimeClasspath((Dependency[])GROOVY_LIBS.stream().map(libName -> GroovyRuntime.this.project.getDependencies().create((Object)GroovyDependencyUtil.groovyModuleDependency((String)libName, (VersionNumber)groovyVersion))).toArray(Dependency[]::new));
            }

            private Configuration detachedRuntimeClasspath(Dependency ... dependencies) {
                Configuration classpath2 = GroovyRuntime.this.project.getConfigurations().detachedConfiguration(dependencies);
                GroovyRuntime.this.jvmEcosystemUtilities().configureAsRuntimeClasspath((HasConfigurableAttributes<?>)classpath2);
                return classpath2;
            }

            public void visitDependencies(TaskDependencyResolveContext context) {
                if (classpath instanceof Buildable) {
                    context.add((Object)classpath);
                }
            }
        };
    }

    private static List<File> collectJarsFromClasspath(Iterable<File> classpath, Set<String> jarNames) {
        return StreamSupport.stream(classpath.spliterator(), false).filter(file -> jarNames.contains(file.getName())).collect(Collectors.toList());
    }

    private static Set<String> groovyJarNamesFor(VersionNumber groovyVersion) {
        return GROOVY_LIBS.stream().map(libName -> libName + "-" + groovyVersion + ".jar").collect(Collectors.toSet());
    }

    @Nullable
    private static GroovyJarFile findGroovyJarFile(Iterable<File> classpath) {
        for (File file : classpath) {
            GroovyJarFile groovyJar = GroovyJarFile.parse(file);
            if (groovyJar == null) continue;
            return groovyJar;
        }
        return null;
    }

    private JvmEcosystemUtilities jvmEcosystemUtilities() {
        return (JvmEcosystemUtilities)this.project.getServices().get(JvmEcosystemUtilities.class);
    }
}

