/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon.report;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.build.report.ICReporter;
import org.jetbrains.kotlin.build.report.ICReporterBase;
import org.jetbrains.kotlin.build.report.RemoteBuildReporter;
import org.jetbrains.kotlin.build.report.RemoteICReporter;
import org.jetbrains.kotlin.build.report.metrics.BuildMetricsReporter;
import org.jetbrains.kotlin.build.report.metrics.BuildMetricsReporterImpl;
import org.jetbrains.kotlin.build.report.metrics.DoNothingBuildMetricsReporter;
import org.jetbrains.kotlin.build.report.metrics.RemoteBuildMetricsReporter;
import org.jetbrains.kotlin.daemon.common.CompilationResultCategory;
import org.jetbrains.kotlin.daemon.common.CompilationResults;
import org.jetbrains.kotlin.daemon.common.CompilerServicesFacadeBase;
import org.jetbrains.kotlin.daemon.common.IncrementalCompilationOptions;
import org.jetbrains.kotlin.daemon.common.ReportCategory;
import org.jetbrains.kotlin.daemon.common.ReportSeverity;
import org.jetbrains.kotlin.daemon.report.BuildReportICReporter;
import org.jetbrains.kotlin.daemon.report.CompileIterationICReporter;
import org.jetbrains.kotlin.daemon.report.CompositeICReporter;
import org.jetbrains.kotlin.daemon.report.DebugMessagesICReporter;
import org.jetbrains.kotlin.daemon.report.RemoteBuildMetricsReporterAdapter;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u001c\u0010\b\u001a\u00020\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0000\u00a8\u0006\u000e"}, d2={"getBuildReporter", "Lorg/jetbrains/kotlin/build/report/RemoteBuildReporter;", "servicesFacade", "Lorg/jetbrains/kotlin/daemon/common/CompilerServicesFacadeBase;", "compilationResults", "Lorg/jetbrains/kotlin/daemon/common/CompilationResults;", "compilationOptions", "Lorg/jetbrains/kotlin/daemon/common/IncrementalCompilationOptions;", "getSeverity", "Lorg/jetbrains/kotlin/build/report/ICReporter$ReportSeverity;", "Lorg/jetbrains/kotlin/daemon/common/ReportSeverity;", "mapErrorToWarning", "", "mapInfoToWarning", "kotlin-daemon"})
@SourceDebugExtension(value={"SMAP\ngetICReporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 getICReporter.kt\norg/jetbrains/kotlin/daemon/report/GetICReporterKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,112:1\n11661#2:113\n13579#2:114\n13580#2:116\n11662#2:117\n1#3:115\n1#3:118\n*S KotlinDebug\n*F\n+ 1 getICReporter.kt\norg/jetbrains/kotlin/daemon/report/GetICReporterKt\n*L\n47#1:113\n47#1:114\n47#1:116\n47#1:117\n47#1:115\n*E\n"})
public final class GetICReporterKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final RemoteBuildReporter getBuildReporter(@NotNull CompilerServicesFacadeBase servicesFacade, @NotNull CompilationResults compilationResults, @NotNull IncrementalCompilationOptions compilationOptions) {
        Iterator $this$mapNotNullTo$iv;
        Intrinsics.checkNotNullParameter((Object)servicesFacade, (String)"servicesFacade");
        Intrinsics.checkNotNullParameter((Object)compilationResults, (String)"compilationResults");
        Intrinsics.checkNotNullParameter((Object)compilationOptions, (String)"compilationOptions");
        File root = compilationOptions.getModulesInfo().getProjectRoot();
        ArrayList<ICReporterBase> reporters = new ArrayList<ICReporterBase>();
        if (ArraysKt.contains((Object[])compilationOptions.getReportCategories(), (Object)ReportCategory.IC_MESSAGE.getCode())) {
            reporters.add(new DebugMessagesICReporter(servicesFacade, root, GetICReporterKt.getSeverity(ReportSeverity.Companion.fromCode(compilationOptions.getReportSeverity()), true, true)));
        }
        Integer[] integerArray = compilationOptions.getRequestedCompilationResults();
        Collection destination$iv = new HashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            CompilationResultCategory it$iv;
            void element$iv$iv;
            void element$iv = element$iv$iv = $this$forEach$iv$iv[i];
            boolean bl = false;
            int resultCode = ((Number)element$iv).intValue();
            boolean bl2 = false;
            if ((CompilationResultCategory)((Object)ArraysKt.getOrNull((Object[])CompilationResultCategory.values(), (int)resultCode)) == null) continue;
            boolean bl3 = false;
            destination$iv.add(it$iv);
        }
        HashSet requestedResults = (HashSet)destination$iv;
        for (CompilationResultCategory requestedResult : requestedResults) {
            switch (WhenMappings.$EnumSwitchMapping$0[requestedResult.ordinal()]) {
                case 1: {
                    reporters.add(new CompileIterationICReporter(compilationResults));
                    break;
                }
                case 2: {
                    reporters.add(new BuildReportICReporter(compilationResults, root, false, 4, null));
                    break;
                }
                case 3: {
                    reporters.add(new BuildReportICReporter(compilationResults, root, true));
                }
            }
        }
        boolean areBuildMetricsNeeded = requestedResults.contains((Object)CompilationResultCategory.BUILD_METRICS);
        BuildMetricsReporter it = areBuildMetricsNeeded ? (BuildMetricsReporter)new BuildMetricsReporterImpl() : (BuildMetricsReporter)DoNothingBuildMetricsReporter.INSTANCE;
        boolean bl = false;
        RemoteBuildMetricsReporterAdapter metricsReporter = new RemoteBuildMetricsReporterAdapter(it, areBuildMetricsNeeded, compilationResults);
        return new RemoteBuildReporter((RemoteICReporter)new CompositeICReporter((Iterable<? extends RemoteICReporter>)reporters), (RemoteBuildMetricsReporter)metricsReporter);
    }

    @NotNull
    public static final ICReporter.ReportSeverity getSeverity(@NotNull ReportSeverity $this$getSeverity, boolean mapErrorToWarning, boolean mapInfoToWarning) {
        ICReporter.ReportSeverity reportSeverity;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$getSeverity), (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$1[$this$getSeverity.ordinal()]) {
            case 1: {
                if (mapErrorToWarning) {
                    reportSeverity = ICReporter.ReportSeverity.WARNING;
                    break;
                }
                throw new IllegalArgumentException("No mapping exists for `ReportSeverity.ERROR`. Add `ICReporter.ReportSeverity.ERROR` and remove mapErrorToWarning, or set mapErrorToWarning = true.");
            }
            case 2: {
                reportSeverity = ICReporter.ReportSeverity.WARNING;
                break;
            }
            case 3: {
                if (mapInfoToWarning) {
                    reportSeverity = ICReporter.ReportSeverity.WARNING;
                    break;
                }
                reportSeverity = ICReporter.ReportSeverity.INFO;
                break;
            }
            case 4: {
                reportSeverity = ICReporter.ReportSeverity.DEBUG;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return reportSeverity;
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[CompilationResultCategory.values().length];
            try {
                nArray[CompilationResultCategory.IC_COMPILE_ITERATION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CompilationResultCategory.BUILD_REPORT_LINES.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CompilationResultCategory.VERBOSE_BUILD_REPORT_LINES.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CompilationResultCategory.BUILD_METRICS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ReportSeverity.values().length];
            try {
                nArray[ReportSeverity.ERROR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReportSeverity.WARNING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReportSeverity.INFO.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReportSeverity.DEBUG.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

