/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.js.dce;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.CLITool;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.arguments.K2JSDceArguments;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.js.dce.K2JSDce;
import org.jetbrains.kotlin.config.Services;
import org.jetbrains.kotlin.js.dce.Context;
import org.jetbrains.kotlin.js.dce.DCELogLevel;
import org.jetbrains.kotlin.js.dce.DeadCodeElimination;
import org.jetbrains.kotlin.js.dce.DeadCodeEliminationResult;
import org.jetbrains.kotlin.js.dce.DeadCodeEliminationStatus;
import org.jetbrains.kotlin.js.dce.InputFile;
import org.jetbrains.kotlin.js.dce.InputResource;
import org.jetbrains.kotlin.js.dce.PrintTreeKt;
import org.jetbrains.kotlin.js.dce.UtilKt;
import org.jetbrains.kotlin.js.parser.sourcemaps.SourceMap;
import org.jetbrains.kotlin.js.parser.sourcemaps.SourceMapSourceReplacementException;
import org.jetbrains.kotlin.js.sourceMap.RelativePathCalculator;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 &2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001&B\u0005\u00a2\u0006\u0002\u0010\u0003J&\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\nH\u0002J\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\nH\u0002J\u001e\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J \u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0019\u001a\u00020\u0002H\u0016J \u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0002H\u0014J\b\u0010\u001f\u001a\u00020\nH\u0016J\u0010\u0010 \u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\nH\u0002J\u0018\u0010!\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\bH\u0002J&\u0010#\u001a\u00020\u001b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u001e\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010$\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\nH\u0002J\f\u0010%\u001a\u00020\n*\u00020\nH\u0002\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/cli/js/dce/K2JSDce;", "Lorg/jetbrains/kotlin/cli/common/CLITool;", "Lorg/jetbrains/kotlin/cli/common/arguments/K2JSDceArguments;", "()V", "collectInputFiles", "", "Lorg/jetbrains/kotlin/js/dce/InputFile;", "baseDir", "Ljava/io/File;", "fileName", "", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "collectInputFilesFromDirectory", "path", "collectInputFilesFromZip", "copyFiles", "", "files", "overwriteOnlyOlderFiles", "", "copyResource", "resource", "Lorg/jetbrains/kotlin/js/dce/InputResource;", "targetFile", "createArguments", "execImpl", "Lorg/jetbrains/kotlin/cli/common/ExitCode;", "services", "Lorg/jetbrains/kotlin/config/Services;", "arguments", "executableScriptFileName", "getModuleNameFromPath", "mapSourcePaths", "inputFile", "performDce", "singleInputFile", "metaJs", "Companion", "cli-js"})
@SourceDebugExtension(value={"SMAP\nK2JSDce.kt\nKotlin\n*S Kotlin\n*F\n+ 1 K2JSDce.kt\norg/jetbrains/kotlin/cli/js/dce/K2JSDce\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,248:1\n1360#2:249\n1446#2,5:250\n18#3:255\n26#4:256\n1#5:257\n*S KotlinDebug\n*F\n+ 1 K2JSDce.kt\norg/jetbrains/kotlin/cli/js/dce/K2JSDce\n*L\n26#1:249\n26#1:250,5\n68#1:255\n68#1:256\n*E\n"})
public final class K2JSDce
extends CLITool<K2JSDceArguments> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public K2JSDceArguments createArguments() {
        return new K2JSDceArguments();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected ExitCode execImpl(@NotNull MessageCollector messageCollector, @NotNull Services services, @NotNull K2JSDceArguments arguments2) {
        ExitCode exitCode;
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)messageCollector, (String)"messageCollector");
        Intrinsics.checkNotNullParameter((Object)services, (String)"services");
        Intrinsics.checkNotNullParameter((Object)arguments2, (String)"arguments");
        String string2 = arguments2.getOutputDirectory();
        if (string2 == null) {
            string2 = "min";
        }
        File baseDir = new File(string2);
        Iterable $this$flatMap$iv = arguments2.getFreeArgs();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            String arg = (String)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.collectInputFiles(baseDir, arg, messageCollector);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List files2 = (List)destination$iv$iv;
        if (messageCollector.hasErrors()) {
            return ExitCode.COMPILATION_ERROR;
        }
        if (files2.isEmpty() && !arguments2.getVersion()) {
            MessageCollector.report$default(messageCollector, CompilerMessageSeverity.ERROR, "no source files", null, 4, null);
            return ExitCode.COMPILATION_ERROR;
        }
        Map existingFiles = new LinkedHashMap();
        for (InputFile file2 : files2) {
            InputFile inputFile = (InputFile)existingFiles.get(file2.getOutputPath());
            if (inputFile != null) {
                InputFile it = inputFile;
                boolean bl = false;
                MessageCollector.report$default(messageCollector, CompilerMessageSeverity.ERROR, "duplicate target file will be created for '" + file2.getResource().getName() + "' and '" + it.getResource().getName() + '\'', null, 4, null);
                return ExitCode.COMPILATION_ERROR;
            }
            existingFiles.put(file2.getOutputPath(), file2);
            if (!new File(file2.getOutputPath()).isDirectory()) continue;
            MessageCollector.report$default(messageCollector, CompilerMessageSeverity.ERROR, "cannot open output file '" + file2.getOutputPath() + "': it is a directory", null, 4, null);
            return ExitCode.COMPILATION_ERROR;
        }
        if (!arguments2.getDevMode()) {
            exitCode = this.performDce(files2, arguments2, messageCollector);
        } else {
            String string3 = arguments2.getDevModeOverwritingStrategy();
            if (string3 == null) {
                string3 = System.getProperty("kotlin.js.dce.devmode.overwriting.strategy", "older");
            }
            String devModeOverwritingStrategy = string3;
            boolean overwriteOnlyOlderFiles = Intrinsics.areEqual((Object)devModeOverwritingStrategy, (Object)"older");
            this.copyFiles(files2, overwriteOnlyOlderFiles);
            exitCode = ExitCode.OK;
        }
        return exitCode;
    }

    private final ExitCode performDce(List<InputFile> files2, K2JSDceArguments arguments2, MessageCollector messageCollector) {
        Object[] $this$orEmpty$iv = arguments2.getDeclarationsToKeep();
        boolean $i$f$orEmpty = false;
        Object[] objectArray = $this$orEmpty$iv;
        if ($this$orEmpty$iv == null) {
            boolean $i$f$emptyArray = false;
            objectArray = new String[]{};
        }
        Set includedDeclarations = ArraysKt.toSet((Object[])objectArray);
        Function2 logConsumer2 = (Function2)new Function2<DCELogLevel, String, Unit>(messageCollector){
            final /* synthetic */ MessageCollector $messageCollector;
            {
                this.$messageCollector = $messageCollector;
                super(2);
            }

            public final void invoke(@NotNull DCELogLevel level, @NotNull String message) {
                CompilerMessageSeverity compilerMessageSeverity;
                Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                switch (performDce.logConsumer.WhenMappings.$EnumSwitchMapping$0[level.ordinal()]) {
                    case 1: {
                        compilerMessageSeverity = CompilerMessageSeverity.ERROR;
                        break;
                    }
                    case 2: {
                        compilerMessageSeverity = CompilerMessageSeverity.WARNING;
                        break;
                    }
                    case 3: {
                        compilerMessageSeverity = CompilerMessageSeverity.LOGGING;
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                CompilerMessageSeverity severity = compilerMessageSeverity;
                MessageCollector.report$default(this.$messageCollector, severity, message, null, 4, null);
            }
        };
        DeadCodeEliminationResult dceResult = DeadCodeElimination.Companion.run((Collection<InputFile>)files2, includedDeclarations, arguments2.getPrintReachabilityInfo(), (Function2<? super DCELogLevel, ? super String, Unit>)logConsumer2);
        if (dceResult.getStatus() == DeadCodeEliminationStatus.FAILED) {
            return ExitCode.COMPILATION_ERROR;
        }
        if (arguments2.getPrintReachabilityInfo()) {
            CompilerMessageSeverity reachabilitySeverity = CompilerMessageSeverity.INFO;
            MessageCollector.report$default(messageCollector, reachabilitySeverity, "", null, 4, null);
            Iterable<Context.Node> iterable = dceResult.getReachableNodes();
            Context context = dceResult.getContext();
            Intrinsics.checkNotNull((Object)context);
            for (Context.Node node : UtilKt.extractReachableRoots(iterable, context)) {
                PrintTreeKt.printTree(node, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(messageCollector, reachabilitySeverity){
                    final /* synthetic */ MessageCollector $messageCollector;
                    final /* synthetic */ CompilerMessageSeverity $reachabilitySeverity;
                    {
                        this.$messageCollector = $messageCollector;
                        this.$reachabilitySeverity = $reachabilitySeverity;
                        super(1);
                    }

                    public final void invoke(@NotNull String it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        MessageCollector.report$default(this.$messageCollector, this.$reachabilitySeverity, it, null, 4, null);
                    }
                }), false, true);
            }
        }
        return ExitCode.OK;
    }

    private final void copyFiles(List<InputFile> files2, boolean overwriteOnlyOlderFiles) {
        for (InputFile file2 : files2) {
            InputResource sourceMap2;
            this.copyResource(file2.getResource(), new File(file2.getOutputPath()), overwriteOnlyOlderFiles);
            if (file2.getSourceMapResource() == null) continue;
            boolean bl = false;
            File sourceMapTarget = new File(file2.getOutputPath() + ".map");
            File inputFile = new File(sourceMap2.getName());
            if (inputFile.exists() && this.mapSourcePaths(inputFile, sourceMapTarget)) continue;
            this.copyResource(sourceMap2, sourceMapTarget, overwriteOnlyOlderFiles);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void copyResource(InputResource resource, File targetFile, boolean overwriteOnlyOlderFiles) {
        if (overwriteOnlyOlderFiles && targetFile.exists() && ((Number)resource.getLastModified().invoke()).longValue() < targetFile.lastModified()) {
            return;
        }
        targetFile.getParentFile().mkdirs();
        Closeable closeable = (Closeable)resource.getReader().invoke();
        Throwable throwable = null;
        try {
            long l;
            InputStream input = (InputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = new FileOutputStream(targetFile);
            Throwable throwable2 = null;
            try {
                FileOutputStream output = (FileOutputStream)closeable2;
                boolean bl2 = false;
                l = ByteStreamsKt.copyTo$default((InputStream)input, (OutputStream)output, (int)0, (int)2, null);
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            long l2 = l;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean mapSourcePaths(File inputFile, File targetFile) {
        boolean bl;
        StringWriter jsonOut = new StringWriter();
        File file2 = targetFile.getParentFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"targetFile.parentFile");
        RelativePathCalculator pathCalculator = new RelativePathCalculator(file2);
        try {
            bl = SourceMap.Companion.mapSources(FilesKt.readText$default((File)inputFile, null, (int)1, null), jsonOut, (Function1<? super String, String>)((Function1)new Function1<String, String>(pathCalculator, inputFile, targetFile){
                final /* synthetic */ RelativePathCalculator $pathCalculator;
                final /* synthetic */ File $inputFile;
                final /* synthetic */ File $targetFile;
                {
                    this.$pathCalculator = $pathCalculator;
                    this.$inputFile = $inputFile;
                    this.$targetFile = $targetFile;
                    super(1);
                }

                @NotNull
                public final String invoke(@NotNull String it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    String result2 = this.$pathCalculator.calculateRelativePathTo(new File(this.$inputFile.getParentFile(), it));
                    return result2 != null ? (new File(this.$targetFile.getParentFile(), result2).exists() ? result2 : it) : it;
                }
            }));
        }
        catch (SourceMapSourceReplacementException e) {
            bl = false;
        }
        boolean sourceMapChanged2 = bl;
        if (!sourceMapChanged2) {
            return false;
        }
        targetFile.getParentFile().mkdirs();
        Closeable closeable = new OutputStreamWriter((OutputStream)new FileOutputStream(targetFile), "UTF-8");
        Throwable throwable = null;
        try {
            OutputStreamWriter it = (OutputStreamWriter)closeable;
            boolean bl2 = false;
            it.write(jsonOut.toString());
            Unit unit2 = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return true;
    }

    private final List<InputFile> collectInputFiles(File baseDir, String fileName, MessageCollector messageCollector) {
        List list2;
        File file2 = new File(fileName);
        if (file2.isDirectory()) {
            list2 = this.collectInputFilesFromDirectory(baseDir, fileName);
        } else if (file2.isFile()) {
            if (StringsKt.endsWith$default((String)fileName, (String)".js", (boolean)false, (int)2, null)) {
                list2 = CollectionsKt.listOf((Object)this.singleInputFile(baseDir, fileName));
            } else if (StringsKt.endsWith$default((String)fileName, (String)".zip", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)fileName, (String)".jar", (boolean)false, (int)2, null)) {
                list2 = this.collectInputFilesFromZip(baseDir, fileName);
            } else {
                MessageCollector.report$default(messageCollector, CompilerMessageSeverity.WARNING, "invalid file name '" + file2.getAbsolutePath() + "'; must end either with '.js', '.zip' or '.jar'", null, 4, null);
                list2 = CollectionsKt.emptyList();
            }
        } else {
            MessageCollector.report$default(messageCollector, CompilerMessageSeverity.ERROR, "source file or directory not found: " + fileName, null, 4, null);
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    private final InputFile singleInputFile(File baseDir, String path2) {
        InputResource inputResource;
        String moduleName = this.getModuleNameFromPath(path2);
        String pathToSourceMapCandidate = path2 + ".map";
        String pathToSourceMap = new File(pathToSourceMapCandidate).exists() ? pathToSourceMapCandidate : null;
        InputResource inputResource2 = InputResource.Companion.file(path2);
        String string2 = pathToSourceMap;
        if (string2 != null) {
            void it;
            String string3 = string2;
            InputResource inputResource3 = inputResource2;
            boolean bl = false;
            inputResource = InputResource.Companion.file((String)it);
            inputResource2 = inputResource3;
        } else {
            inputResource = null;
        }
        String string4 = new File(baseDir, moduleName + ".js").getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"File(baseDir, \"$moduleName.js\").absolutePath");
        String string5 = moduleName;
        String string6 = string4;
        InputResource inputResource4 = inputResource;
        InputResource inputResource5 = inputResource2;
        return new InputFile(inputResource5, inputResource4, string6, string5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<InputFile> collectInputFilesFromZip(File baseDir, String path2) {
        List list2;
        Closeable closeable = new ZipFile(path2);
        Throwable throwable = null;
        try {
            ZipFile zipFile2 = (ZipFile)closeable;
            boolean bl = false;
            Enumeration<? extends ZipEntry> enumeration = zipFile2.entries();
            Intrinsics.checkNotNullExpressionValue(enumeration, (String)"zipFile.entries()");
            list2 = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.distinctBy((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration)), (Function1)collectInputFilesFromZip.1.1.INSTANCE), (Function1)collectInputFilesFromZip.1.2.INSTANCE), (Function1)((Function1)new Function1<ZipEntry, Boolean>(zipFile2, this){
                final /* synthetic */ ZipFile $zipFile;
                final /* synthetic */ K2JSDce this$0;
                {
                    this.$zipFile = $zipFile;
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(ZipEntry it) {
                    String string2 = it.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.name");
                    return this.$zipFile.getEntry(K2JSDce.access$metaJs(this.this$0, string2)) != null;
                }
            })), (Function1)collectInputFilesFromZip.1.4.INSTANCE), (Function1)((Function1)new Function1<ZipEntry, InputFile>(this, zipFile2, path2, baseDir){
                final /* synthetic */ K2JSDce this$0;
                final /* synthetic */ ZipFile $zipFile;
                final /* synthetic */ String $path;
                final /* synthetic */ File $baseDir;
                {
                    this.this$0 = $receiver;
                    this.$zipFile = $zipFile;
                    this.$path = $path;
                    this.$baseDir = $baseDir;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final InputFile invoke(ZipEntry entry) {
                    InputResource inputResource;
                    String string2 = entry.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"entry.name");
                    String moduleName = K2JSDce.access$getModuleNameFromPath(this.this$0, string2);
                    String pathToSourceMapCandidate = entry.getName() + ".map";
                    String pathToSourceMap = this.$zipFile.getEntry(pathToSourceMapCandidate) != null ? pathToSourceMapCandidate : null;
                    String string3 = entry.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"entry.name");
                    InputResource inputResource2 = InputResource.Companion.zipFile(this.$path, string3);
                    String string4 = pathToSourceMap;
                    if (string4 != null) {
                        void it;
                        String string5 = string4;
                        String string6 = this.$path;
                        String string7 = string5;
                        InputResource inputResource3 = inputResource2;
                        boolean bl = false;
                        inputResource = InputResource.Companion.zipFile(string6, (String)it);
                        inputResource2 = inputResource3;
                    } else {
                        inputResource = null;
                    }
                    String string8 = new File(this.$baseDir, moduleName + ".js").getAbsolutePath();
                    Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"File(baseDir, \"$moduleName.js\").absolutePath");
                    String string9 = moduleName;
                    String string10 = string8;
                    InputResource inputResource4 = inputResource;
                    InputResource inputResource5 = inputResource2;
                    return new InputFile(inputResource5, inputResource4, string10, string9);
                }
            })));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return list2;
    }

    private final List<InputFile> collectInputFilesFromDirectory(File baseDir, String path2) {
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)((Sequence)FilesKt.walkTopDown((File)new File(path2))), (Function1)collectInputFilesFromDirectory.1.INSTANCE), (Function1)collectInputFilesFromDirectory.2.INSTANCE), (Function1)((Function1)new Function1<File, Boolean>(this){
            final /* synthetic */ K2JSDce this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull File it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                String string2 = it.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.path");
                return new File(K2JSDce.access$metaJs(this.this$0, string2)).exists();
            }
        })), (Function1)((Function1)new Function1<File, InputFile>(this, baseDir){
            final /* synthetic */ K2JSDce this$0;
            final /* synthetic */ File $baseDir;
            {
                this.this$0 = $receiver;
                this.$baseDir = $baseDir;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final InputFile invoke(@NotNull File entry) {
                InputResource inputResource;
                Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
                String string2 = entry.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"entry.name");
                String moduleName = K2JSDce.access$getModuleNameFromPath(this.this$0, string2);
                String pathToSourceMapCandidate = entry.getPath() + ".map";
                String pathToSourceMap = new File(pathToSourceMapCandidate).exists() ? pathToSourceMapCandidate : null;
                String string3 = entry.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"entry.path");
                InputResource inputResource2 = InputResource.Companion.file(string3);
                String string4 = pathToSourceMap;
                if (string4 != null) {
                    void it;
                    String string5 = string4;
                    InputResource inputResource3 = inputResource2;
                    boolean bl = false;
                    inputResource = InputResource.Companion.file((String)it);
                    inputResource2 = inputResource3;
                } else {
                    inputResource = null;
                }
                String string6 = new File(this.$baseDir, moduleName + ".js").getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"File(baseDir, \"$moduleName.js\").absolutePath");
                String string7 = moduleName;
                String string8 = string6;
                InputResource inputResource4 = inputResource;
                InputResource inputResource5 = inputResource2;
                return new InputFile(inputResource5, inputResource4, string8, string7);
            }
        })));
    }

    private final String metaJs(String $this$metaJs) {
        return StringsKt.removeSuffix((String)$this$metaJs, (CharSequence)".js") + ".meta.js";
    }

    private final String getModuleNameFromPath(String path2) {
        int dotIndex = StringsKt.lastIndexOf$default((CharSequence)path2, (char)'.', (int)0, (boolean)false, (int)6, null);
        int slashIndex = Math.max(StringsKt.lastIndexOf$default((CharSequence)path2, (char)'/', (int)0, (boolean)false, (int)6, null), StringsKt.lastIndexOf$default((CharSequence)path2, (char)'\\', (int)0, (boolean)false, (int)6, null));
        String string2 = path2.substring(slashIndex + 1, dotIndex < 0 ? path2.length() : dotIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        return string2;
    }

    @Override
    @NotNull
    public String executableScriptFileName() {
        return "kotlin-dce-js";
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) {
        Companion.main(args);
    }

    public static final /* synthetic */ String access$metaJs(K2JSDce $this, String $receiver) {
        return $this.metaJs($receiver);
    }

    public static final /* synthetic */ String access$getModuleNameFromPath(K2JSDce $this, String path2) {
        return $this.getModuleNameFromPath(path2);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0007\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/cli/js/dce/K2JSDce$Companion;", "", "()V", "main", "", "args", "", "", "([Ljava/lang/String;)V", "cli-js"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void main(@NotNull String[] args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            CLITool.Companion.doMain(new K2JSDce(), args);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

