/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.HasAttributes;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.BrokenResolvedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariant;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariantSet;
import org.gradle.api.internal.artifacts.transform.AmbiguousTransformException;
import org.gradle.api.internal.artifacts.transform.ConsumerProvidedVariantFinder;
import org.gradle.api.internal.artifacts.transform.ExtraExecutionGraphDependenciesResolverFactory;
import org.gradle.api.internal.artifacts.transform.TransformedVariant;
import org.gradle.api.internal.artifacts.transform.TransformedVariantFactory;
import org.gradle.api.internal.artifacts.transform.VariantSelector;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributeDescriber;
import org.gradle.api.internal.attributes.AttributeValue;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.internal.Cast;
import org.gradle.internal.component.AmbiguousVariantSelectionException;
import org.gradle.internal.component.NoMatchingVariantSelectionException;
import org.gradle.internal.component.VariantSelectionException;
import org.gradle.internal.component.model.AttributeMatcher;
import org.gradle.internal.component.model.AttributeMatchingExplanationBuilder;
import org.gradle.internal.component.model.DescriberSelector;

class AttributeMatchingVariantSelector
implements VariantSelector {
    private final ConsumerProvidedVariantFinder consumerProvidedVariantFinder;
    private final AttributesSchemaInternal schema;
    private final ImmutableAttributesFactory attributesFactory;
    private final TransformedVariantFactory transformedVariantFactory;
    private final ImmutableAttributes requested;
    private final boolean ignoreWhenNoMatches;
    private final boolean selectFromAllVariants;
    private final ExtraExecutionGraphDependenciesResolverFactory dependenciesResolver;

    AttributeMatchingVariantSelector(ConsumerProvidedVariantFinder consumerProvidedVariantFinder, AttributesSchemaInternal schema, ImmutableAttributesFactory attributesFactory, TransformedVariantFactory transformedVariantFactory, ImmutableAttributes requested, boolean ignoreWhenNoMatches, boolean selectFromAllVariants, ExtraExecutionGraphDependenciesResolverFactory dependenciesResolver) {
        this.consumerProvidedVariantFinder = consumerProvidedVariantFinder;
        this.schema = schema;
        this.attributesFactory = attributesFactory;
        this.transformedVariantFactory = transformedVariantFactory;
        this.requested = requested;
        this.ignoreWhenNoMatches = ignoreWhenNoMatches;
        this.selectFromAllVariants = selectFromAllVariants;
        this.dependenciesResolver = dependenciesResolver;
    }

    public String toString() {
        return "Variant selector for " + this.requested;
    }

    @Override
    public ImmutableAttributes getRequestedAttributes() {
        return this.requested;
    }

    @Override
    public ResolvedArtifactSet select(ResolvedVariantSet producer, VariantSelector.Factory factory) {
        return this.selectAndWrapFailures(producer, this.ignoreWhenNoMatches, factory);
    }

    @Override
    public ResolvedArtifactSet maybeSelect(ResolvedVariantSet candidates, VariantSelector.Factory factory) {
        return this.selectAndWrapFailures(candidates, true, factory);
    }

    private ResolvedArtifactSet selectAndWrapFailures(ResolvedVariantSet producer, boolean ignoreWhenNoMatches, VariantSelector.Factory factory) {
        try {
            return this.doSelect(producer, ignoreWhenNoMatches, factory, AttributeMatchingExplanationBuilder.logging());
        }
        catch (VariantSelectionException t) {
            return new BrokenResolvedArtifactSet((Throwable)((Object)t));
        }
        catch (Exception t) {
            return new BrokenResolvedArtifactSet((Throwable)((Object)VariantSelectionException.selectionFailed(producer, t)));
        }
    }

    private ResolvedArtifactSet doSelect(ResolvedVariantSet producer, boolean ignoreWhenNoMatches, VariantSelector.Factory factory, AttributeMatchingExplanationBuilder explanationBuilder) {
        ImmutableAttributes componentRequested;
        ImmutableList variants;
        AttributeMatcher matcher = this.schema.withProducer(producer.getSchema());
        List matches = matcher.matches(variants = this.selectFromAllVariants ? ImmutableList.copyOf(producer.getAllVariants()) : ImmutableList.copyOf(producer.getVariants()), (AttributeContainerInternal)(componentRequested = this.attributesFactory.concat(this.requested, producer.getOverriddenAttributes())), explanationBuilder);
        if (matches.size() == 1) {
            return ((ResolvedVariant)matches.get(0)).getArtifacts();
        }
        if (matches.size() > 1) {
            TraceDiscardedVariants newExpBuilder = new TraceDiscardedVariants();
            matches = matcher.matches(variants, (AttributeContainerInternal)componentRequested, newExpBuilder);
            Set discarded = (Set)Cast.uncheckedCast((Object)newExpBuilder.discarded);
            AttributeDescriber describer = DescriberSelector.selectDescriber((AttributeContainerInternal)componentRequested, this.schema);
            throw new AmbiguousVariantSelectionException(describer, producer.asDescribable().getDisplayName(), (AttributeContainerInternal)componentRequested, matches, matcher, discarded);
        }
        List<TransformedVariant> transformedVariants = this.consumerProvidedVariantFinder.findTransformedVariants((List<ResolvedVariant>)variants, componentRequested);
        if (transformedVariants.size() > 1) {
            transformedVariants = this.tryDisambiguate(matcher, transformedVariants, componentRequested, explanationBuilder);
        }
        if (transformedVariants.size() == 1) {
            TransformedVariant result = transformedVariants.get(0);
            return factory.asTransformed(result.getRoot(), result.getVariantChain(), this.dependenciesResolver, this.transformedVariantFactory);
        }
        if (!transformedVariants.isEmpty()) {
            throw new AmbiguousTransformException(producer.asDescribable().getDisplayName(), (AttributeContainerInternal)componentRequested, transformedVariants);
        }
        if (ignoreWhenNoMatches) {
            return ResolvedArtifactSet.EMPTY;
        }
        throw new NoMatchingVariantSelectionException(producer.asDescribable().getDisplayName(), (AttributeContainerInternal)componentRequested, (Collection<? extends ResolvedVariant>)variants, matcher, DescriberSelector.selectDescriber((AttributeContainerInternal)componentRequested, this.schema));
    }

    private List<TransformedVariant> tryDisambiguate(AttributeMatcher matcher, List<TransformedVariant> candidates, ImmutableAttributes componentRequested, AttributeMatchingExplanationBuilder explanationBuilder) {
        List<TransformedVariant> matches = matcher.matches(candidates, (AttributeContainerInternal)componentRequested, explanationBuilder);
        if (matches.size() == 1) {
            return matches;
        }
        assert (matches.size() > 0);
        ArrayList<TransformedVariant> differentTransforms = new ArrayList<TransformedVariant>(1);
        TransformedVariant last = matches.get(matches.size() - 1);
        differentTransforms.add(last);
        for (int i = 0; i < matches.size() - 1; ++i) {
            TransformedVariant current = matches.get(i);
            if (!AttributeMatchingVariantSelector.candidatesDifferent(matcher, current, last)) continue;
            differentTransforms.add(current);
        }
        return differentTransforms;
    }

    private static boolean candidatesDifferent(AttributeMatcher matcher, TransformedVariant firstCandidate, TransformedVariant secondCandidate) {
        return !matcher.isMatching((AttributeContainerInternal)firstCandidate.getAttributes(), (AttributeContainerInternal)secondCandidate.getAttributes()) && !matcher.isMatching((AttributeContainerInternal)secondCandidate.getAttributes(), (AttributeContainerInternal)firstCandidate.getAttributes());
    }

    private static class TraceDiscardedVariants
    implements AttributeMatchingExplanationBuilder {
        private final Set<HasAttributes> discarded = Sets.newHashSet();

        private TraceDiscardedVariants() {
        }

        @Override
        public boolean canSkipExplanation() {
            return false;
        }

        @Override
        public <T extends HasAttributes> void candidateDoesNotMatchAttributes(T candidate, AttributeContainerInternal requested) {
            this.recordDiscardedCandidate(candidate);
        }

        public <T extends HasAttributes> void recordDiscardedCandidate(T candidate) {
            this.discarded.add(candidate);
        }

        @Override
        public <T extends HasAttributes> void candidateAttributeDoesNotMatch(T candidate, Attribute<?> attribute, Object requestedValue, AttributeValue<?> candidateValue) {
            this.recordDiscardedCandidate(candidate);
        }
    }
}

