/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.local.model;

import com.google.common.base.Optional;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.specs.ExcludeSpec;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.component.local.model.LocalComponentArtifactMetadata;
import org.gradle.internal.component.local.model.LocalComponentGraphResolveState;
import org.gradle.internal.component.local.model.LocalComponentMetadata;
import org.gradle.internal.component.local.model.LocalConfigurationGraphResolveMetadata;
import org.gradle.internal.component.local.model.LocalConfigurationMetadata;
import org.gradle.internal.component.model.AbstractComponentGraphResolveState;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ComponentArtifactResolveMetadata;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.component.model.ModuleSources;
import org.gradle.internal.component.model.VariantArtifactGraphResolveMetadata;
import org.gradle.internal.component.model.VariantArtifactResolveState;
import org.gradle.internal.component.model.VariantGraphResolveMetadata;
import org.gradle.internal.component.model.VariantResolveMetadata;
import org.gradle.internal.resolve.resolver.ArtifactSelector;

public class DefaultLocalComponentGraphResolveState
extends AbstractComponentGraphResolveState<LocalComponentMetadata, LocalComponentMetadata>
implements LocalComponentGraphResolveState {
    private final ConcurrentMap<LocalConfigurationGraphResolveMetadata, DefaultLocalVariantArtifactResolveState> variants = new ConcurrentHashMap<LocalConfigurationGraphResolveMetadata, DefaultLocalVariantArtifactResolveState>();

    @Override
    public ModuleVersionIdentifier getModuleVersionId() {
        return ((LocalComponentMetadata)this.getMetadata()).getModuleVersionId();
    }

    @Override
    public LocalComponentMetadata copy(ComponentIdentifier componentIdentifier, Transformer<LocalComponentArtifactMetadata, LocalComponentArtifactMetadata> artifacts) {
        return ((LocalComponentMetadata)this.getMetadata()).copy(componentIdentifier, artifacts);
    }

    public DefaultLocalComponentGraphResolveState(LocalComponentMetadata metadata) {
        super(metadata, metadata);
    }

    @Override
    public ComponentArtifactResolveMetadata getResolveMetadata() {
        return new LocalComponentArtifactResolveMetadata((LocalComponentMetadata)this.getMetadata());
    }

    @Override
    public VariantArtifactGraphResolveMetadata resolveArtifactsFor(VariantGraphResolveMetadata variant) {
        return this.stateFor((LocalConfigurationGraphResolveMetadata)variant);
    }

    @Override
    public VariantArtifactResolveState prepareForArtifactResolution(VariantGraphResolveMetadata variant) {
        return this.stateFor((LocalConfigurationGraphResolveMetadata)variant);
    }

    private DefaultLocalVariantArtifactResolveState stateFor(LocalConfigurationGraphResolveMetadata variant) {
        return this.variants.computeIfAbsent(variant, c -> new DefaultLocalVariantArtifactResolveState((LocalComponentMetadata)this.getMetadata(), variant));
    }

    private static class LocalComponentArtifactResolveMetadata
    implements ComponentArtifactResolveMetadata {
        private final LocalComponentMetadata metadata;

        public LocalComponentArtifactResolveMetadata(LocalComponentMetadata metadata) {
            this.metadata = metadata;
        }

        @Override
        public ComponentIdentifier getId() {
            return this.metadata.getId();
        }

        @Override
        public ModuleVersionIdentifier getModuleVersionId() {
            return this.metadata.getModuleVersionId();
        }

        @Override
        public ModuleSources getSources() {
            return this.metadata.getSources();
        }

        @Override
        public ImmutableAttributes getAttributes() {
            return this.metadata.getAttributes();
        }

        @Override
        public AttributesSchemaInternal getAttributesSchema() {
            return this.metadata.getAttributesSchema();
        }

        @Override
        public ComponentResolveMetadata getMetadata() {
            return this.metadata;
        }
    }

    private static class DefaultLocalVariantArtifactResolveState
    implements VariantArtifactResolveState,
    VariantArtifactGraphResolveMetadata {
        private final LocalComponentMetadata component;
        private final LocalConfigurationGraphResolveMetadata graphSelectedVariant;

        public DefaultLocalVariantArtifactResolveState(LocalComponentMetadata component, LocalConfigurationGraphResolveMetadata graphSelectedVariant) {
            this.component = component;
            this.graphSelectedVariant = graphSelectedVariant;
        }

        @Override
        public List<? extends ComponentArtifactMetadata> getArtifacts() {
            return this.graphSelectedVariant.prepareToResolveArtifacts().getArtifacts();
        }

        @Override
        public ComponentArtifactMetadata resolveArtifact(IvyArtifactName artifact) {
            return this.graphSelectedVariant.prepareToResolveArtifacts().artifact(artifact);
        }

        @Override
        public ArtifactSet resolveArtifacts(ArtifactSelector artifactSelector, ExcludeSpec exclusions, ImmutableAttributes overriddenAttributes) {
            LocalConfigurationMetadata configuration = this.graphSelectedVariant.prepareToResolveArtifacts();
            Set<? extends VariantResolveMetadata> fallbackVariants = configuration.getVariants();
            Optional variantsForGraphTraversal = this.component.getVariantsForGraphTraversal();
            return artifactSelector.resolveArtifacts(new LocalComponentArtifactResolveMetadata(this.component), () -> DefaultLocalVariantArtifactResolveState.buildAllVariants(fallbackVariants, (Optional<List<? extends VariantGraphResolveMetadata>>)variantsForGraphTraversal), fallbackVariants, exclusions, overriddenAttributes);
        }

        private static Set<? extends VariantResolveMetadata> buildAllVariants(Set<? extends VariantResolveMetadata> fallbackVariants, Optional<List<? extends VariantGraphResolveMetadata>> variantsForGraphTraversal) {
            Set<VariantResolveMetadata> allVariants = variantsForGraphTraversal.isPresent() ? ((List)variantsForGraphTraversal.get()).stream().map(LocalConfigurationGraphResolveMetadata.class::cast).map(LocalConfigurationGraphResolveMetadata::prepareToResolveArtifacts).flatMap(variant -> variant.getVariants().stream()).collect(Collectors.toSet()) : fallbackVariants;
            return allVariants;
        }
    }
}

