/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.capsule;

import io.usethesource.capsule.Set;
import io.usethesource.capsule.SetMultimapEq;
import io.usethesource.capsule.core.PersistentTrieSetMultimap;
import io.usethesource.capsule.util.EqualityComparator;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public interface SetMultimap<K, V> {
    public int size();

    default public int sizeDistinct() {
        return (int)this.entrySet().stream().map(Map.Entry::getKey).distinct().count();
    }

    public boolean isEmpty();

    public boolean containsKey(Object var1);

    public boolean containsValue(Object var1);

    public boolean containsEntry(Object var1, Object var2);

    public Set.Immutable<V> get(Object var1);

    public Set<K> keySet();

    public Collection<V> values();

    public Set<Map.Entry<K, V>> entrySet();

    public Iterator<K> keyIterator();

    public Iterator<V> valueIterator();

    public Iterator<Map.Entry<K, V>> entryIterator();

    default public Iterator<Map.Entry<K, Object>> nativeEntryIterator() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Not yet implemented @ Multi-Map.");
    }

    public <T> Iterator<T> tupleIterator(BiFunction<K, V, T> var1);

    default public <T> Stream<T> tupleStream(BiFunction<K, V, T> dataConverter) {
        Iterator<T> iterator = this.tupleIterator(dataConverter);
        int characteristics = 65;
        Spliterator<T> spliterator = Spliterators.spliterator(iterator, (long)this.size(), 65);
        return StreamSupport.stream(spliterator, false);
    }

    public int hashCode();

    public boolean equals(Object var1);

    public static interface Transient<K, V>
    extends SetMultimap<K, V>,
    SetMultimapEq.Transient<K, V> {
        default public boolean __put(K key, V value) {
            throw new UnsupportedOperationException("Not yet implemented @ Multi-Map.");
        }

        default public boolean __put(K key, Set.Immutable<V> values) {
            Set.Immutable oldValues = this.get(key);
            if (values.equals(oldValues)) {
                return false;
            }
            this.__remove(key);
            this.__insert(key, values);
            return true;
        }

        public boolean __insert(K var1, V var2);

        default public boolean __insert(K key, Set.Immutable<V> values) {
            Set.Immutable oldValues = this.get(key);
            if (values.equals(oldValues)) {
                return false;
            }
            values.forEach(value -> this.__insert(key, value));
            return true;
        }

        default public boolean __remove(K key) {
            int oldSize = this.size();
            Set.Immutable values = this.get(key);
            values.forEach(value -> this.__remove(key, value));
            int newSize = this.size();
            return oldSize != newSize;
        }

        public boolean __remove(K var1, V var2);

        default public boolean union(SetMultimap<? extends K, ? extends V> setMultimap) {
            throw new UnsupportedOperationException("Not yet implemented @ Multi-Map.");
        }

        default public boolean intersect(SetMultimap<? extends K, ? extends V> setMultimap) {
            throw new UnsupportedOperationException("Not yet implemented @ Multi-Map.");
        }

        default public boolean complement(SetMultimap<? extends K, ? extends V> setMultimap) {
            throw new UnsupportedOperationException("Not yet implemented @ Multi-Map.");
        }

        public Immutable<K, V> freeze();

        public static <K, V> Transient<K, V> of() {
            return PersistentTrieSetMultimap.transientOf();
        }

        @Deprecated
        public static <K, V> Transient<K, V> of(EqualityComparator<Object> cmp) {
            return PersistentTrieSetMultimap.transientOf(cmp);
        }
    }

    public static interface Immutable<K, V>
    extends SetMultimap<K, V>,
    SetMultimapEq.Immutable<K, V> {
        public Immutable<K, V> __put(K var1, V var2);

        default public Immutable<K, V> __put(K key, Set.Immutable<V> values) {
            throw new UnsupportedOperationException("Not yet implemented @ Multi-Map.");
        }

        public Immutable<K, V> __insert(K var1, V var2);

        default public Immutable<K, V> __insert(K key, Set.Immutable<V> values) {
            Transient builder = this.asTransient();
            values.forEach(value -> builder.__insert(key, value));
            return builder.freeze();
        }

        default public Immutable<K, V> __insert(Set.Immutable<K> keys, V value) {
            Transient tmp = this.asTransient();
            keys.forEach(key -> tmp.__insert(key, value));
            return tmp.freeze();
        }

        default public Immutable<K, V> __remove(K key) {
            throw new UnsupportedOperationException("Not yet implemented @ Multi-Map.");
        }

        public Immutable<K, V> __remove(K var1, V var2);

        default public Immutable<K, V> union(SetMultimap<? extends K, ? extends V> setMultimap) {
            throw new UnsupportedOperationException("Not yet implemented @ Multi-Map.");
        }

        default public Immutable<K, V> intersect(SetMultimap<? extends K, ? extends V> setMultimap) {
            throw new UnsupportedOperationException("Not yet implemented @ Multi-Map.");
        }

        default public Immutable<K, V> complement(SetMultimap<? extends K, ? extends V> setMultimap) {
            Transient builder = Transient.of();
            setMultimap.entrySet().stream().filter(entry -> !this.containsEntry(entry.getKey(), entry.getValue())).forEach(entry -> builder.__insert(entry.getKey(), entry.getValue()));
            return builder.freeze();
        }

        default public Immutable<V, K> inverseMap() {
            throw new UnsupportedOperationException("Not yet implemented @ Multi-Map.");
        }

        public boolean isTransientSupported();

        public Transient<K, V> asTransient();

        public static <K, V> Immutable<K, V> of() {
            return PersistentTrieSetMultimap.of();
        }

        public static <K, V> Immutable<K, V> of(K key, V value) {
            return PersistentTrieSetMultimap.of(key, new Object[]{value});
        }

        public static <K, V> Immutable<K, V> of(K key0, V value0, K key1, V value1) {
            return PersistentTrieSetMultimap.of(key0, value0, key1, value1);
        }

        @Deprecated
        public static <K, V> Immutable<K, V> of(EqualityComparator<Object> cmp) {
            return PersistentTrieSetMultimap.of(cmp);
        }
    }
}

