/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.AttributesSchema;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.BrokenResolvedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariant;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariantSet;
import org.gradle.api.internal.artifacts.transform.AmbiguousTransformException;
import org.gradle.api.internal.artifacts.transform.TransformedVariant;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributeDescriber;
import org.gradle.api.internal.attributes.AttributeValue;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.problems.Problems;
import org.gradle.internal.Cast;
import org.gradle.internal.component.AmbiguousConfigurationSelectionException;
import org.gradle.internal.component.AmbiguousVariantSelectionException;
import org.gradle.internal.component.CapabilitiesSupport;
import org.gradle.internal.component.IncompatibleConfigurationSelectionException;
import org.gradle.internal.component.NoMatchingCapabilitiesException;
import org.gradle.internal.component.NoMatchingConfigurationSelectionException;
import org.gradle.internal.component.NoMatchingVariantSelectionException;
import org.gradle.internal.component.StyledDescriber;
import org.gradle.internal.component.VariantSelectionException;
import org.gradle.internal.component.model.AttributeMatcher;
import org.gradle.internal.component.model.ComponentGraphResolveMetadata;
import org.gradle.internal.component.model.ConfigurationGraphResolveMetadata;
import org.gradle.internal.component.model.ConfigurationGraphResolveState;
import org.gradle.internal.component.model.GraphSelectionCandidates;
import org.gradle.internal.component.model.VariantGraphResolveMetadata;
import org.gradle.internal.component.model.VariantGraphResolveState;
import org.gradle.internal.exceptions.StyledException;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.internal.logging.text.TreeFormatter;

public class SelectionFailureHandler {
    private static final String FAILURE_TYPE = "Variant Selection Failure";
    private final Problems problemsService;

    public SelectionFailureHandler(Problems problemsService) {
        this.problemsService = problemsService;
    }

    public NoMatchingVariantSelectionException noMatchingVariantsSelectionFailure(AttributesSchema schema, String displayName, ImmutableAttributes componentRequested, List<? extends ResolvedVariant> variants, AttributeMatcher matcher, AttributeDescriber attributeDescriber) {
        String message = this.buildNoMatchingVariantsFailureMsg(displayName, (AttributeContainerInternal)componentRequested, variants, matcher, attributeDescriber);
        NoMatchingVariantSelectionException e = new NoMatchingVariantSelectionException(message);
        return e;
    }

    public AmbiguousVariantSelectionException ambiguousVariantSelectionFailure(AttributesSchema schema, String displayName, ImmutableAttributes componentRequested, List<? extends ResolvedVariant> matches, AttributeMatcher matcher, Set<ResolvedVariant> discarded, AttributeDescriber attributeDescriber) {
        String message = this.buildMultipleMatchingVariantsFailureMsg(attributeDescriber, displayName, (AttributeContainerInternal)componentRequested, matches, matcher, discarded);
        AmbiguousVariantSelectionException e = new AmbiguousVariantSelectionException(message);
        return e;
    }

    public AmbiguousTransformException ambiguousTransformationFailure(AttributesSchema schema, String displayName, ImmutableAttributes componentRequested, List<TransformedVariant> transformedVariants) {
        String message = this.buildAmbiguousTransformMsg(displayName, (AttributeContainerInternal)componentRequested, transformedVariants);
        AmbiguousTransformException e = new AmbiguousTransformException(message);
        return e;
    }

    public BrokenResolvedArtifactSet unknownSelectionFailure(AttributesSchema schema, VariantSelectionException t) {
        return new BrokenResolvedArtifactSet((Throwable)((Object)t));
    }

    public BrokenResolvedArtifactSet unknownSelectionFailure(AttributesSchema schema, ResolvedVariantSet producer, Exception t) {
        return this.unknownSelectionFailure(schema, VariantSelectionException.selectionFailed(producer, t));
    }

    private String buildNoMatchingVariantsFailureMsg(String producerDisplayName, AttributeContainerInternal consumer, Collection<? extends ResolvedVariant> candidates, AttributeMatcher matcher, AttributeDescriber describer) {
        TreeFormatter formatter = new TreeFormatter();
        formatter.node("No variants of " + StyledException.style((StyledTextOutput.Style)StyledTextOutput.Style.Info, (String)producerDisplayName) + " match the consumer attributes");
        formatter.startChildren();
        for (ResolvedVariant resolvedVariant : candidates) {
            formatter.node(resolvedVariant.asDescribable().getCapitalizedDisplayName());
            this.formatAttributeMatchesForIncompatibility(formatter, consumer.asImmutable(), matcher, resolvedVariant.getAttributes().asImmutable(), describer);
        }
        formatter.endChildren();
        return formatter.toString();
    }

    private String buildMultipleMatchingVariantsFailureMsg(AttributeDescriber describer, String producerDisplayName, AttributeContainerInternal consumer, List<? extends ResolvedVariant> variants, AttributeMatcher matcher, Set<ResolvedVariant> discarded) {
        TreeFormatter formatter = new TreeFormatter();
        if (consumer.getAttributes().isEmpty()) {
            formatter.node("More than one variant of " + producerDisplayName + " matches the consumer attributes");
        } else {
            formatter.node("The consumer was configured to find " + describer.describeAttributeSet(consumer.asMap()) + ". However we cannot choose between the following variants of " + producerDisplayName);
        }
        formatter.startChildren();
        for (ResolvedVariant resolvedVariant : variants) {
            formatter.node(resolvedVariant.asDescribable().getCapitalizedDisplayName());
            this.formatAttributeMatchesForAmbiguity(formatter, consumer.asImmutable(), matcher, resolvedVariant.getAttributes().asImmutable(), describer);
        }
        formatter.endChildren();
        if (!discarded.isEmpty()) {
            formatter.node("The following variants were also considered but didn't match the requested attributes:");
            formatter.startChildren();
            discarded.stream().sorted(Comparator.comparing(v -> v.asDescribable().getCapitalizedDisplayName())).forEach(discardedVariant -> {
                formatter.node(discardedVariant.asDescribable().getCapitalizedDisplayName());
                this.formatAttributeMatchesForIncompatibility(formatter, consumer.asImmutable(), matcher, discardedVariant.getAttributes().asImmutable(), describer);
            });
            formatter.endChildren();
        }
        return formatter.toString();
    }

    private String buildAmbiguousTransformMsg(String producerDisplayName, AttributeContainerInternal requested, List<TransformedVariant> candidates) {
        TreeFormatter formatter = new TreeFormatter();
        formatter.node("Found multiple transforms that can produce a variant of " + producerDisplayName + " with requested attributes");
        this.formatSortedAttributes(formatter, (AttributeContainer)requested);
        formatter.node("Found the following transforms");
        Comparator<TransformedVariant> variantComparator = Comparator.comparing(x -> x.getTransformChain().getDisplayName()).thenComparing(x -> x.getAttributes().toString());
        Map variantToTransforms = candidates.stream().collect(Collectors.groupingBy(TransformedVariant::getRoot, () -> new TreeMap(Comparator.comparing(variant -> variant.asDescribable().getDisplayName())), Collectors.collectingAndThen(Collectors.toList(), list -> list.stream().sorted(variantComparator).collect(Collectors.toList()))));
        formatter.startChildren();
        for (Map.Entry entry : variantToTransforms.entrySet()) {
            formatter.node("From '" + ((ResolvedVariant)entry.getKey()).asDescribable().getDisplayName() + "'");
            formatter.startChildren();
            formatter.node("With source attributes");
            this.formatSortedAttributes(formatter, (AttributeContainer)((ResolvedVariant)entry.getKey()).getAttributes());
            formatter.node("Candidate transform(s)");
            formatter.startChildren();
            for (TransformedVariant variant : (List)entry.getValue()) {
                formatter.node("Transform '" + variant.getTransformChain().getDisplayName() + "' producing attributes:");
                this.formatSortedAttributes(formatter, (AttributeContainer)variant.getAttributes());
            }
            formatter.endChildren();
            formatter.endChildren();
        }
        formatter.endChildren();
        return formatter.toString();
    }

    private void formatSortedAttributes(TreeFormatter formatter, AttributeContainer attributes) {
        formatter.startChildren();
        for (Attribute attribute : Ordering.usingToString().sortedCopy((Iterable)attributes.keySet())) {
            formatter.node(attribute.getName() + " '" + attributes.getAttribute(attribute) + "'");
        }
        formatter.endChildren();
    }

    public AmbiguousConfigurationSelectionException ambiguousConfigurationSelectionFailure(AttributeDescriber describer, AttributeContainerInternal fromConfigurationAttributes, AttributeMatcher attributeMatcher, List<? extends VariantGraphResolveState> matches, ComponentGraphResolveMetadata targetComponent, boolean variantAware, Set<VariantGraphResolveState> discarded) {
        String message = this.buildAmbiguousConfigurationSelectionFailureMsg(new StyledDescriber(describer), fromConfigurationAttributes, attributeMatcher, matches, targetComponent, variantAware, discarded);
        AmbiguousConfigurationSelectionException e = new AmbiguousConfigurationSelectionException(message);
        return e;
    }

    public IncompatibleConfigurationSelectionException incompatibleConfigurationSelectionFailure(AttributeContainerInternal fromConfigurationAttributes, AttributeMatcher attributeMatcher, ComponentGraphResolveMetadata targetComponent, ConfigurationGraphResolveState targetConfiguration, boolean variantAware, AttributeDescriber describer) {
        String message = this.buildIncompatibleConfigurationSelectionFailureMsg(fromConfigurationAttributes, attributeMatcher, targetComponent, targetConfiguration, variantAware, describer);
        IncompatibleConfigurationSelectionException e = new IncompatibleConfigurationSelectionException(message);
        return e;
    }

    public NoMatchingConfigurationSelectionException noMatchingConfigurationSelectionFailure(AttributeDescriber describer, AttributeContainerInternal fromConfigurationAttributes, AttributeMatcher attributeMatcher, ComponentGraphResolveMetadata targetComponent, GraphSelectionCandidates candidates) {
        String message = this.buildNoMatchingConfigurationSelectionFailureMsg(new StyledDescriber(describer), fromConfigurationAttributes, attributeMatcher, targetComponent, candidates);
        NoMatchingConfigurationSelectionException e = new NoMatchingConfigurationSelectionException(message);
        return e;
    }

    public NoMatchingCapabilitiesException noMatchingCapabilitiesFailure(ComponentGraphResolveMetadata targetComponent, Collection<? extends Capability> requestedCapabilities, List<? extends VariantGraphResolveState> candidates) {
        String message = SelectionFailureHandler.buildNoMatchingCapabilitiesFailureMsg(targetComponent, requestedCapabilities, candidates);
        NoMatchingCapabilitiesException e = new NoMatchingCapabilitiesException(message);
        return e;
    }

    private String buildAmbiguousConfigurationSelectionFailureMsg(AttributeDescriber describer, AttributeContainerInternal fromConfigurationAttributes, AttributeMatcher attributeMatcher, List<? extends VariantGraphResolveState> matches, ComponentGraphResolveMetadata targetComponent, boolean variantAware, Set<VariantGraphResolveState> discarded) {
        String string;
        TreeMap<String, VariantGraphResolveState> ambiguousVariants = new TreeMap<String, VariantGraphResolveState>();
        for (VariantGraphResolveState variantGraphResolveState : matches) {
            ambiguousVariants.put(variantGraphResolveState.getName(), variantGraphResolveState);
        }
        TreeFormatter formatter = new TreeFormatter();
        String string2 = string = variantAware ? "variants" : "configurations";
        if (fromConfigurationAttributes.isEmpty()) {
            formatter.node("Cannot choose between the following " + string + " of ");
        } else {
            formatter.node("The consumer was configured to find " + describer.describeAttributeSet(fromConfigurationAttributes.asMap()) + ". However we cannot choose between the following " + string + " of ");
        }
        formatter.append((CharSequence)StyledException.style((StyledTextOutput.Style)StyledTextOutput.Style.Info, (String)targetComponent.getId().getDisplayName()));
        formatter.startChildren();
        for (String configuration : ambiguousVariants.keySet()) {
            formatter.node(configuration);
        }
        formatter.endChildren();
        formatter.node("All of them match the consumer attributes");
        formatter.startChildren();
        for (VariantGraphResolveState ambiguousVariant : ambiguousVariants.values()) {
            this.formatConfiguration(formatter, targetComponent, fromConfigurationAttributes, attributeMatcher, ambiguousVariant.getMetadata(), variantAware, true, describer);
        }
        formatter.endChildren();
        if (!discarded.isEmpty()) {
            formatter.node("The following " + string + " were also considered but didn't match the requested attributes:");
            formatter.startChildren();
            discarded.stream().sorted(Comparator.comparing(VariantGraphResolveState::getName)).forEach(discardedConf -> this.formatConfiguration(formatter, targetComponent, fromConfigurationAttributes, attributeMatcher, discardedConf.getMetadata(), variantAware, false, describer));
            formatter.endChildren();
        }
        return formatter.toString();
    }

    private String buildIncompatibleConfigurationSelectionFailureMsg(AttributeContainerInternal fromConfigurationAttributes, AttributeMatcher attributeMatcher, ComponentGraphResolveMetadata targetComponent, ConfigurationGraphResolveState targetConfiguration, boolean variantAware, AttributeDescriber describer) {
        TreeFormatter formatter = new TreeFormatter();
        formatter.node("Configuration '" + targetConfiguration.getName() + "' in " + StyledException.style((StyledTextOutput.Style)StyledTextOutput.Style.Info, (String)targetComponent.getId().getDisplayName()) + " does not match the consumer attributes");
        this.formatConfiguration(formatter, targetComponent, fromConfigurationAttributes, attributeMatcher, targetConfiguration.asVariant().getMetadata(), variantAware, false, describer);
        return formatter.toString();
    }

    private String buildNoMatchingConfigurationSelectionFailureMsg(AttributeDescriber describer, AttributeContainerInternal fromConfigurationAttributes, AttributeMatcher attributeMatcher, ComponentGraphResolveMetadata targetComponent, GraphSelectionCandidates candidates) {
        boolean variantAware = candidates.isUseVariants();
        TreeMap<String, VariantGraphResolveMetadata> variants = new TreeMap<String, VariantGraphResolveMetadata>();
        if (variantAware) {
            for (VariantGraphResolveState variantGraphResolveState : candidates.getVariants()) {
                variants.put(variantGraphResolveState.getName(), variantGraphResolveState.getMetadata());
            }
        } else {
            for (ConfigurationGraphResolveMetadata configurationGraphResolveMetadata : candidates.getCandidateConfigurations()) {
                variants.put(configurationGraphResolveMetadata.getName(), configurationGraphResolveMetadata);
            }
        }
        TreeFormatter formatter = new TreeFormatter();
        String string = StyledException.style((StyledTextOutput.Style)StyledTextOutput.Style.Info, (String)targetComponent.getId().getDisplayName());
        if (fromConfigurationAttributes.isEmpty()) {
            formatter.node("Unable to find a matching " + (variantAware ? "variant" : "configuration") + " of " + string);
        } else {
            formatter.node("No matching " + (variantAware ? "variant" : "configuration") + " of " + string + " was found. The consumer was configured to find " + describer.describeAttributeSet(fromConfigurationAttributes.asMap()) + " but:");
        }
        formatter.startChildren();
        if (variants.isEmpty()) {
            formatter.node("None of the " + (variantAware ? "variants" : "consumable configurations") + " have attributes.");
        } else {
            for (VariantGraphResolveMetadata variant : variants.values()) {
                this.formatConfiguration(formatter, targetComponent, fromConfigurationAttributes, attributeMatcher, variant, variantAware, false, describer);
            }
        }
        formatter.endChildren();
        return formatter.toString();
    }

    private static String buildNoMatchingCapabilitiesFailureMsg(ComponentGraphResolveMetadata targetComponent, Collection<? extends Capability> requestedCapabilities, List<? extends VariantGraphResolveState> candidates) {
        StringBuilder sb = new StringBuilder("Unable to find a variant of ");
        sb.append(targetComponent.getId()).append(" providing the requested ");
        sb.append(CapabilitiesSupport.prettifyCapabilities(targetComponent, requestedCapabilities));
        sb.append(":\n");
        for (VariantGraphResolveState variantGraphResolveState : candidates) {
            sb.append("   - Variant ").append(variantGraphResolveState.getName()).append(" provides ");
            sb.append(CapabilitiesSupport.sortedCapabilityList(targetComponent, variantGraphResolveState.getCapabilities().getCapabilities())).append("\n");
        }
        return sb.toString();
    }

    private void formatConfiguration(TreeFormatter formatter, ComponentGraphResolveMetadata targetComponent, AttributeContainerInternal consumerAttributes, AttributeMatcher attributeMatcher, VariantGraphResolveMetadata variant, boolean variantAware, boolean ambiguous, AttributeDescriber describer) {
        ImmutableAttributes producerAttributes = variant.getAttributes();
        if (variantAware) {
            formatter.node("Variant '");
        } else {
            formatter.node("Configuration '");
        }
        formatter.append((CharSequence)variant.getName());
        formatter.append((CharSequence)"'");
        if (variantAware) {
            formatter.append((CharSequence)(" " + CapabilitiesSupport.prettifyCapabilities(targetComponent, variant.getCapabilities().getCapabilities())));
        }
        if (ambiguous) {
            this.formatAttributeMatchesForAmbiguity(formatter, consumerAttributes.asImmutable(), attributeMatcher, producerAttributes.asImmutable(), describer);
        } else {
            this.formatAttributeMatchesForIncompatibility(formatter, consumerAttributes.asImmutable(), attributeMatcher, producerAttributes.asImmutable(), describer);
        }
    }

    private void formatAttributeMatchesForIncompatibility(TreeFormatter formatter, ImmutableAttributes immutableConsumer, AttributeMatcher attributeMatcher, ImmutableAttributes immutableProducer, AttributeDescriber describer) {
        Map<String, Attribute<?>> allAttributes = this.collectAttributes(immutableConsumer, immutableProducer);
        ArrayList otherValues = Lists.newArrayListWithExpectedSize((int)allAttributes.size());
        LinkedHashMap compatibleAttrs = Maps.newLinkedHashMap();
        LinkedHashMap incompatibleAttrs = Maps.newLinkedHashMap();
        LinkedHashMap incompatibleConsumerAttrs = Maps.newLinkedHashMap();
        for (Attribute<?> attribute : allAttributes.values()) {
            Attribute untyped = (Attribute)Cast.uncheckedCast(attribute);
            String attributeName = attribute.getName();
            AttributeValue consumerValue = immutableConsumer.findEntry(untyped);
            AttributeValue producerValue = immutableProducer.findEntry(attributeName);
            if (consumerValue.isPresent() && producerValue.isPresent()) {
                if (attributeMatcher.isMatching(untyped, producerValue.coerce(attribute), consumerValue.coerce(attribute))) {
                    compatibleAttrs.put(attribute, Cast.uncheckedCast((Object)producerValue.get()));
                    continue;
                }
                incompatibleAttrs.put(attribute, Cast.uncheckedCast((Object)producerValue.get()));
                incompatibleConsumerAttrs.put(attribute, Cast.uncheckedCast((Object)consumerValue.get()));
                continue;
            }
            if (!consumerValue.isPresent()) continue;
            otherValues.add("Doesn't say anything about " + describer.describeMissingAttribute(attribute, consumerValue.get()));
        }
        if (!compatibleAttrs.isEmpty()) {
            formatter.append((CharSequence)" declares ").append((CharSequence)StyledException.style((StyledTextOutput.Style)StyledTextOutput.Style.SuccessHeader, (String)describer.describeAttributeSet((Map)compatibleAttrs)));
        }
        formatter.startChildren();
        if (!incompatibleAttrs.isEmpty()) {
            formatter.node("Incompatible because this component declares " + StyledException.style((StyledTextOutput.Style)StyledTextOutput.Style.FailureHeader, (String)describer.describeAttributeSet((Map)incompatibleAttrs)) + " and the consumer needed <FailureHeader>" + describer.describeAttributeSet((Map)incompatibleConsumerAttrs) + "</FailureHeader>");
        }
        this.formatAttributeSection(formatter, "Other compatible attribute", otherValues);
        formatter.endChildren();
    }

    private void formatAttributeMatchesForAmbiguity(TreeFormatter formatter, ImmutableAttributes immutableConsumer, AttributeMatcher attributeMatcher, ImmutableAttributes immutableProducer, AttributeDescriber describer) {
        Map<String, Attribute<?>> allAttributes = this.collectAttributes(immutableConsumer, immutableProducer);
        LinkedHashMap compatibleAttrs = Maps.newLinkedHashMap();
        ArrayList otherValues = Lists.newArrayListWithExpectedSize((int)allAttributes.size());
        for (Attribute<?> attribute : allAttributes.values()) {
            Attribute untyped = (Attribute)Cast.uncheckedCast(attribute);
            String attributeName = attribute.getName();
            AttributeValue consumerValue = immutableConsumer.findEntry(untyped);
            AttributeValue producerValue = immutableProducer.findEntry(attributeName);
            if (consumerValue.isPresent() && producerValue.isPresent()) {
                if (!attributeMatcher.isMatching(untyped, producerValue.coerce(attribute), consumerValue.coerce(attribute))) continue;
                compatibleAttrs.put(attribute, Cast.uncheckedCast((Object)producerValue.get()));
                continue;
            }
            if (consumerValue.isPresent()) {
                otherValues.add("Doesn't say anything about " + describer.describeMissingAttribute(attribute, consumerValue.get()));
                continue;
            }
            otherValues.add("Provides " + describer.describeExtraAttribute(attribute, producerValue.get()) + " but the consumer didn't ask for it");
        }
        if (!compatibleAttrs.isEmpty()) {
            formatter.append((CharSequence)" declares ").append((CharSequence)StyledException.style((StyledTextOutput.Style)StyledTextOutput.Style.SuccessHeader, (String)describer.describeAttributeSet((Map)compatibleAttrs)));
        }
        formatter.startChildren();
        this.formatAttributeSection(formatter, "Unmatched attribute", otherValues);
        formatter.endChildren();
    }

    private Map<String, Attribute<?>> collectAttributes(ImmutableAttributes consumerAttributes, ImmutableAttributes producerAttributes) {
        TreeMap allAttributes = new TreeMap();
        for (Attribute attribute : producerAttributes.keySet()) {
            allAttributes.put(attribute.getName(), attribute);
        }
        for (Attribute attribute : consumerAttributes.keySet()) {
            allAttributes.put(attribute.getName(), attribute);
        }
        return allAttributes;
    }

    private void formatAttributeSection(TreeFormatter formatter, String section, List<String> values) {
        if (!values.isEmpty()) {
            if (values.size() > 1) {
                formatter.node(section + "s");
            } else {
                formatter.node(section);
            }
            formatter.startChildren();
            values.forEach(arg_0 -> ((TreeFormatter)formatter).node(arg_0));
            formatter.endChildren();
        }
    }
}

