/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.LocalComponentInAnotherBuildProvider;
import org.gradle.api.internal.project.HoldsProjectState;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.api.internal.tasks.NodeExecutionContext;
import org.gradle.composite.internal.IncludedBuildDependencyMetadataBuilder;
import org.gradle.internal.Describables;
import org.gradle.internal.build.CompositeBuildParticipantBuildState;
import org.gradle.internal.build.IncludedBuildState;
import org.gradle.internal.component.local.model.LocalComponentGraphResolveState;
import org.gradle.internal.component.local.model.LocalComponentGraphResolveStateFactory;
import org.gradle.internal.component.local.model.LocalComponentMetadata;
import org.gradle.internal.model.CalculatedValueContainer;
import org.gradle.internal.model.CalculatedValueContainerFactory;
import org.gradle.internal.model.ValueCalculator;

public class DefaultLocalComponentInAnotherBuildProvider
implements LocalComponentInAnotherBuildProvider,
HoldsProjectState {
    private final IncludedBuildDependencyMetadataBuilder dependencyMetadataBuilder;
    private final LocalComponentGraphResolveStateFactory resolveStateFactory;
    private final CalculatedValueContainerFactory calculatedValueContainerFactory;
    private final Map<ProjectComponentIdentifier, CalculatedValueContainer<LocalComponentGraphResolveState, ?>> projects = new ConcurrentHashMap();

    public DefaultLocalComponentInAnotherBuildProvider(IncludedBuildDependencyMetadataBuilder dependencyMetadataBuilder, LocalComponentGraphResolveStateFactory resolveStateFactory, CalculatedValueContainerFactory calculatedValueContainerFactory) {
        this.dependencyMetadataBuilder = dependencyMetadataBuilder;
        this.resolveStateFactory = resolveStateFactory;
        this.calculatedValueContainerFactory = calculatedValueContainerFactory;
    }

    public LocalComponentGraphResolveState getComponent(ProjectState projectState) {
        ProjectComponentIdentifier projectIdentifier = projectState.getComponentIdentifier();
        CalculatedValueContainer valueContainer = this.projects.computeIfAbsent(projectIdentifier, projectComponentIdentifier -> this.calculatedValueContainerFactory.create(Describables.of((Object)"metadata of", (Object)projectIdentifier), (ValueCalculator)new MetadataSupplier(projectState)));
        valueContainer.finalizeIfNotAlready();
        return (LocalComponentGraphResolveState)valueContainer.get();
    }

    public void discardAll() {
        this.projects.clear();
    }

    private class MetadataSupplier
    implements ValueCalculator<LocalComponentGraphResolveState> {
        private final ProjectState projectState;

        public MetadataSupplier(ProjectState projectState) {
            this.projectState = projectState;
        }

        public LocalComponentGraphResolveState calculateValue(NodeExecutionContext context) {
            CompositeBuildParticipantBuildState buildState = (CompositeBuildParticipantBuildState)this.projectState.getOwner();
            if (buildState instanceof IncludedBuildState) {
                buildState.ensureProjectsConfigured();
            }
            LocalComponentMetadata metadata = (LocalComponentMetadata)this.projectState.fromMutableState(p -> DefaultLocalComponentInAnotherBuildProvider.this.dependencyMetadataBuilder.build(buildState, this.projectState.getComponentIdentifier()));
            return DefaultLocalComponentInAnotherBuildProvider.this.resolveStateFactory.stateFor(metadata);
        }
    }
}

