/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.maven.internal.validation;

import com.google.common.base.Strings;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.api.NonNullApi;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.PublishException;
import org.gradle.api.publish.internal.validation.PublicationErrorChecker;
import org.gradle.api.publish.maven.MavenArtifact;
import org.gradle.api.publish.maven.internal.artifact.DefaultMavenArtifactSet;

@NonNullApi
public abstract class MavenPublicationErrorChecker
extends PublicationErrorChecker {
    private static final Comparator<Set<ArtifactDifference>> DIFFERENCE_SET_COMPARATOR = Comparator.comparingInt(Set::size).thenComparing(set -> set.contains((Object)ArtifactDifference.FILE)).thenComparing(set -> set.contains((Object)ArtifactDifference.CLASSIFIER)).thenComparing(set -> set.contains((Object)ArtifactDifference.EXTENSION));
    private static final Comparator<Map.Entry<MavenArtifact, Set<ArtifactDifference>>> DIFFERENCE_ENTRY_COMPARATOR = Map.Entry.comparingByValue(DIFFERENCE_SET_COMPARATOR).thenComparing(entry -> ((MavenArtifact)entry.getKey()).getFile().toPath());

    public static void checkThatArtifactIsPublishedUnmodified(Path buildDir, String componentName, PublishArtifact source, DefaultMavenArtifactSet mainArtifacts) {
        HashMap<MavenArtifact, Set<ArtifactDifference>> differences = new HashMap<MavenArtifact, Set<ArtifactDifference>>();
        Iterator iterator = mainArtifacts.iterator();
        while (iterator.hasNext()) {
            MavenArtifact mavenArtifact = (MavenArtifact)iterator.next();
            EnumSet<ArtifactDifference> differenceSet = EnumSet.noneOf(ArtifactDifference.class);
            if (!source.getFile().equals(mavenArtifact.getFile())) {
                differenceSet.add(ArtifactDifference.FILE);
            }
            if (!Strings.nullToEmpty((String)source.getClassifier()).equals(Strings.nullToEmpty((String)mavenArtifact.getClassifier()))) {
                differenceSet.add(ArtifactDifference.CLASSIFIER);
            }
            if (!source.getExtension().equals(mavenArtifact.getExtension())) {
                differenceSet.add(ArtifactDifference.EXTENSION);
            }
            if (differenceSet.isEmpty()) {
                return;
            }
            differences.put(mavenArtifact, differenceSet);
        }
        throw new PublishException("Cannot publish module metadata because an artifact from the '" + componentName + "' component has been removed. The available artifacts had these problems:\n" + MavenPublicationErrorChecker.formatDifferences(buildDir, source, differences));
    }

    private static String formatDifferences(Path buildDir, PublishArtifact source, Map<MavenArtifact, Set<ArtifactDifference>> differencesByArtifact) {
        Stream<String> differencesFormatted = differencesByArtifact.entrySet().stream().sorted(DIFFERENCE_ENTRY_COMPARATOR).limit(3L).map(entry -> {
            MavenArtifact artifact = (MavenArtifact)entry.getKey();
            Set differenceSet = (Set)entry.getValue();
            Path artifactPath = buildDir.relativize(artifact.getFile().toPath());
            return "- " + artifactPath + ":\n" + MavenPublicationErrorChecker.formatDifferenceSet(buildDir, source, artifact, differenceSet);
        });
        Stream warningForNonPrintedArtifacts = differencesByArtifact.size() > 3 ? Stream.of("... (" + (differencesByArtifact.size() - 3) + " more artifact(s) not shown)") : Stream.empty();
        return Stream.concat(differencesFormatted, warningForNonPrintedArtifacts).collect(Collectors.joining("\n", "", "\n"));
    }

    private static String formatDifferenceSet(Path buildDir, PublishArtifact expected, MavenArtifact actual, Set<ArtifactDifference> differenceSet) {
        return differenceSet.stream().map(diff -> {
            switch (diff) {
                case FILE: {
                    Path expectedFile = buildDir.relativize(expected.getFile().toPath());
                    Path actualFile = buildDir.relativize(actual.getFile().toPath());
                    return "\t- file differs: (expected) " + expectedFile + " != (actual) " + actualFile;
                }
                case CLASSIFIER: {
                    return "\t- classifier differs: (expected) " + expected.getClassifier() + " != (actual) " + actual.getClassifier();
                }
                case EXTENSION: {
                    return "\t- extension differs: (expected) " + expected.getExtension() + " != (actual) " + actual.getExtension();
                }
            }
            throw new IllegalArgumentException("Unknown difference: " + (Object)diff);
        }).collect(Collectors.joining("\n"));
    }

    @NonNullApi
    private static enum ArtifactDifference {
        FILE,
        CLASSIFIER,
        EXTENSION;

    }
}

