/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.notations;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.gradle.api.artifacts.SelfResolvingDependency;
import org.gradle.api.internal.ClassPathRegistry;
import org.gradle.api.internal.artifacts.dependencies.DefaultSelfResolvingDependency;
import org.gradle.api.internal.artifacts.dsl.dependencies.DependencyFactoryInternal;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.collections.MinimalFileSet;
import org.gradle.api.internal.runtimeshaded.RuntimeShadedJarFactory;
import org.gradle.api.internal.runtimeshaded.RuntimeShadedJarType;
import org.gradle.internal.component.local.model.OpaqueComponentIdentifier;
import org.gradle.internal.exceptions.DiagnosticsVisitor;
import org.gradle.internal.installation.CurrentGradleInstallation;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.typeconversion.NotationConvertResult;
import org.gradle.internal.typeconversion.NotationConverter;
import org.gradle.internal.typeconversion.TypeConversionException;

public class DependencyClassPathNotationConverter
implements NotationConverter<DependencyFactoryInternal.ClassPathNotation, SelfResolvingDependency> {
    private final ClassPathRegistry classPathRegistry;
    private final Instantiator instantiator;
    private final FileCollectionFactory fileCollectionFactory;
    private final RuntimeShadedJarFactory runtimeShadedJarFactory;
    private final CurrentGradleInstallation currentGradleInstallation;
    private final ConcurrentMap<DependencyFactoryInternal.ClassPathNotation, SelfResolvingDependency> internCache = new ConcurrentHashMap<DependencyFactoryInternal.ClassPathNotation, SelfResolvingDependency>();

    public DependencyClassPathNotationConverter(Instantiator instantiator, ClassPathRegistry classPathRegistry, FileCollectionFactory fileCollectionFactory, RuntimeShadedJarFactory runtimeShadedJarFactory, CurrentGradleInstallation currentGradleInstallation) {
        this.instantiator = instantiator;
        this.classPathRegistry = classPathRegistry;
        this.fileCollectionFactory = fileCollectionFactory;
        this.runtimeShadedJarFactory = runtimeShadedJarFactory;
        this.currentGradleInstallation = currentGradleInstallation;
    }

    public void describe(DiagnosticsVisitor visitor) {
        visitor.candidate("ClassPathNotation").example("gradleApi()");
    }

    public void convert(DependencyFactoryInternal.ClassPathNotation notation, NotationConvertResult<? super SelfResolvingDependency> result) throws TypeConversionException {
        SelfResolvingDependency dependency = (SelfResolvingDependency)this.internCache.get(notation);
        if (dependency == null) {
            dependency = this.create(notation);
        }
        result.converted((Object)dependency);
    }

    private SelfResolvingDependency create(final DependencyFactoryInternal.ClassPathNotation notation) {
        boolean runningFromInstallation;
        boolean bl = runningFromInstallation = this.currentGradleInstallation.getInstallation() != null;
        FileCollectionInternal fileCollectionInternal = runningFromInstallation && notation.equals((Object)DependencyFactoryInternal.ClassPathNotation.GRADLE_API) ? this.fileCollectionFactory.create((MinimalFileSet)new GeneratedFileCollection(notation.displayName){

            @Override
            Set<File> generateFileCollection() {
                return DependencyClassPathNotationConverter.this.gradleApiFileCollection(DependencyClassPathNotationConverter.this.getClassPath(notation));
            }
        }) : (runningFromInstallation && notation.equals((Object)DependencyFactoryInternal.ClassPathNotation.GRADLE_TEST_KIT) ? this.fileCollectionFactory.create((MinimalFileSet)new GeneratedFileCollection(notation.displayName){

            @Override
            Set<File> generateFileCollection() {
                return DependencyClassPathNotationConverter.this.gradleTestKitFileCollection(DependencyClassPathNotationConverter.this.getClassPath(notation));
            }
        }) : this.fileCollectionFactory.resolving(this.getClassPath(notation)));
        SelfResolvingDependency dependency = (SelfResolvingDependency)this.instantiator.newInstance(DefaultSelfResolvingDependency.class, new Object[]{new OpaqueComponentIdentifier(notation), fileCollectionInternal});
        SelfResolvingDependency alreadyPresent = this.internCache.putIfAbsent(notation, dependency);
        return alreadyPresent != null ? alreadyPresent : dependency;
    }

    private List<File> getClassPath(DependencyFactoryInternal.ClassPathNotation notation) {
        return Lists.newArrayList((Iterable)this.classPathRegistry.getClassPath(notation.name()).getAsFiles());
    }

    private Set<File> gradleApiFileCollection(Collection<File> apiClasspath) {
        List groovyImpl = this.classPathRegistry.getClassPath(DependencyFactoryInternal.ClassPathNotation.LOCAL_GROOVY.name()).getAsFiles();
        List<File> kotlinImpl = this.kotlinImplFrom(apiClasspath);
        List installationBeacon = this.classPathRegistry.getClassPath("GRADLE_INSTALLATION_BEACON").getAsFiles();
        apiClasspath.removeAll(groovyImpl);
        apiClasspath.removeAll(installationBeacon);
        this.removeKotlin(apiClasspath);
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)this.relocatedDepsJar(apiClasspath, RuntimeShadedJarType.API));
        builder.addAll((Iterable)groovyImpl);
        builder.addAll(kotlinImpl);
        builder.addAll((Iterable)installationBeacon);
        return builder.build();
    }

    private void removeKotlin(Collection<File> apiClasspath) {
        for (File file : new ArrayList<File>(apiClasspath)) {
            String name = file.getName();
            if (!file.getName().contains("kotlin")) continue;
            apiClasspath.remove(file);
        }
    }

    private List<File> kotlinImplFrom(Collection<File> classPath) {
        ArrayList<File> files = new ArrayList<File>();
        for (File file : classPath) {
            String name = file.getName();
            if (!name.startsWith("kotlin-stdlib-") && !name.startsWith("kotlin-reflect-")) continue;
            files.add(file);
        }
        return files;
    }

    private Set<File> gradleTestKitFileCollection(Collection<File> testKitClasspath) {
        List<File> gradleApi = this.getClassPath(DependencyFactoryInternal.ClassPathNotation.GRADLE_API);
        testKitClasspath.removeAll(gradleApi);
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)this.relocatedDepsJar(testKitClasspath, RuntimeShadedJarType.TEST_KIT));
        builder.addAll(this.gradleApiFileCollection(gradleApi));
        return builder.build();
    }

    private File relocatedDepsJar(Collection<File> classpath, RuntimeShadedJarType runtimeShadedJarType) {
        return this.runtimeShadedJarFactory.get(runtimeShadedJarType, classpath);
    }

    static abstract class GeneratedFileCollection
    implements MinimalFileSet {
        private final String displayName;
        private Set<File> generateFiles;

        public GeneratedFileCollection(String notation) {
            this.displayName = notation + " files";
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public Set<File> getFiles() {
            if (this.generateFiles == null) {
                this.generateFiles = this.generateFileCollection();
            }
            return this.generateFiles;
        }

        abstract Set<File> generateFileCollection();
    }
}

