/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project.taskfactory;

import org.gradle.api.Task;
import org.gradle.util.Path;

public final class TaskIdentity<T extends Task> {
    public final Class<T> type;
    public final String name;
    public final Path projectPath;
    public final Path identityPath;
    public final Path buildPath;
    public final long uniqueId;

    TaskIdentity(Class<T> type, String name, Path projectPath, Path identityPath, Path buildPath, long uniqueId) {
        this.name = name;
        this.projectPath = projectPath;
        this.identityPath = identityPath;
        this.buildPath = buildPath;
        this.type = type;
        this.uniqueId = uniqueId;
    }

    public long getId() {
        return this.uniqueId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskIdentity that = (TaskIdentity)o;
        return this.uniqueId == that.uniqueId;
    }

    public int hashCode() {
        return (int)(this.uniqueId ^ this.uniqueId >>> 32);
    }

    public String toString() {
        return "TaskIdentity{path=" + this.identityPath + ", type=" + this.type + ", uniqueId=" + this.uniqueId + '}';
    }

    public String getTaskPath() {
        return this.projectPath.getPath();
    }

    public String getProjectPath() {
        return this.projectPath.getParent().getPath();
    }

    public String getIdentityPath() {
        return this.identityPath.getPath();
    }

    public String getBuildPath() {
        return this.buildPath.getPath();
    }

    public Class<T> getTaskType() {
        return this.type;
    }
}

