/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.declarativedsl.project;

import java.util.List;
import java.util.SortedSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.internal.declarativedsl.evaluationSchema.EvaluationSchemaComponent;
import org.gradle.internal.declarativedsl.mappingToJvm.RuntimeCustomAccessors;
import org.gradle.internal.declarativedsl.mappingToJvm.RuntimeFunctionResolver;
import org.gradle.internal.declarativedsl.mappingToJvm.RuntimePropertyResolver;
import org.gradle.internal.declarativedsl.project.DependencyConfigurations;
import org.gradle.internal.declarativedsl.project.DependencyFunctionsExtractor;
import org.gradle.internal.declarativedsl.project.ImplicitDependencyCollectorFunctionExtractor;
import org.gradle.internal.declarativedsl.project.ImplicitDependencyCollectorFunctionResolver;
import org.gradle.internal.declarativedsl.project.RuntimeDependencyFunctionResolver;
import org.gradle.internal.declarativedsl.schemaBuilder.FunctionExtractor;
import org.gradle.internal.declarativedsl.schemaBuilder.PropertyExtractor;
import org.gradle.internal.declarativedsl.schemaBuilder.TypeDiscovery;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\bH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/gradle/internal/declarativedsl/project/DependencyConfigurationsComponent;", "Lorg/gradle/internal/declarativedsl/evaluationSchema/EvaluationSchemaComponent;", "project", "Lorg/gradle/api/Project;", "(Lorg/gradle/api/Project;)V", "configurations", "Lorg/gradle/internal/declarativedsl/project/DependencyConfigurations;", "functionExtractors", "", "Lorg/gradle/internal/declarativedsl/schemaBuilder/FunctionExtractor;", "runtimeFunctionResolvers", "Lorg/gradle/internal/declarativedsl/mappingToJvm/RuntimeFunctionResolver;", "declarative-dsl-provider"})
public final class DependencyConfigurationsComponent
implements EvaluationSchemaComponent {
    @NotNull
    private final DependencyConfigurations configurations;

    public DependencyConfigurationsComponent(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        SortedSet sortedSet = project.getConfigurations().getNames();
        Intrinsics.checkNotNullExpressionValue((Object)sortedSet, (String)"project.configurations.names");
        this.configurations = new DependencyConfigurations(CollectionsKt.toList((Iterable)sortedSet));
    }

    @Override
    @NotNull
    public List<FunctionExtractor> functionExtractors() {
        Object[] objectArray = new FunctionExtractor[]{new DependencyFunctionsExtractor(this.configurations), new ImplicitDependencyCollectorFunctionExtractor()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    @NotNull
    public List<RuntimeFunctionResolver> runtimeFunctionResolvers() {
        Object[] objectArray = new RuntimeFunctionResolver[]{new RuntimeDependencyFunctionResolver(this.configurations), new ImplicitDependencyCollectorFunctionResolver()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    @NotNull
    public List<TypeDiscovery> typeDiscovery() {
        return EvaluationSchemaComponent.DefaultImpls.typeDiscovery(this);
    }

    @Override
    @NotNull
    public List<PropertyExtractor> propertyExtractors() {
        return EvaluationSchemaComponent.DefaultImpls.propertyExtractors(this);
    }

    @Override
    @NotNull
    public List<RuntimePropertyResolver> runtimePropertyResolvers() {
        return EvaluationSchemaComponent.DefaultImpls.runtimePropertyResolvers(this);
    }

    @Override
    @NotNull
    public List<RuntimeCustomAccessors> runtimeCustomAccessors() {
        return EvaluationSchemaComponent.DefaultImpls.runtimeCustomAccessors(this);
    }
}

