/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.vcs.internal;

import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.initialization.definition.InjectedPluginDependencies;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.vcs.VcsMapping;
import org.gradle.vcs.VersionControlRepository;
import org.gradle.vcs.VersionControlSpec;
import org.gradle.vcs.git.GitVersionControlSpec;

public class DefaultVersionControlRepository
implements VersionControlRepository,
Action<VcsMapping> {
    private final NotationParser<String, ModuleIdentifier> notationParser;
    private final VersionControlSpec spec;
    private final Set<ModuleIdentifier> modules = new HashSet<ModuleIdentifier>();

    @Inject
    public DefaultVersionControlRepository(URI url, NotationParser<String, ModuleIdentifier> notationParser, GitVersionControlSpec spec) {
        this.notationParser = notationParser;
        this.spec = spec;
        spec.setUrl(url);
    }

    public void producesModule(String module) {
        this.modules.add((ModuleIdentifier)this.notationParser.parseNotation((Object)module));
    }

    public String getRootDir() {
        return this.spec.getRootDir();
    }

    public void setRootDir(String rootDir) {
        this.spec.setRootDir(rootDir);
    }

    public void plugins(Action<? super InjectedPluginDependencies> configuration) {
        this.spec.plugins(configuration);
    }

    public void execute(VcsMapping vcsMapping) {
        if (this.modules.isEmpty() || !(vcsMapping.getRequested() instanceof ModuleComponentSelector)) {
            return;
        }
        ModuleComponentSelector moduleSelector = (ModuleComponentSelector)vcsMapping.getRequested();
        if (this.modules.contains(moduleSelector.getModuleIdentifier())) {
            vcsMapping.from(this.spec);
        }
    }

    public Action<VcsMapping> asMappingAction() {
        return this;
    }
}

