/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.toolchain;

import org.gradle.internal.jvm.Jvm;
import org.gradle.jvm.toolchain.JavaLanguageVersion;
import org.gradle.jvm.toolchain.JvmImplementation;
import org.gradle.jvm.toolchain.JvmVendorSpec;

public class DaemonJvmCriteria {
    private final JavaLanguageVersion javaVersion;
    private final JvmVendorSpec vendorSpec;
    private final JvmImplementation jvmImplementation;

    public DaemonJvmCriteria(JavaLanguageVersion javaVersion, JvmVendorSpec vendorSpec, JvmImplementation jvmImplementation) {
        this.javaVersion = javaVersion;
        this.vendorSpec = vendorSpec;
        this.jvmImplementation = jvmImplementation;
    }

    public JavaLanguageVersion getJavaVersion() {
        return this.javaVersion;
    }

    public JvmVendorSpec getVendorSpec() {
        return this.vendorSpec;
    }

    public JvmImplementation getJvmImplementation() {
        return this.jvmImplementation;
    }

    public boolean isCompatibleWith(Jvm other) {
        Integer javaVersionMajor = other.getJavaVersionMajor();
        if (javaVersionMajor == null) {
            return false;
        }
        return this.isCompatibleWith(JavaLanguageVersion.of((int)javaVersionMajor));
    }

    public String toString() {
        return String.format("JVM version '%s'", this.getJavaVersion());
    }

    public boolean isCompatibleWith(JavaLanguageVersion javaVersion) {
        return javaVersion.equals(this.getJavaVersion());
    }
}

