/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.software.internal;

import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.TypeToken;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.initialization.Settings;
import org.gradle.api.internal.plugins.software.SoftwareType;
import org.gradle.api.internal.tasks.properties.InspectionScheme;
import org.gradle.internal.Cast;
import org.gradle.internal.properties.annotations.PropertyMetadata;
import org.gradle.internal.properties.annotations.TypeMetadata;
import org.gradle.internal.properties.annotations.TypeMetadataStore;
import org.gradle.internal.properties.annotations.TypeMetadataWalker;
import org.gradle.plugin.software.internal.DefaultSoftwareTypeImplementation;
import org.gradle.plugin.software.internal.SoftwareTypeImplementation;
import org.gradle.plugin.software.internal.SoftwareTypeRegistry;

public class DefaultSoftwareTypeRegistry
implements SoftwareTypeRegistry {
    private final Map<Class<? extends Plugin<Settings>>, Set<Class<? extends Plugin<Project>>>> pluginClasses = new LinkedHashMap<Class<? extends Plugin<Settings>>, Set<Class<? extends Plugin<Project>>>>();
    private final Map<String, Class<? extends Plugin<Project>>> registeredTypes = new HashMap<String, Class<? extends Plugin<Project>>>();
    private Set<SoftwareTypeImplementation<?>> softwareTypeImplementations;
    private final InspectionScheme inspectionScheme;

    public DefaultSoftwareTypeRegistry(InspectionScheme inspectionScheme) {
        this.inspectionScheme = inspectionScheme;
    }

    public void register(Class<? extends Plugin<Project>> pluginClass, Class<? extends Plugin<Settings>> registeringPluginClass) {
        if (this.softwareTypeImplementations != null) {
            throw new IllegalStateException("Cannot register a plugin after software types have been discovered");
        }
        this.pluginClasses.computeIfAbsent(registeringPluginClass, k -> new LinkedHashSet()).add(pluginClass);
    }

    private Set<SoftwareTypeImplementation<?>> discoverSoftwareTypeImplementations() {
        ImmutableSet.Builder softwareTypeImplementationsBuilder = ImmutableSet.builder();
        this.pluginClasses.keySet().forEach(registeringPluginClass -> this.pluginClasses.get(registeringPluginClass).forEach(pluginClass -> {
            TypeToken pluginType = TypeToken.of((Class)pluginClass);
            TypeMetadataWalker.typeWalker((TypeMetadataStore)this.inspectionScheme.getMetadataStore(), SoftwareType.class).walk((Object)pluginType, (TypeMetadataWalker.TypeMetadataVisitor)new SoftwareTypeImplementationRecordingVisitor((Class<? extends Plugin<Project>>)pluginClass, (Class<? extends Plugin<Settings>>)registeringPluginClass, this.registeredTypes, (ImmutableSet.Builder<SoftwareTypeImplementation<?>>)softwareTypeImplementationsBuilder));
        }));
        return softwareTypeImplementationsBuilder.build();
    }

    public Set<SoftwareTypeImplementation<?>> getSoftwareTypeImplementations() {
        if (this.softwareTypeImplementations == null) {
            this.softwareTypeImplementations = this.discoverSoftwareTypeImplementations();
        }
        return this.softwareTypeImplementations;
    }

    public boolean isRegistered(Class<? extends Plugin<Project>> pluginClass) {
        return this.pluginClasses.values().stream().anyMatch(registeredPlugins -> registeredPlugins.stream().anyMatch(registeredPlugin -> registeredPlugin.isAssignableFrom(pluginClass)));
    }

    private static class SoftwareTypeImplementationRecordingVisitor
    implements TypeMetadataWalker.StaticMetadataVisitor {
        private final Class<? extends Plugin<Project>> pluginClass;
        private final Class<? extends Plugin<Settings>> registeringPluginClass;
        private final Map<String, Class<? extends Plugin<Project>>> registeredTypes;
        private final ImmutableSet.Builder<SoftwareTypeImplementation<?>> softwareTypeImplementationsBuilder;

        public SoftwareTypeImplementationRecordingVisitor(Class<? extends Plugin<Project>> pluginClass, Class<? extends Plugin<Settings>> registeringPluginClass, Map<String, Class<? extends Plugin<Project>>> registeredTypes, ImmutableSet.Builder<SoftwareTypeImplementation<?>> softwareTypeImplementationsBuilder) {
            this.pluginClass = pluginClass;
            this.registeringPluginClass = registeringPluginClass;
            this.registeredTypes = registeredTypes;
            this.softwareTypeImplementationsBuilder = softwareTypeImplementationsBuilder;
        }

        public void visitRoot(TypeMetadata typeMetadata, TypeToken<?> value) {
        }

        public void visitNested(TypeMetadata typeMetadata, String qualifiedName, PropertyMetadata propertyMetadata, TypeToken<?> value) {
            propertyMetadata.getAnnotation(SoftwareType.class).ifPresent(softwareType -> {
                Class<? extends Plugin<Project>> existingPluginClass = this.registeredTypes.put(softwareType.name(), this.pluginClass);
                if (existingPluginClass != null && existingPluginClass != this.pluginClass) {
                    throw new IllegalArgumentException("Software type '" + softwareType.name() + "' is registered by both '" + this.pluginClass.getName() + "' and '" + existingPluginClass.getName() + "'");
                }
                this.softwareTypeImplementationsBuilder.add(new DefaultSoftwareTypeImplementation(softwareType.name(), SoftwareTypeImplementationRecordingVisitor.publicTypeOf(propertyMetadata, softwareType), (Class)Cast.uncheckedNonnullCast(this.pluginClass), this.registeringPluginClass));
            });
        }

        private static Class<?> publicTypeOf(PropertyMetadata propertyMetadata, SoftwareType softwareType) {
            return softwareType.modelPublicType() == Void.class ? propertyMetadata.getDeclaredType().getRawType() : softwareType.modelPublicType();
        }
    }
}

