/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.problems.internal;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import org.gradle.api.problems.ProblemReporter;
import org.gradle.api.problems.internal.DefaultProblemReporter;
import org.gradle.api.problems.internal.InternalProblemReporter;
import org.gradle.api.problems.internal.InternalProblems;
import org.gradle.api.problems.internal.Problem;
import org.gradle.api.problems.internal.ProblemEmitter;
import org.gradle.internal.operations.CurrentBuildOperationRef;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.problems.buildtree.ProblemStream;

@ServiceScope(value={Scope.BuildTree.class})
public class DefaultProblems
implements InternalProblems {
    private final ProblemStream problemStream;
    private final CurrentBuildOperationRef currentBuildOperationRef;
    private final ProblemEmitter emitter;
    private final InternalProblemReporter internalReporter;
    private final Multimap<Throwable, Problem> problemsForThrowables = Multimaps.synchronizedMultimap((Multimap)HashMultimap.create());

    public DefaultProblems(ProblemEmitter emitter, CurrentBuildOperationRef currentBuildOperationRef) {
        this(emitter, null, currentBuildOperationRef);
    }

    public DefaultProblems(ProblemEmitter emitter) {
        this(emitter, null, CurrentBuildOperationRef.instance());
    }

    public DefaultProblems(ProblemEmitter emitter, ProblemStream problemStream, CurrentBuildOperationRef currentBuildOperationRef) {
        this.emitter = emitter;
        this.problemStream = problemStream;
        this.currentBuildOperationRef = currentBuildOperationRef;
        this.internalReporter = this.createReporter(emitter, problemStream, this.problemsForThrowables);
    }

    @Override
    public ProblemReporter forNamespace(String namespace) {
        if ("org.gradle".equals(namespace)) {
            throw new IllegalStateException("Cannot use org.gradle namespace. Reserved for internal use.");
        }
        return this.createReporter(this.emitter, this.problemStream, this.problemsForThrowables);
    }

    private DefaultProblemReporter createReporter(ProblemEmitter emitter, ProblemStream problemStream, Multimap<Throwable, Problem> problems) {
        return new DefaultProblemReporter(emitter, problemStream, this.currentBuildOperationRef, problems);
    }

    @Override
    public InternalProblemReporter getInternalReporter() {
        return this.internalReporter;
    }

    @Override
    public Multimap<Throwable, Problem> getProblemsForThrowables() {
        return this.problemsForThrowables;
    }
}

