/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.services;

import org.gradle.api.logging.LogLevel;
import org.gradle.internal.logging.LoggingManagerInternal;
import org.gradle.internal.logging.config.LoggingSystemAdapter;
import org.gradle.internal.logging.console.DefaultUserInputReceiver;
import org.gradle.internal.logging.events.OutputEventListener;
import org.gradle.internal.logging.services.DefaultLoggingManagerFactory;
import org.gradle.internal.logging.services.DefaultStyledTextOutputFactory;
import org.gradle.internal.logging.services.TextStreamOutputEventListener;
import org.gradle.internal.logging.sink.OutputEventListenerManager;
import org.gradle.internal.logging.sink.OutputEventRenderer;
import org.gradle.internal.logging.slf4j.Slf4jLoggingConfigurer;
import org.gradle.internal.logging.source.DefaultStdErrLoggingSystem;
import org.gradle.internal.logging.source.DefaultStdOutLoggingSystem;
import org.gradle.internal.logging.source.JavaUtilLoggingSystem;
import org.gradle.internal.logging.source.NoOpLoggingSystem;
import org.gradle.internal.logging.text.StyledTextOutputFactory;
import org.gradle.internal.service.DefaultServiceRegistry;
import org.gradle.internal.service.Provides;
import org.gradle.internal.service.ServiceRegistrationProvider;
import org.gradle.internal.time.Clock;
import org.gradle.internal.time.Time;

public abstract class LoggingServiceRegistry
extends DefaultServiceRegistry {
    public static final ServiceRegistrationProvider NO_OP = new ServiceRegistrationProvider(){

        @Provides
        OutputEventListener createOutputEventListener() {
            return OutputEventListener.NO_OP;
        }
    };
    private TextStreamOutputEventListener stdoutListener;
    private final DefaultUserInputReceiver userInput = new DefaultUserInputReceiver();
    protected final OutputEventRenderer renderer = this.makeOutputEventRenderer();
    protected final OutputEventListenerManager outputEventListenerManager = new OutputEventListenerManager(this.renderer);

    public static LoggingServiceRegistry newCommandLineProcessLogging() {
        CommandLineLogging loggingServices = new CommandLineLogging();
        LoggingManagerInternal rootLoggingManager = ((DefaultLoggingManagerFactory)loggingServices.get(DefaultLoggingManagerFactory.class)).getRoot();
        rootLoggingManager.captureSystemSources();
        rootLoggingManager.attachSystemOutAndErr();
        return loggingServices;
    }

    public static LoggingServiceRegistry newEmbeddableLogging() {
        return new CommandLineLogging();
    }

    public static LoggingServiceRegistry newNestedLogging() {
        return new NestedLogging();
    }

    @Provides
    protected Clock createTimeProvider() {
        return Time.clock();
    }

    @Provides
    protected StyledTextOutputFactory createStyledTextOutputFactory() {
        return new DefaultStyledTextOutputFactory(this.getStdoutListener(), (Clock)this.get(Clock.class));
    }

    protected TextStreamOutputEventListener getStdoutListener() {
        if (this.stdoutListener == null) {
            this.stdoutListener = new TextStreamOutputEventListener(((OutputEventListenerManager)this.get(OutputEventListenerManager.class)).getBroadcaster());
        }
        return this.stdoutListener;
    }

    @Provides
    protected DefaultLoggingManagerFactory createLoggingManagerFactory() {
        OutputEventListener outputEventBroadcaster = this.outputEventListenerManager.getBroadcaster();
        DefaultStdOutLoggingSystem stdout = new DefaultStdOutLoggingSystem(this.getStdoutListener(), (Clock)this.get(Clock.class));
        stdout.setLevel(LogLevel.QUIET);
        DefaultStdErrLoggingSystem stderr = new DefaultStdErrLoggingSystem(new TextStreamOutputEventListener(outputEventBroadcaster), (Clock)this.get(Clock.class));
        stderr.setLevel(LogLevel.ERROR);
        return new DefaultLoggingManagerFactory(this.renderer, new LoggingSystemAdapter(new Slf4jLoggingConfigurer(outputEventBroadcaster)), new JavaUtilLoggingSystem(), stdout, stderr);
    }

    @Provides
    protected OutputEventListener createOutputEventListener(OutputEventListenerManager manager) {
        return manager.getBroadcaster();
    }

    @Provides
    protected OutputEventListenerManager createOutputEventListenerManager() {
        return this.outputEventListenerManager;
    }

    @Provides
    protected DefaultUserInputReceiver createUserInput() {
        return this.userInput;
    }

    protected OutputEventRenderer makeOutputEventRenderer() {
        OutputEventRenderer eventRenderer = new OutputEventRenderer(Time.clock(), this.userInput);
        this.userInput.attachConsole(eventRenderer);
        return eventRenderer;
    }

    private static class NestedLogging
    extends LoggingServiceRegistry {
        private NestedLogging() {
        }

        @Override
        @Provides
        protected DefaultLoggingManagerFactory createLoggingManagerFactory() {
            return new DefaultLoggingManagerFactory(this.renderer, new NoOpLoggingSystem(), new NoOpLoggingSystem(), new NoOpLoggingSystem(), new NoOpLoggingSystem());
        }
    }

    private static class CommandLineLogging
    extends LoggingServiceRegistry {
        private CommandLineLogging() {
        }
    }
}

