/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.bootstrap;

import com.google.common.io.Files;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.agents.AgentInitializer;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.logging.LoggingManagerInternal;
import org.gradle.internal.logging.services.LoggingServiceRegistry;
import org.gradle.internal.nativeintegration.ProcessEnvironment;
import org.gradle.internal.nativeintegration.services.NativeServices;
import org.gradle.internal.remote.Address;
import org.gradle.internal.serialize.kryo.KryoBackedDecoder;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.stream.EncodedStream;
import org.gradle.launcher.bootstrap.EntryPoint;
import org.gradle.launcher.bootstrap.ExecutionListener;
import org.gradle.launcher.daemon.bootstrap.DaemonStartupCommunication;
import org.gradle.launcher.daemon.configuration.DaemonParameters;
import org.gradle.launcher.daemon.configuration.DaemonServerConfiguration;
import org.gradle.launcher.daemon.configuration.DefaultDaemonServerConfiguration;
import org.gradle.launcher.daemon.context.DaemonContext;
import org.gradle.launcher.daemon.server.Daemon;
import org.gradle.launcher.daemon.server.DaemonLogFile;
import org.gradle.launcher.daemon.server.DaemonProcessState;
import org.gradle.launcher.daemon.server.DaemonStopState;
import org.gradle.launcher.daemon.server.MasterExpirationStrategy;
import org.gradle.launcher.daemon.server.expiry.DaemonExpirationStrategy;
import org.gradle.process.internal.shutdown.ShutdownHooks;

public class DaemonMain
extends EntryPoint {
    private static final Logger LOGGER = Logging.getLogger(DaemonMain.class);
    private PrintStream originalOut;
    private PrintStream originalErr;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doAction(String[] args, ExecutionListener listener) {
        ArrayList<File> additionalClassPath;
        ArrayList<String> startupOpts;
        DaemonParameters.Priority priority;
        String daemonUid;
        NativeServices.NativeServicesMode nativeServicesMode;
        boolean singleUse;
        int periodicCheckIntervalMs;
        int idleTimeoutMs;
        File daemonBaseDir;
        File gradleHomeDir;
        if (args.length != 1) {
            DaemonMain.invalidArgs("Following arguments are required: <gradle-version>");
        }
        KryoBackedDecoder decoder = new KryoBackedDecoder((InputStream)new EncodedStream.EncodedInput(System.in));
        try {
            gradleHomeDir = new File(decoder.readString());
            daemonBaseDir = new File(decoder.readString());
            idleTimeoutMs = decoder.readSmallInt();
            periodicCheckIntervalMs = decoder.readSmallInt();
            singleUse = decoder.readBoolean();
            nativeServicesMode = NativeServices.NativeServicesMode.values()[decoder.readSmallInt()];
            daemonUid = decoder.readString();
            priority = DaemonParameters.Priority.values()[decoder.readSmallInt()];
            int argCount = decoder.readSmallInt();
            startupOpts = new ArrayList<String>(argCount);
            for (int i = 0; i < argCount; ++i) {
                startupOpts.add(decoder.readString());
            }
            int additionalClassPathLength = decoder.readSmallInt();
            additionalClassPath = new ArrayList<File>(additionalClassPathLength);
            for (int i = 0; i < additionalClassPathLength; ++i) {
                additionalClassPath.add(new File(decoder.readString()));
            }
        }
        catch (EOFException e) {
            throw new UncheckedIOException((Throwable)e);
        }
        NativeServices.initializeOnDaemon((File)gradleHomeDir, (NativeServices.NativeServicesMode)NativeServices.NativeServicesMode.fromSystemProperties());
        DefaultDaemonServerConfiguration parameters = new DefaultDaemonServerConfiguration(daemonUid, daemonBaseDir, idleTimeoutMs, periodicCheckIntervalMs, singleUse, priority, startupOpts, nativeServicesMode);
        LoggingServiceRegistry loggingRegistry = LoggingServiceRegistry.newCommandLineProcessLogging();
        LoggingManagerInternal loggingManager = (LoggingManagerInternal)loggingRegistry.newInstance(LoggingManagerInternal.class);
        DaemonProcessState daemonProcessState = new DaemonProcessState((DaemonServerConfiguration)parameters, (ServiceRegistry)loggingRegistry, loggingManager, DefaultClassPath.of(additionalClassPath));
        ServiceRegistry daemonServices = daemonProcessState.getServices();
        File daemonLog = ((DaemonLogFile)daemonServices.get(DaemonLogFile.class)).getFile();
        this.initialiseLogging(loggingManager, daemonLog);
        ProcessEnvironment processEnvironment = (ProcessEnvironment)daemonServices.get(ProcessEnvironment.class);
        processEnvironment.maybeDetachProcess();
        LOGGER.debug("Assuming the daemon was started with following jvm opts: {}", startupOpts);
        ((AgentInitializer)daemonServices.get(AgentInitializer.class)).maybeConfigureInstrumentationAgent();
        Daemon daemon = (Daemon)daemonServices.get(Daemon.class);
        daemon.start();
        try {
            DaemonContext daemonContext = (DaemonContext)daemonServices.get(DaemonContext.class);
            Long pid = daemonContext.getPid();
            this.daemonStarted(pid, daemon.getUid(), daemon.getAddress(), daemonLog);
            DaemonExpirationStrategy expirationStrategy = (DaemonExpirationStrategy)daemonServices.get(MasterExpirationStrategy.class);
            DaemonStopState stopState = daemon.stopOnExpiration(expirationStrategy, parameters.getPeriodicCheckIntervalMs());
            daemonProcessState.stopped(stopState);
        }
        catch (Throwable throwable) {
            CompositeStoppable.stoppable((Object[])new Object[]{daemon, daemonProcessState}).stop();
            throw throwable;
        }
        CompositeStoppable.stoppable((Object[])new Object[]{daemon, daemonProcessState}).stop();
    }

    private static void invalidArgs(String message) {
        System.out.println("USAGE: <gradle version>");
        System.out.println(message);
        System.exit(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void daemonStarted(Long pid, String uid, Address address, File daemonLog) {
        new DaemonStartupCommunication().printDaemonStarted(this.originalOut, pid, uid, address, daemonLog);
        try {
            this.originalOut.close();
            this.originalErr.close();
        }
        finally {
            this.originalOut = null;
            this.originalErr = null;
        }
    }

    protected void initialiseLogging(LoggingManagerInternal loggingManager, File daemonLog) {
        PrintStream result;
        try {
            Files.createParentDirs((File)daemonLog);
            result = new PrintStream((OutputStream)new FileOutputStream(daemonLog), true, "UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create daemon log file", e);
        }
        this.reducePermissionsOnDaemonLog(daemonLog);
        final PrintStream log = result;
        ShutdownHooks.addShutdownHook((Runnable)new Runnable(){

            @Override
            public void run() {
                log.println("Daemon vm is shutting down... The daemon has exited normally or was terminated in response to a user interrupt.");
            }
        });
        this.redirectOutputsAndInput(log);
        loggingManager.attachSystemOutAndErr();
        loggingManager.setLevelInternal(LogLevel.DEBUG);
        loggingManager.start();
    }

    private void reducePermissionsOnDaemonLog(File daemonLog) {
        daemonLog.setReadable(false, false);
        daemonLog.setReadable(true);
        daemonLog.setExecutable(false);
    }

    private void redirectOutputsAndInput(PrintStream printStream) {
        this.originalOut = System.out;
        this.originalErr = System.err;
        System.setOut(printStream);
        System.setErr(printStream);
        System.setIn(new ByteArrayInputStream(new byte[0]));
    }
}

