/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.local.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;
import org.gradle.internal.component.external.model.ImmutableCapabilities;
import org.gradle.internal.component.local.model.LocalComponentArtifactMetadata;
import org.gradle.internal.component.local.model.LocalConfigurationGraphResolveMetadata;
import org.gradle.internal.component.local.model.LocalConfigurationMetadata;
import org.gradle.internal.component.local.model.LocalFileDependencyMetadata;
import org.gradle.internal.component.local.model.LocalVariantMetadata;
import org.gradle.internal.component.local.model.MissingLocalArtifactMetadata;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ExcludeMetadata;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.component.model.LocalOriginDependencyMetadata;
import org.gradle.internal.model.CalculatedValue;
import org.gradle.internal.model.CalculatedValueContainer;
import org.gradle.internal.model.CalculatedValueContainerFactory;

public final class DefaultLocalConfigurationMetadata
implements LocalConfigurationMetadata,
LocalConfigurationGraphResolveMetadata {
    private final String name;
    private final String description;
    private final ComponentIdentifier componentId;
    private final boolean transitive;
    private final boolean visible;
    private final ImmutableSet<String> hierarchy;
    private final ImmutableAttributes attributes;
    private final boolean canBeConsumed;
    private final boolean deprecatedForConsumption;
    private final boolean canBeResolved;
    private final ImmutableCapabilities capabilities;
    private final CalculatedValue<ConfigurationDependencyMetadata> dependencies;
    private final Set<LocalVariantMetadata> variants;
    private final CalculatedValueContainerFactory factory;
    private final CalculatedValue<ImmutableList<LocalComponentArtifactMetadata>> artifacts;

    public DefaultLocalConfigurationMetadata(String name, String description, ComponentIdentifier componentId, boolean visible, boolean transitive, Set<String> hierarchy, ImmutableAttributes attributes, ImmutableCapabilities capabilities, boolean canBeConsumed, boolean deprecatedForConsumption, boolean canBeResolved, CalculatedValue<ConfigurationDependencyMetadata> dependencies, Set<LocalVariantMetadata> variants, CalculatedValueContainerFactory factory, CalculatedValue<ImmutableList<LocalComponentArtifactMetadata>> artifacts) {
        this.name = name;
        this.description = description;
        this.componentId = componentId;
        this.visible = visible;
        this.transitive = transitive;
        this.hierarchy = ImmutableSet.copyOf(hierarchy);
        this.attributes = attributes;
        this.capabilities = capabilities;
        this.canBeConsumed = canBeConsumed;
        this.deprecatedForConsumption = deprecatedForConsumption;
        this.canBeResolved = canBeResolved;
        this.dependencies = dependencies;
        this.variants = variants;
        this.factory = factory;
        this.artifacts = artifacts;
    }

    @Override
    public LocalConfigurationMetadata copyWithTransformedArtifacts(Transformer<LocalComponentArtifactMetadata, LocalComponentArtifactMetadata> artifactTransformer) {
        ImmutableSet.Builder copiedVariants = ImmutableSet.builder();
        for (LocalVariantMetadata oldVariant : this.variants) {
            CalculatedValueContainer newArtifacts = this.factory.create(Describables.of((Object)oldVariant.asDescribable(), (Object)"artifacts"), context -> (ImmutableList)oldVariant.prepareToResolveArtifacts().getArtifacts().stream().map(arg_0 -> ((Transformer)artifactTransformer).transform(arg_0)).collect(ImmutableList.toImmutableList()));
            copiedVariants.add((Object)new LocalVariantMetadata(oldVariant.getName(), oldVariant.getIdentifier(), oldVariant.asDescribable(), oldVariant.getAttributes(), oldVariant.getCapabilities(), (CalculatedValue<ImmutableList<LocalComponentArtifactMetadata>>)newArtifacts));
        }
        CalculatedValueContainer transformedArtifacts = this.factory.create(Describables.of((Object)this.description, (Object)"artifacts"), context -> (ImmutableList)this.prepareToResolveArtifacts().getArtifacts().stream().map(arg_0 -> ((Transformer)artifactTransformer).transform(arg_0)).collect(ImmutableList.toImmutableList()));
        return new DefaultLocalConfigurationMetadata(this.name, this.description, this.componentId, this.visible, this.transitive, (Set<String>)this.hierarchy, this.attributes, this.capabilities, this.canBeConsumed, this.deprecatedForConsumption, this.canBeResolved, this.dependencies, (Set<LocalVariantMetadata>)copiedVariants.build(), this.factory, (CalculatedValue<ImmutableList<LocalComponentArtifactMetadata>>)transformedArtifacts);
    }

    public String toString() {
        return this.asDescribable().getDisplayName();
    }

    @Override
    public DisplayName asDescribable() {
        return Describables.of((Object)this.componentId, (Object)"configuration", (Object)this.name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ImmutableSet<String> getHierarchy() {
        return this.hierarchy;
    }

    @Override
    public boolean isTransitive() {
        return this.transitive;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public ImmutableAttributes getAttributes() {
        return this.attributes;
    }

    public Set<LocalVariantMetadata> getVariants() {
        return this.variants;
    }

    @Override
    public boolean isCanBeConsumed() {
        return this.canBeConsumed;
    }

    @Override
    public boolean isDeprecated() {
        return this.deprecatedForConsumption;
    }

    public List<? extends LocalOriginDependencyMetadata> getDependencies() {
        this.dependencies.finalizeIfNotAlready();
        return ((ConfigurationDependencyMetadata)this.dependencies.get()).dependencies;
    }

    @Override
    public Set<LocalFileDependencyMetadata> getFiles() {
        this.dependencies.finalizeIfNotAlready();
        return ((ConfigurationDependencyMetadata)this.dependencies.get()).files;
    }

    @Override
    public ImmutableList<ExcludeMetadata> getExcludes() {
        this.dependencies.finalizeIfNotAlready();
        return ((ConfigurationDependencyMetadata)this.dependencies.get()).excludes;
    }

    @Override
    public LocalConfigurationMetadata prepareToResolveArtifacts() {
        this.artifacts.finalizeIfNotAlready();
        for (LocalVariantMetadata variant : this.variants) {
            variant.prepareToResolveArtifacts();
        }
        return this;
    }

    public ImmutableList<LocalComponentArtifactMetadata> getArtifacts() {
        return (ImmutableList)this.artifacts.get();
    }

    @Override
    public ComponentArtifactMetadata artifact(IvyArtifactName ivyArtifactName) {
        for (ComponentArtifactMetadata candidate : this.getArtifacts()) {
            if (!candidate.getName().equals(ivyArtifactName)) continue;
            return candidate;
        }
        return new MissingLocalArtifactMetadata(this.componentId, ivyArtifactName);
    }

    @Override
    public ImmutableCapabilities getCapabilities() {
        return this.capabilities;
    }

    @Override
    public boolean isExternalVariant() {
        return false;
    }

    public static class ConfigurationDependencyMetadata {
        public final List<LocalOriginDependencyMetadata> dependencies;
        public final Set<LocalFileDependencyMetadata> files;
        public final ImmutableList<ExcludeMetadata> excludes;

        public ConfigurationDependencyMetadata(List<LocalOriginDependencyMetadata> dependencies, Set<LocalFileDependencyMetadata> files, List<ExcludeMetadata> excludes) {
            this.dependencies = dependencies;
            this.files = files;
            this.excludes = ImmutableList.copyOf(excludes);
        }
    }
}

