/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.model;

import java.util.LinkedList;
import java.util.List;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.internal.component.external.model.VariantMetadataRules;
import org.gradle.internal.component.model.VariantResolveMetadata;

public class VariantAttributesRules {
    private final ImmutableAttributesFactory attributesFactory;
    private final List<VariantMetadataRules.VariantAction<? super AttributeContainer>> actions = new LinkedList<VariantMetadataRules.VariantAction<? super AttributeContainer>>();

    public VariantAttributesRules(ImmutableAttributesFactory attributesFactory) {
        this.attributesFactory = attributesFactory;
    }

    public void addAttributesAction(VariantMetadataRules.VariantAction<? super AttributeContainer> action) {
        this.actions.add(action);
    }

    public ImmutableAttributes execute(VariantResolveMetadata variant, AttributeContainerInternal attributes) {
        AttributeContainerInternal mutable = this.attributesFactory.mutable(attributes);
        for (VariantMetadataRules.VariantAction<? super AttributeContainer> action : this.actions) {
            action.maybeExecute(variant, (AttributeContainer)mutable);
        }
        return mutable.asImmutable();
    }
}

