/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.resolution.failure.describer;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.component.resolution.failure.ResolutionCandidateAssessor;
import org.gradle.internal.component.resolution.failure.describer.AbstractResolutionFailureDescriber;
import org.gradle.internal.component.resolution.failure.exception.ArtifactVariantSelectionException;
import org.gradle.internal.component.resolution.failure.type.IncompatibleMultipleNodeSelectionFailure;

public abstract class InvalidMultipleVariantsFailureDescriber
extends AbstractResolutionFailureDescriber<IncompatibleMultipleNodeSelectionFailure> {
    private static final String INCOMPATIBLE_VARIANTS_PREFIX = "Incompatible variant errors are explained in more detail at ";
    private static final String INCOMPATIBLE_VARIANTS_SECTION = "sub:variant-incompatible";

    public ArtifactVariantSelectionException describeFailure(IncompatibleMultipleNodeSelectionFailure failure, Optional<AttributesSchemaInternal> schema) {
        String msg = this.buildIncompatibleArtifactVariantsFailureMsg(failure);
        List<String> resolutions = this.buildResolutions(this.suggestSpecificDocumentation(INCOMPATIBLE_VARIANTS_PREFIX, INCOMPATIBLE_VARIANTS_SECTION), this.suggestReviewAlgorithm());
        return new ArtifactVariantSelectionException(msg, failure, resolutions);
    }

    private String buildIncompatibleArtifactVariantsFailureMsg(IncompatibleMultipleNodeSelectionFailure failure) {
        StringBuilder sb = new StringBuilder("Multiple incompatible variants of ").append(failure.getRequestedName()).append(" were selected:\n");
        for (ResolutionCandidateAssessor.AssessedCandidate assessedCandidate : failure.getAssessedCandidates()) {
            sb.append("   - Variant ").append(assessedCandidate.getDisplayName()).append(" has attributes ");
            this.formatAttributes(sb, assessedCandidate.getAllCandidateAttributes());
            sb.append("\n");
        }
        return sb.toString();
    }

    private void formatAttributes(StringBuilder sb, ImmutableAttributes attributes) {
        ImmutableSet keySet = attributes.keySet();
        ArrayList sorted = Lists.newArrayList((Iterable)keySet);
        sorted.sort(Comparator.comparing(Attribute::getName));
        boolean space = false;
        sb.append("{");
        for (Attribute attribute : sorted) {
            if (space) {
                sb.append(", ");
            }
            sb.append(attribute.getName()).append("=").append(attributes.getAttribute(attribute));
            space = true;
        }
        sb.append("}");
    }
}

