/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.internal.artifacts.transform.TransformExecutionResult;
import org.gradle.internal.UncheckedException;

public class TransformExecutionResultSerializer {
    private static final String INPUT_FILE_PATH_PREFIX = "i/";
    private static final String OUTPUT_FILE_PATH_PREFIX = "o/";

    public void writeToFile(File target, TransformExecutionResult result) {
        final ArrayList resultFileContents = new ArrayList(result.size());
        result.visitOutputs(new TransformExecutionResult.OutputVisitor(){

            @Override
            public void visitEntireInputArtifact() {
                resultFileContents.add(TransformExecutionResultSerializer.INPUT_FILE_PATH_PREFIX);
            }

            @Override
            public void visitPartOfInputArtifact(String relativePath) {
                resultFileContents.add(TransformExecutionResultSerializer.INPUT_FILE_PATH_PREFIX + relativePath);
            }

            @Override
            public void visitProducedOutput(String relativePath) {
                resultFileContents.add(TransformExecutionResultSerializer.OUTPUT_FILE_PATH_PREFIX + relativePath);
            }
        });
        UncheckedException.unchecked(() -> Files.write(target.toPath(), (Iterable<? extends CharSequence>)resultFileContents, new OpenOption[0]));
    }

    public TransformExecutionResult readResultsFile(File resultsFile) {
        Path transformerResultsPath = resultsFile.toPath();
        try {
            TransformExecutionResult.Builder builder = TransformExecutionResult.builder();
            List<String> paths = Files.readAllLines(transformerResultsPath, StandardCharsets.UTF_8);
            for (String path : paths) {
                if (path.startsWith(OUTPUT_FILE_PATH_PREFIX)) {
                    builder.addProducedOutput(path.substring(2));
                    continue;
                }
                if (path.startsWith(INPUT_FILE_PATH_PREFIX)) {
                    String relativePathString = path.substring(2);
                    if (relativePathString.isEmpty()) {
                        builder.addEntireInputArtifact();
                        continue;
                    }
                    builder.addPartOfInputArtifact(relativePathString);
                    continue;
                }
                throw new IllegalStateException("Cannot parse result path string: " + path);
            }
            return builder.build();
        }
        catch (IOException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }
}

