/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.internal.metadata;

import com.google.common.base.Objects;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.concurrent.NotThreadSafe;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.component.SoftwareComponent;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.component.SoftwareComponentInternal;
import org.gradle.api.publish.internal.metadata.DependencyAttributesValidator;
import org.gradle.api.publish.internal.metadata.EnforcedPlatformPublicationValidator;
import org.gradle.api.publish.internal.validation.PublicationErrorChecker;
import org.gradle.internal.logging.text.TreeFormatter;
import org.jspecify.annotations.Nullable;

@NotThreadSafe
public class InvalidPublicationChecker {
    private static final String DEPENDENCIES_WITHOUT_VERSION_SUPPRESSION = "dependencies-without-versions";
    private static final DocumentationRegistry DOCUMENTATION_REGISTRY = new DocumentationRegistry();
    private final String publicationName;
    private final String taskPath;
    private final BiMap<String, VariantIdentity> variants = HashBiMap.create();
    private final List<String> errors = new ArrayList<String>();
    private final Set<String> explanations = new LinkedHashSet<String>();
    private final Set<String> suppressedValidationErrors;
    private boolean publicationHasVersion = false;
    private boolean publicationHasDependencyOrConstraint = false;

    public InvalidPublicationChecker(String publicationName, String taskPath, Set<String> suppressedValidationErrors) {
        this.publicationName = publicationName;
        this.taskPath = taskPath;
        this.suppressedValidationErrors = suppressedValidationErrors;
    }

    public void checkComponent(SoftwareComponent component) {
        if (component instanceof SoftwareComponentInternal) {
            PublicationErrorChecker.checkForUnpublishableAttributes((SoftwareComponentInternal)component, DOCUMENTATION_REGISTRY);
        }
    }

    public void registerVariant(String name, AttributeContainer attributes, Set<? extends Capability> capabilities) {
        if (attributes.isEmpty()) {
            this.failWith("Variant '" + name + "' must declare at least one attribute.");
        }
        if (this.variants.containsKey((Object)name)) {
            this.failWith("It is invalid to have multiple variants with the same name ('" + name + "')");
        } else {
            VariantIdentity identity = new VariantIdentity(attributes, capabilities);
            if (this.variants.containsValue((Object)identity)) {
                String found = (String)this.variants.inverse().get((Object)identity);
                this.failWith("Variants '" + found + "' and '" + name + "' have the same attributes and capabilities. Please make sure either attributes or capabilities are different.");
            } else {
                this.variants.put((Object)name, (Object)identity);
            }
        }
    }

    private void checkVariantDependencyVersions() {
        if (!this.suppressedValidationErrors.contains(DEPENDENCIES_WITHOUT_VERSION_SUPPRESSION) && this.publicationHasDependencyOrConstraint && !this.publicationHasVersion) {
            this.failWith("Publication only contains dependencies and/or constraints without a version. You should add minimal version information, publish resolved versions (" + DOCUMENTATION_REGISTRY.getDocumentationRecommendationFor("on this", "publishing_maven", "publishing_maven:resolved_dependencies") + ") or reference a platform (" + DOCUMENTATION_REGISTRY.getDocumentationRecommendationFor("platforms", "platforms") + "). Disable this check by adding 'dependencies-without-versions' to the suppressed validations of the " + this.taskPath + " task.");
        }
    }

    public void validateAttributes(String variant, String group, String name, AttributeContainer attributes) {
        for (DependencyAttributesValidator validator : this.dependencyAttributeValidators()) {
            Optional<String> error = validator.validationErrorFor(group, name, attributes);
            error.ifPresent(s -> this.addDependencyValidationError(variant, (String)s, validator.getExplanation(), validator.getSuppressor()));
        }
    }

    public void validate() {
        if (this.variants.isEmpty()) {
            this.failWith("This publication must publish at least one variant");
        }
        this.checkVariantDependencyVersions();
        if (!this.errors.isEmpty()) {
            TreeFormatter formatter = new TreeFormatter();
            formatter.node("Invalid publication '" + this.publicationName + "'");
            formatter.startChildren();
            for (String error : this.errors) {
                formatter.node(error);
            }
            formatter.endChildren();
            for (String explanation : this.explanations) {
                formatter.node(explanation);
            }
            throw new InvalidUserCodeException(formatter.toString());
        }
    }

    private List<DependencyAttributesValidator> dependencyAttributeValidators() {
        EnforcedPlatformPublicationValidator validator = new EnforcedPlatformPublicationValidator();
        if (this.suppressedValidationErrors.contains(validator.getSuppressor())) {
            return Collections.emptyList();
        }
        return Collections.singletonList(validator);
    }

    private void failWith(String message) {
        this.failWith(message, null);
    }

    private void failWith(String message, @Nullable String explanation) {
        this.errors.add(message);
        if (explanation != null) {
            this.explanations.add(explanation);
        }
    }

    public void sawVersion() {
        this.publicationHasVersion = true;
    }

    public void sawDependencyOrConstraint() {
        this.publicationHasDependencyOrConstraint = true;
    }

    public void addDependencyValidationError(String variant, String errorMessage, String genericExplanation, String suppressor) {
        this.failWith("Variant '" + variant + "' " + errorMessage, genericExplanation + this.explainHowToSuppress(suppressor));
    }

    private String explainHowToSuppress(String suppressor) {
        return " If you did this intentionally you can disable this check by adding '" + suppressor + "' to the suppressed validations of the " + this.taskPath + " task. " + DOCUMENTATION_REGISTRY.getDocumentationRecommendationFor("on suppressing validations", "publishing_setup", "sec:suppressing_validation_errors");
    }

    private static final class VariantIdentity {
        private final AttributeContainer attributes;
        private final Set<? extends Capability> capabilities;

        private VariantIdentity(AttributeContainer attributes, Set<? extends Capability> capabilities) {
            this.attributes = attributes;
            this.capabilities = capabilities;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            VariantIdentity that = (VariantIdentity)o;
            return Objects.equal((Object)this.attributes, (Object)that.attributes) && Objects.equal(this.capabilities, that.capabilities);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.attributes, this.capabilities});
        }
    }
}

