/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.services.internal;

import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.internal.provider.AbstractMinimalProvider;
import org.gradle.api.internal.provider.DefaultProperty;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.provider.ValueSanitizer;
import org.gradle.api.internal.provider.ValueSupplier;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.gradle.api.services.BuildServiceRegistry;
import org.gradle.api.services.internal.BuildServiceDetails;
import org.gradle.api.services.internal.BuildServiceRegistryInternal;
import org.gradle.internal.Cast;
import org.gradle.internal.DisplayName;
import org.gradle.internal.service.ServiceLookup;
import org.gradle.internal.state.Managed;
import org.jspecify.annotations.NonNull;

public abstract class BuildServiceProvider<T extends BuildService<P>, P extends BuildServiceParameters>
extends AbstractMinimalProvider<T>
implements Managed {
    static <T> Class<T> getProvidedType(Provider<T> provider) {
        return ((ProviderInternal)provider).getType();
    }

    static BuildServiceProvider<?, ?> asBuildServiceProvider(Provider<? extends BuildService<?>> service) {
        if (service instanceof BuildServiceProvider) {
            return (BuildServiceProvider)((Object)Cast.uncheckedCast(service));
        }
        throw new UnsupportedOperationException("Unexpected provider for a build service: " + service);
    }

    public boolean isImmutable() {
        return true;
    }

    public Object unpackState() {
        throw new UnsupportedOperationException("Build services cannot be serialized.");
    }

    public ValueSupplier.ExecutionTimeValue<? extends T> calculateExecutionTimeValue() {
        return ValueSupplier.ExecutionTimeValue.changingValue((ProviderInternal)this);
    }

    public void maybeStop() {
    }

    public static <P extends BuildServiceParameters, T extends BuildService<P>> void setBuildServiceAsConvention(@NonNull DefaultProperty<T> property, ServiceLookup serviceLookup, String buildServiceName) {
        BuildServiceRegistryInternal buildServiceRegistry = (BuildServiceRegistryInternal)serviceLookup.get(BuildServiceRegistry.class);
        BuildServiceProvider consumer = (BuildServiceProvider)((Object)Cast.uncheckedCast(buildServiceRegistry.consume(buildServiceName, property.getType())));
        property.convention((Provider)consumer);
    }

    public abstract BuildServiceDetails<T, P> getServiceDetails();

    public abstract String getName();

    public abstract @NonNull Class<T> getType();

    public abstract BuildIdentifier getBuildIdentifier();

    public static boolean isSameService(Provider<? extends BuildService<?>> thisProvider, Provider<? extends BuildService<?>> anotherProvider) {
        if (thisProvider == anotherProvider) {
            return true;
        }
        if (!(thisProvider instanceof BuildServiceProvider) || !(anotherProvider instanceof BuildServiceProvider)) {
            return false;
        }
        BuildServiceProvider thisBuildServiceProvider = (BuildServiceProvider)thisProvider;
        BuildServiceProvider otherBuildServiceProvider = (BuildServiceProvider)anotherProvider;
        String thisName = thisBuildServiceProvider.getName();
        String otherName = otherBuildServiceProvider.getName();
        if (!(thisName.isEmpty() || otherName.isEmpty() || thisName.equals(otherName))) {
            return false;
        }
        if (!BuildServiceProvider.isCompatibleServiceType(thisBuildServiceProvider, otherBuildServiceProvider)) {
            return false;
        }
        return thisBuildServiceProvider.getBuildIdentifier().equals(otherBuildServiceProvider.getBuildIdentifier());
    }

    private static boolean isCompatibleServiceType(BuildServiceProvider thisBuildServiceProvider, BuildServiceProvider otherBuildServiceProvider) {
        Class otherType = otherBuildServiceProvider.getType();
        Class thisType = thisBuildServiceProvider.getType();
        return otherType.isAssignableFrom((Class)Cast.uncheckedCast(thisType));
    }

    public ProviderInternal<T> asSupplier(DisplayName owner, Class<? super T> targetType, ValueSanitizer<? super T> sanitizer) {
        String selfTypeName;
        String targetTypeName;
        Class<T> selfType = this.getType();
        if (selfType != null && !targetType.isAssignableFrom(selfType) && (targetTypeName = targetType.getName()).equals(selfTypeName = selfType.getName())) {
            targetTypeName = targetTypeName + " loaded with " + targetType.getClassLoader();
            selfTypeName = selfTypeName + " loaded with " + selfType.getClassLoader();
            throw new IllegalArgumentException(String.format("Cannot set the value of %s of type %s using a provider of type %s.\nThis can be caused by a plugin being applied to two sibling projects and then using a shared build service. To fix this, use `@ServiceReference` or add the problematic plugin with `apply false` to the root build script.", owner.getDisplayName(), targetTypeName, selfTypeName));
        }
        return super.asSupplier(owner, targetType, sanitizer);
    }

    public static interface Listener {
        public static final Listener EMPTY = provider -> {};

        public void beforeGet(BuildServiceProvider<?, ?> var1);
    }
}

