/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.console;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.gradle.internal.logging.console.AnsiContext;
import org.gradle.internal.logging.console.BuildProgressArea;
import org.gradle.internal.logging.console.Cursor;
import org.gradle.internal.logging.console.DefaultRedrawableLabel;
import org.gradle.internal.logging.console.StyledLabel;

public class MultiLineBuildProgressArea
implements BuildProgressArea {
    private final List<DefaultRedrawableLabel> entries = new ArrayList<DefaultRedrawableLabel>(2);
    private final DefaultRedrawableLabel progressBarLabel;
    private final List<StyledLabel> buildProgressLabels = new ArrayList<StyledLabel>();
    private final DefaultRedrawableLabel parkingLabel;
    private final Cursor statusAreaPos = new Cursor();
    private boolean isVisible;
    private boolean isPreviouslyVisible;

    public MultiLineBuildProgressArea() {
        this.progressBarLabel = MultiLineBuildProgressArea.newLabel(0);
        this.entries.add(this.progressBarLabel);
        this.parkingLabel = MultiLineBuildProgressArea.newLabel(-1);
        this.entries.add(this.parkingLabel);
    }

    private static DefaultRedrawableLabel newLabel(int row) {
        return new DefaultRedrawableLabel(Cursor.at(row, 0));
    }

    @Override
    public List<StyledLabel> getBuildProgressLabels() {
        return Collections.unmodifiableList(this.buildProgressLabels);
    }

    @Override
    public StyledLabel getProgressBar() {
        return this.progressBarLabel;
    }

    @Override
    public StyledLabel getCursorParkLine() {
        return this.parkingLabel;
    }

    public Cursor getWritePosition() {
        return this.statusAreaPos;
    }

    public int getHeight() {
        return this.entries.size();
    }

    @Override
    public void resizeBuildProgressTo(int buildProgressLabelCount) {
        int delta = buildProgressLabelCount - this.buildProgressLabels.size();
        if (delta <= 0) {
            return;
        }
        int row = this.parkingLabel.getWritePosition().row;
        this.parkingLabel.scrollDownBy(delta);
        while (delta-- > 0) {
            DefaultRedrawableLabel label = MultiLineBuildProgressArea.newLabel(row--);
            this.entries.add(this.entries.size() - 1, label);
            this.buildProgressLabels.add(label);
        }
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    @Override
    public void setVisible(boolean isVisible) {
        this.isVisible = isVisible;
        for (DefaultRedrawableLabel label : this.entries) {
            label.setVisible(isVisible);
        }
    }

    public boolean isOverlappingWith(Cursor cursor) {
        for (DefaultRedrawableLabel label : this.entries) {
            if (!label.isOverlappingWith(cursor)) continue;
            return true;
        }
        return false;
    }

    public void newLineAdjustment() {
        ++this.statusAreaPos.row;
        for (DefaultRedrawableLabel label : this.entries) {
            label.newLineAdjustment();
        }
    }

    public void redraw(AnsiContext ansi) {
        int newLines = 0 - this.statusAreaPos.row + this.getHeight() - 1;
        if (this.isVisible && newLines > 0) {
            ansi.cursorAt(Cursor.newBottomLeft()).newLines(newLines);
        }
        for (int i = 0; i < this.entries.size(); ++i) {
            int previousLength;
            int currentLength;
            DefaultRedrawableLabel label = this.entries.get(i);
            label.redraw(ansi);
            if (!this.isVisible || newLines <= 0 || i + newLines >= this.entries.size() || (currentLength = label.getWritePosition().col) >= (previousLength = this.entries.get((int)(i + newLines)).getWritePosition().col)) continue;
            ansi.writeAt(label.getWritePosition()).eraseForward();
        }
        if (this.isPreviouslyVisible || this.isVisible) {
            ansi.cursorAt(this.parkCursor());
        }
        this.isPreviouslyVisible = this.isVisible;
    }

    private void scrollBy(int rows) {
        this.statusAreaPos.row -= rows;
        for (DefaultRedrawableLabel label : this.entries) {
            label.scrollBy(rows);
        }
    }

    public void scrollUpBy(int rows) {
        this.scrollBy(-rows);
    }

    public void scrollDownBy(int rows) {
        this.scrollBy(rows);
    }

    private Cursor parkCursor() {
        if (this.isVisible || this.statusAreaPos.row < 0) {
            return Cursor.newBottomLeft();
        }
        return this.statusAreaPos;
    }
}

