/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.gradle.api.Action;
import org.gradle.api.Buildable;
import org.gradle.api.Task;
import org.gradle.api.internal.provider.AbstractProviderWithValue;
import org.gradle.api.internal.provider.ValueSupplier;
import org.gradle.api.internal.tasks.AbstractTaskDependencyResolveContext;
import org.gradle.api.internal.tasks.TaskDependencyContainer;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.internal.tasks.TaskDependencyUtil;
import org.gradle.internal.Factory;
import org.jspecify.annotations.Nullable;

public class BuildableBackedProvider<B extends Buildable & TaskDependencyContainer, T>
extends AbstractProviderWithValue<T> {
    private final B buildable;
    private final Class<T> valueType;
    private final Factory<T> valueFactory;

    public BuildableBackedProvider(B buildable, Class<T> valueType, Factory<T> valueFactory) {
        this.buildable = buildable;
        this.valueType = valueType;
        this.valueFactory = valueFactory;
    }

    @Override
    public @Nullable Class<T> getType() {
        return this.valueType;
    }

    @Override
    public ValueSupplier.ValueProducer getProducer() {
        return new ValueSupplier.ValueProducer(){

            @Override
            public void visitDependencies(TaskDependencyResolveContext context) {
                ((TaskDependencyContainer)BuildableBackedProvider.this.buildable).visitDependencies(context);
            }

            @Override
            public void visitProducerTasks(Action<? super Task> visitor) {
                for (Task dependency : BuildableBackedProvider.this.buildableDependencies()) {
                    visitor.execute((Object)dependency);
                }
            }
        };
    }

    @Override
    public ValueSupplier.ExecutionTimeValue<? extends T> calculateExecutionTimeValue() {
        if (this.hasDependencies()) {
            return ValueSupplier.ExecutionTimeValue.changingValue(this);
        }
        return ValueSupplier.ExecutionTimeValue.fixedValue(this.get());
    }

    private boolean hasDependencies() {
        final AtomicBoolean hasDependency = new AtomicBoolean(false);
        ((TaskDependencyContainer)this.buildable).visitDependencies(new AbstractTaskDependencyResolveContext(){

            @Override
            public void add(Object dependency) {
                hasDependency.set(true);
            }
        });
        return hasDependency.get();
    }

    private Set<? extends Task> buildableDependencies() {
        return TaskDependencyUtil.getDependenciesForInternalUse(this.buildable);
    }

    @Override
    protected ValueSupplier.Value<? extends T> calculateOwnValue(ValueSupplier.ValueConsumer consumer) {
        Object value = this.valueFactory.create();
        if (value == null) {
            throw new NullPointerException("Value factory must not return null");
        }
        return ValueSupplier.Value.of(value);
    }
}

