/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.diagnostics.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.KtDiagnostic;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticWithSource;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.diagnostics.impl.BaseDiagnosticsCollector;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\f2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u001a\u0010 \u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J\u0010\u0010#\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\fH\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R \u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\r\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R(\u0010\u0012\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000f0\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u001e\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0017@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/diagnostics/impl/PendingDiagnosticsCollectorWithSuppress;", "Lorg/jetbrains/kotlin/diagnostics/impl/BaseDiagnosticsCollector;", "rawReporter", "Lorg/jetbrains/kotlin/diagnostics/impl/BaseDiagnosticsCollector$RawReporter;", "<init>", "(Lorg/jetbrains/kotlin/diagnostics/impl/BaseDiagnosticsCollector$RawReporter;)V", "getRawReporter", "()Lorg/jetbrains/kotlin/diagnostics/impl/BaseDiagnosticsCollector$RawReporter;", "pendingDiagnosticsByFilePath", "", "", "", "Lorg/jetbrains/kotlin/diagnostics/KtDiagnostic;", "_diagnosticsByFilePath", "diagnostics", "", "getDiagnostics", "()Ljava/util/List;", "diagnosticsByFilePath", "", "getDiagnosticsByFilePath", "()Ljava/util/Map;", "value", "", "hasErrors", "getHasErrors", "()Z", "report", "", "diagnostic", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticContext;", "checkAndCommitReportsOn", "element", "Lorg/jetbrains/kotlin/AbstractKtSourceElement;", "updateHasErrors", "frontend.common"})
@SourceDebugExtension(value={"SMAP\nPendingDiagnosticsCollectorWithSuppress.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PendingDiagnosticsCollectorWithSuppress.kt\norg/jetbrains/kotlin/diagnostics/impl/PendingDiagnosticsCollectorWithSuppress\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,81:1\n77#2:82\n97#2,5:83\n382#3,7:88\n382#3,7:95\n382#3,7:102\n*S KotlinDebug\n*F\n+ 1 PendingDiagnosticsCollectorWithSuppress.kt\norg/jetbrains/kotlin/diagnostics/impl/PendingDiagnosticsCollectorWithSuppress\n*L\n18#1:82\n18#1:83,5\n29#1:88,7\n34#1:95,7\n50#1:102,7\n*E\n"})
public final class PendingDiagnosticsCollectorWithSuppress
extends BaseDiagnosticsCollector {
    @NotNull
    private final BaseDiagnosticsCollector.RawReporter rawReporter;
    @NotNull
    private final Map<String, List<KtDiagnostic>> pendingDiagnosticsByFilePath;
    @NotNull
    private final Map<String, List<KtDiagnostic>> _diagnosticsByFilePath;
    private boolean hasErrors;

    public PendingDiagnosticsCollectorWithSuppress(@NotNull BaseDiagnosticsCollector.RawReporter rawReporter) {
        Intrinsics.checkNotNullParameter((Object)rawReporter, (String)"rawReporter");
        this.rawReporter = rawReporter;
        this.pendingDiagnosticsByFilePath = new LinkedHashMap();
        this._diagnosticsByFilePath = new LinkedHashMap();
    }

    @Override
    @NotNull
    public BaseDiagnosticsCollector.RawReporter getRawReporter() {
        return this.rawReporter;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<KtDiagnostic> getDiagnostics() {
        void $this$flatMapTo$iv$iv;
        Map<String, List<KtDiagnostic>> $this$flatMap$iv = this._diagnosticsByFilePath;
        boolean $i$f$flatMap = false;
        Map<String, List<KtDiagnostic>> map = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator2 = $this$flatMapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator2.next();
            boolean bl = false;
            Iterable list$iv$iv = (Iterable)it.getValue();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public Map<String, List<KtDiagnostic>> getDiagnosticsByFilePath() {
        return this._diagnosticsByFilePath;
    }

    @Override
    public boolean getHasErrors() {
        return this.hasErrors;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void report(@Nullable KtDiagnostic diagnostic, @NotNull DiagnosticContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (diagnostic != null && !context2.isDiagnosticSuppressed(diagnostic)) {
            String filePath = context2.getContainingFilePath();
            if (filePath == null) {
                Object object;
                void $this$getOrPut$iv;
                Map<String, List<KtDiagnostic>> map = this._diagnosticsByFilePath;
                Object key$iv = null;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    List answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                List diagnostics = (List)object;
                diagnostics.add(diagnostic);
                this.updateHasErrors(diagnostic);
            } else {
                List list;
                Map<String, List<KtDiagnostic>> $this$getOrPut$iv = this.pendingDiagnosticsByFilePath;
                String key$iv = filePath;
                boolean $i$f$getOrPut = false;
                List value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    List answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    list = answer$iv;
                } else {
                    list = value$iv;
                }
                List pendingDiagnostics = list;
                pendingDiagnostics.add((KtDiagnostic)diagnostic);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void checkAndCommitReportsOn(@NotNull AbstractKtSourceElement element, @Nullable DiagnosticContext context2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (this.pendingDiagnosticsByFilePath.isEmpty()) {
            return;
        }
        boolean commitEverything = context2 == null;
        Iterator<Map.Entry<String, List<KtDiagnostic>>> pendingIterator = this.pendingDiagnosticsByFilePath.entrySet().iterator();
        while (pendingIterator.hasNext()) {
            Object object;
            void $this$getOrPut$iv;
            Map.Entry<String, List<KtDiagnostic>> entry = pendingIterator.next();
            String path = entry.getKey();
            List<KtDiagnostic> pendingList = entry.getValue();
            Map<String, List<KtDiagnostic>> map = this._diagnosticsByFilePath;
            String key$iv = path;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            List committedList = (List)object;
            Iterator<KtDiagnostic> iterator2 = pendingList.iterator();
            while (iterator2.hasNext()) {
                KtDiagnostic diagnostic = iterator2.next();
                KtDiagnosticWithSource ktDiagnosticWithSource = diagnostic instanceof KtDiagnosticWithSource ? (KtDiagnosticWithSource)diagnostic : null;
                AbstractKtSourceElement diagnosticElement = ktDiagnosticWithSource != null ? ktDiagnosticWithSource.getElement() : null;
                DiagnosticContext diagnosticContext2 = context2;
                boolean bl = diagnosticContext2 != null ? diagnosticContext2.isDiagnosticSuppressed(diagnostic) : false;
                if (bl) {
                    if (diagnosticElement == null || !Intrinsics.areEqual((Object)diagnosticElement, (Object)element) && (diagnosticElement.getStartOffset() < element.getStartOffset() || diagnosticElement.getEndOffset() > element.getEndOffset())) continue;
                    iterator2.remove();
                    continue;
                }
                if (!Intrinsics.areEqual((Object)diagnosticElement, (Object)element) && !commitEverything) continue;
                iterator2.remove();
                ((Collection)committedList).add(diagnostic);
                this.updateHasErrors(diagnostic);
            }
            if (!pendingList.isEmpty()) continue;
            pendingIterator.remove();
        }
    }

    private final void updateHasErrors(KtDiagnostic diagnostic) {
        this.hasErrors = this.getHasErrors() || diagnostic.getSeverity() == Severity.ERROR;
    }
}

