/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import org.springframework.expression.EvaluationException;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.ast.SpelNodeImpl;
import org.springframework.expression.spel.ast.TypeCode;

public class TypeReference
extends SpelNodeImpl {
    public TypeReference(int pos, SpelNodeImpl qualifiedId) {
        super(pos, qualifiedId);
    }

    public TypedValue getValueInternal(ExpressionState state) throws EvaluationException {
        TypeCode tc;
        String typename = (String)this.children[0].getValueInternal(state).getValue();
        if (typename.indexOf(".") == -1 && Character.isLowerCase(typename.charAt(0)) && (tc = TypeCode.valueOf(typename.toUpperCase())) != TypeCode.OBJECT) {
            return new TypedValue(tc.getType());
        }
        return new TypedValue(state.findType(typename));
    }

    public String toStringAST() {
        StringBuilder sb = new StringBuilder();
        sb.append("T(");
        sb.append(this.getChild(0).toStringAST());
        sb.append(")");
        return sb.toString();
    }
}

