/*
 * Decompiled with CFR 0.152.
 */
package org.grails.encoder;

import java.io.IOException;
import org.grails.charsequences.CharSequences;
import org.grails.encoder.DefaultEncodingStateRegistry;
import org.grails.encoder.EncodedAppender;
import org.grails.encoder.Encoder;
import org.grails.encoder.EncodingState;
import org.grails.encoder.EncodingStateImpl;
import org.grails.encoder.StreamEncodeable;
import org.grails.encoder.StreamingEncoder;

public abstract class AbstractEncodedAppender
implements EncodedAppender {
    private boolean ignoreEncodingState;

    protected abstract void write(EncodingState var1, char[] var2, int var3, int var4) throws IOException;

    protected abstract void write(EncodingState var1, String var2, int var3, int var4) throws IOException;

    protected abstract void appendCharSequence(EncodingState var1, CharSequence var2, int var3, int var4) throws IOException;

    @Override
    public void append(Encoder encoder, EncodingState encodingState, char[] b, int off, int len) throws IOException {
        if (b == null || len <= 0) {
            return;
        }
        if (this.shouldEncode(encoder, encodingState)) {
            EncodingState newEncoders = this.createNewEncodingState(encoder, encodingState);
            if (encoder instanceof StreamingEncoder) {
                ((StreamingEncoder)encoder).encodeToStream(encoder, CharSequences.createCharSequence(b, off, len), 0, len, this, newEncoders);
            } else {
                this.encodeAndWrite(encoder, newEncoders, String.valueOf(b, off, len));
            }
        } else {
            this.write(encodingState, b, off, len);
        }
    }

    protected EncodingState createNewEncodingState(Encoder encoder, EncodingState encodingState) {
        if (encodingState == null) {
            return new EncodingStateImpl(encoder, null);
        }
        return encodingState.appendEncoder(encoder);
    }

    @Override
    public void append(Encoder encoder, EncodingState encodingState, CharSequence str, int off, int len) throws IOException {
        if (str == null || len <= 0) {
            return;
        }
        if (this.shouldEncode(encoder, encodingState)) {
            EncodingState newEncoders = this.createNewEncodingState(encoder, encodingState);
            if (encoder instanceof StreamingEncoder) {
                ((StreamingEncoder)encoder).encodeToStream(encoder, str, off, len, this, newEncoders);
            } else {
                CharSequence source = CharSequences.canUseOriginalForSubSequence(str, off, len) ? str : str.subSequence(off, off + len);
                this.encodeAndWrite(encoder, newEncoders, source);
            }
        } else {
            this.appendCharSequence(encodingState, str, off, off + len);
        }
    }

    @Override
    public void appendEncoded(Encoder encoder, EncodingState encodingState, char[] b, int off, int len) throws IOException {
        this.write(this.createNewEncodingState(encoder, encodingState), b, off, len);
    }

    @Override
    public void appendEncoded(Encoder encoder, EncodingState encodingState, CharSequence str, int off, int len) throws IOException {
        this.appendCharSequence(this.createNewEncodingState(encoder, encodingState), str, off, off + len);
    }

    @Override
    public boolean shouldEncode(Encoder encoderToApply, EncodingState encodingState) {
        return this.ignoreEncodingState || encoderToApply != null && (encodingState == null || this.shouldEncodeWith(encoderToApply, encodingState));
    }

    protected boolean shouldEncodeWith(Encoder encoderToApply, EncodingState encodingState) {
        return DefaultEncodingStateRegistry.shouldEncodeWith(encoderToApply, encodingState);
    }

    protected void encodeAndWrite(Encoder encoder, EncodingState newEncodingState, CharSequence input) throws IOException {
        Object encoded = encoder.encode(input);
        if (encoded != null) {
            String encodedStr = String.valueOf(encoded);
            this.write(newEncodingState, encodedStr, 0, encodedStr.length());
        }
    }

    @Override
    public void append(Encoder encoder, StreamEncodeable streamEncodeable) throws IOException {
        streamEncodeable.encodeTo(this, encoder);
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public boolean isIgnoreEncodingState() {
        return this.ignoreEncodingState;
    }

    @Override
    public void setIgnoreEncodingState(boolean ignoreEncodingState) {
        this.ignoreEncodingState = ignoreEncodingState;
    }
}

