/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jackson.codec;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.micronaut.core.annotation.Internal;
import java.util.EnumMap;
import java.util.Map;

@Internal
public final class JacksonFeatures {
    private final Map<SerializationFeature, Boolean> serializationFeatures = new EnumMap<SerializationFeature, Boolean>(SerializationFeature.class);
    private final Map<DeserializationFeature, Boolean> deserializationFeatures = new EnumMap<DeserializationFeature, Boolean>(DeserializationFeature.class);

    public JacksonFeatures addFeature(SerializationFeature serializationFeature, boolean isEnabled) {
        this.serializationFeatures.put(serializationFeature, isEnabled);
        return this;
    }

    public JacksonFeatures addFeature(DeserializationFeature deserializationFeature, boolean isEnabled) {
        this.deserializationFeatures.put(deserializationFeature, isEnabled);
        return this;
    }

    public Map<SerializationFeature, Boolean> getSerializationFeatures() {
        return this.serializationFeatures;
    }

    public Map<DeserializationFeature, Boolean> getDeserializationFeatures() {
        return this.deserializationFeatures;
    }
}

