/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.ast.groovy.visitor;

import io.micronaut.ast.groovy.config.GroovyConfigurationMetadataBuilder;
import io.micronaut.ast.groovy.visitor.GroovyBeanDefinitionBuilder;
import io.micronaut.ast.groovy.visitor.GroovyClassElement;
import io.micronaut.ast.groovy.visitor.GroovyConstructorElement;
import io.micronaut.ast.groovy.visitor.GroovyEnumElement;
import io.micronaut.ast.groovy.visitor.GroovyFieldElement;
import io.micronaut.ast.groovy.visitor.GroovyMethodElement;
import io.micronaut.ast.groovy.visitor.GroovyParameterElement;
import io.micronaut.ast.groovy.visitor.GroovyVisitorContext;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.ConstructorElement;
import io.micronaut.inject.ast.ElementFactory;
import io.micronaut.inject.ast.FieldElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.ast.PrimitiveElement;
import io.micronaut.inject.ast.beans.BeanElementBuilder;
import java.util.Map;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.SourceUnit;

public class GroovyElementFactory
implements ElementFactory<AnnotatedNode, ClassNode, MethodNode, FieldNode> {
    private final SourceUnit sourceUnit;
    private final CompilationUnit compilationUnit;
    private final GroovyVisitorContext visitorContext;

    public GroovyElementFactory(GroovyVisitorContext groovyVisitorContext) {
        this.visitorContext = groovyVisitorContext;
        this.sourceUnit = groovyVisitorContext.getSourceUnit();
        this.compilationUnit = groovyVisitorContext.getCompilationUnit();
    }

    @NonNull
    public ClassElement newClassElement(@NonNull ClassNode classNode, @NonNull AnnotationMetadata annotationMetadata) {
        if (classNode.isArray()) {
            ClassNode componentType = classNode.getComponentType();
            ClassElement componentElement = this.newClassElement(componentType, annotationMetadata);
            return componentElement.toArray();
        }
        if (ClassHelper.isPrimitiveType((ClassNode)classNode)) {
            return PrimitiveElement.valueOf((String)classNode.getName());
        }
        if (classNode.isEnum()) {
            return new GroovyEnumElement(this.visitorContext, classNode, annotationMetadata);
        }
        return new GroovyClassElement(this.visitorContext, classNode, annotationMetadata);
    }

    @NonNull
    public ClassElement newClassElement(@NonNull ClassNode classNode, @NonNull AnnotationMetadata annotationMetadata, final @NonNull Map<String, ClassElement> resolvedGenerics) {
        if (classNode.isArray()) {
            ClassNode componentType = classNode.getComponentType();
            ClassElement componentElement = this.newClassElement(componentType, annotationMetadata);
            return componentElement.toArray();
        }
        if (ClassHelper.isPrimitiveType((ClassNode)classNode)) {
            return PrimitiveElement.valueOf((String)classNode.getName());
        }
        if (classNode.isEnum()) {
            return new GroovyEnumElement(this.visitorContext, classNode, annotationMetadata){

                @Override
                @NonNull
                public Map<String, ClassElement> getTypeArguments() {
                    if (resolvedGenerics != null) {
                        return resolvedGenerics;
                    }
                    return super.getTypeArguments();
                }
            };
        }
        return new GroovyClassElement(this.visitorContext, classNode, annotationMetadata){

            @Override
            @NonNull
            public Map<String, ClassElement> getTypeArguments() {
                if (resolvedGenerics != null) {
                    return resolvedGenerics;
                }
                return super.getTypeArguments();
            }
        };
    }

    @NonNull
    public MethodElement newMethodElement(ClassElement declaringClass, @NonNull MethodNode method, @NonNull AnnotationMetadata annotationMetadata) {
        if (!(declaringClass instanceof GroovyClassElement)) {
            throw new IllegalArgumentException("Declaring class must be a GroovyClassElement");
        }
        return new GroovyMethodElement((GroovyClassElement)declaringClass, this.visitorContext, method, annotationMetadata);
    }

    @NonNull
    public ClassElement newSourceClassElement(@NonNull ClassNode classNode, @NonNull AnnotationMetadata annotationMetadata) {
        if (classNode.isArray()) {
            ClassNode componentType = classNode.getComponentType();
            ClassElement componentElement = this.newSourceClassElement(componentType, annotationMetadata);
            return componentElement.toArray();
        }
        if (ClassHelper.isPrimitiveType((ClassNode)classNode)) {
            return PrimitiveElement.valueOf((String)classNode.getName());
        }
        if (classNode.isEnum()) {
            return new GroovyEnumElement(this.visitorContext, classNode, annotationMetadata){

                @NonNull
                public BeanElementBuilder addAssociatedBean(@NonNull ClassElement type) {
                    return new GroovyBeanDefinitionBuilder(this, type, new GroovyConfigurationMetadataBuilder(this.sourceUnit, this.compilationUnit), this.visitorContext);
                }
            };
        }
        return new GroovyClassElement(this.visitorContext, classNode, annotationMetadata){

            @NonNull
            public BeanElementBuilder addAssociatedBean(@NonNull ClassElement type) {
                return new GroovyBeanDefinitionBuilder(this, type, new GroovyConfigurationMetadataBuilder(this.sourceUnit, this.compilationUnit), this.visitorContext);
            }
        };
    }

    @NonNull
    public MethodElement newSourceMethodElement(ClassElement declaringClass, @NonNull MethodNode method, @NonNull AnnotationMetadata annotationMetadata) {
        if (!(declaringClass instanceof GroovyClassElement)) {
            throw new IllegalArgumentException("Declaring class must be a GroovyClassElement");
        }
        return new GroovyMethodElement((GroovyClassElement)declaringClass, this.visitorContext, method, annotationMetadata){

            @NonNull
            public BeanElementBuilder addAssociatedBean(@NonNull ClassElement type) {
                return new GroovyBeanDefinitionBuilder(this, type, new GroovyConfigurationMetadataBuilder(GroovyElementFactory.this.sourceUnit, this.compilationUnit), this.visitorContext);
            }
        };
    }

    @NonNull
    public ConstructorElement newConstructorElement(ClassElement declaringClass, @NonNull MethodNode constructor, @NonNull AnnotationMetadata annotationMetadata) {
        if (!(declaringClass instanceof GroovyClassElement)) {
            throw new IllegalArgumentException("Declaring class must be a GroovyClassElement");
        }
        if (!(constructor instanceof ConstructorNode)) {
            throw new IllegalArgumentException("Constructor must be a ConstructorNode");
        }
        return new GroovyConstructorElement((GroovyClassElement)declaringClass, this.visitorContext, (ConstructorNode)constructor, annotationMetadata);
    }

    @NonNull
    public FieldElement newFieldElement(ClassElement declaringClass, @NonNull FieldNode field, @NonNull AnnotationMetadata annotationMetadata) {
        if (!(declaringClass instanceof GroovyClassElement)) {
            throw new IllegalArgumentException("Declaring class must be a GroovyClassElement");
        }
        return new GroovyFieldElement(this.visitorContext, (Variable)field, (AnnotatedNode)field, annotationMetadata);
    }

    @NonNull
    public FieldElement newFieldElement(@NonNull FieldNode field, @NonNull AnnotationMetadata annotationMetadata) {
        return new GroovyFieldElement(this.visitorContext, (Variable)field, (AnnotatedNode)field, annotationMetadata);
    }

    public FieldElement newFieldElement(@NonNull PropertyNode property, @NonNull AnnotationMetadata annotationMetadata) {
        return new GroovyFieldElement(this.visitorContext, (Variable)property, (AnnotatedNode)property, annotationMetadata);
    }

    public ParameterElement newParameterElement(final @NonNull FieldElement field, @NonNull AnnotationMetadata annotationMetadata) {
        if (!(field instanceof GroovyFieldElement)) {
            throw new IllegalArgumentException("Field must be a GroovyFieldElement");
        }
        FieldNode fieldNode = (FieldNode)field.getNativeType();
        return new GroovyParameterElement(null, this.visitorContext, new Parameter(fieldNode.getType(), fieldNode.getName()), annotationMetadata){

            @Override
            @Nullable
            public ClassElement getGenericType() {
                return field.getGenericType();
            }
        };
    }
}

