/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.ast.groovy;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.CompilationUnitAware;
import groovy.transform.Generated;
import groovy.transform.Internal;
import io.micronaut.ast.groovy.TypeElementVisitorTransform;
import io.micronaut.ast.groovy.utils.AstMessageUtils;
import io.micronaut.ast.groovy.visitor.GroovyVisitorContext;
import io.micronaut.ast.groovy.visitor.LoadedVisitor;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.io.service.ServiceDefinition;
import io.micronaut.core.io.service.SoftServiceLoader;
import io.micronaut.core.order.OrderUtil;
import io.micronaut.core.reflect.InstantiationUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.core.version.VersionUtils;
import io.micronaut.inject.visitor.TypeElementVisitor;
import java.beans.Transient;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.codehaus.groovy.transform.ASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;

@GroovyASTTransformation(phase=CompilePhase.INITIALIZATION)
public class TypeElementVisitorStart
implements ASTTransformation,
CompilationUnitAware,
GroovyObject {
    public static final String ELEMENT_VISITORS_PROPERTY = "micronaut.element.visitors";
    private CompilationUnit compilationUnit;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public TypeElementVisitorStart() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public void visit(ASTNode[] nodes, SourceUnit source) {
        Map loadedVisitors = TypeElementVisitorTransform.loadedVisitors;
        if (loadedVisitors == null) {
            Map map;
            loadedVisitors = map = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
            ModuleNode moduleNode = source.getAST();
            SoftServiceLoader serviceLoader = SoftServiceLoader.load(TypeElementVisitor.class, (ClassLoader)TypeElementVisitorStart.class.getClassLoader());
            ServiceDefinition definition = null;
            Iterator iterator = serviceLoader.iterator();
            while (iterator.hasNext()) {
                definition = (ServiceDefinition)ScriptBytecodeAdapter.castToType(iterator.next(), ServiceDefinition.class);
                if (!definition.isPresent()) continue;
                TypeElementVisitor visitor = (TypeElementVisitor)ScriptBytecodeAdapter.castToType((Object)definition.load(), TypeElementVisitor.class);
                Requires requires = (Requires)ScriptBytecodeAdapter.castToType((Object)visitor.getClass().getAnnotation(Requires.class), Requires.class);
                if (requires != null) {
                    Requires.Sdk sdk = requires.sdk();
                    if (ScriptBytecodeAdapter.compareEqual((Object)sdk, (Object)Requires.Sdk.MICRONAUT)) {
                        String version = requires.version();
                        if (StringUtils.isNotEmpty((CharSequence)version) && !VersionUtils.isAtLeastMicronautVersion((String)version)) {
                            AstMessageUtils.warning(source, (ASTNode)moduleNode, StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"TypeElementVisitor [", (CharSequence)definition.getName()), (CharSequence)"] will be ignored because Micronaut version ["), (CharSequence)VersionUtils.MICRONAUT_VERSION), (CharSequence)"] must be at least "), (CharSequence)version));
                            try {
                                continue;
                            }
                            catch (IllegalArgumentException e) {
                            }
                        }
                    }
                }
                try {
                    LoadedVisitor newLoadedVisitor = new LoadedVisitor(source, this.compilationUnit, visitor);
                    ((HashMap)ScriptBytecodeAdapter.castToType((Object)loadedVisitors, HashMap.class)).put(definition.getName(), newLoadedVisitor);
                }
                catch (TypeNotPresentException e) {
                }
                catch (NoClassDefFoundError e) {
                }
                catch (ClassNotFoundException e) {
                }
            }
            GroovyVisitorContext visitorContext = new GroovyVisitorContext(source, this.compilationUnit);
            ArrayList values = new ArrayList(((LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)loadedVisitors, LinkedHashMap.class)).values());
            OrderUtil.reverseSort(values);
            Object loadedVisitor2 = null;
            for (Object loadedVisitor2 : values) {
                try {
                    ((LoadedVisitor)loadedVisitor2).start(visitorContext);
                }
                catch (Throwable e) {
                    AstMessageUtils.error(source, (ASTNode)moduleNode, ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{((LoadedVisitor)loadedVisitor2).getVisitor(), e.getMessage()}, new String[]{"Error starting type visitor [", "]: ", ""})));
                }
            }
        }
        String val = System.getProperty(ELEMENT_VISITORS_PROPERTY);
        if (DefaultTypeTransformation.booleanUnbox((Object)val)) {
            Object v = null;
            Iterator iterator = DefaultGroovyMethods.iterator((Object)val.split(","));
            while (iterator.hasNext()) {
                v = iterator.next();
                Object visitor = InstantiationUtils.tryInstantiate((String)ShortTypeHandling.castToString(v), (ClassLoader)source.getClassLoader()).orElse(null);
                if (!(visitor instanceof TypeElementVisitor)) continue;
                LoadedVisitor newLoadedVisitor = new LoadedVisitor(source, this.compilationUnit, (TypeElementVisitor)ScriptBytecodeAdapter.castToType(visitor, TypeElementVisitor.class));
                loadedVisitors.put(visitor.getClass().getName(), newLoadedVisitor);
            }
        }
        Map map = loadedVisitors;
        ScriptBytecodeAdapter.setProperty((Object)map, null, TypeElementVisitorTransform.class, (String)"loadedVisitors");
    }

    public void setCompilationUnit(CompilationUnit unit) {
        CompilationUnit compilationUnit;
        this.compilationUnit = compilationUnit = unit;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != TypeElementVisitorStart.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }
}

