/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.hateoas;

import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.MediaType;
import io.micronaut.http.hateoas.DefaultLink;
import java.net.URI;
import java.util.Optional;

public interface Link {
    public static final CharSequence HELP = "help";
    public static final CharSequence SELF = "self";
    public static final CharSequence ABOUT = "about";
    public static final CharSequence HREF = "href";

    public String getHref();

    default public boolean isTemplated() {
        return false;
    }

    default public Optional<MediaType> getType() {
        return Optional.empty();
    }

    default public Optional<String> getDeprecation() {
        return Optional.empty();
    }

    default public Optional<String> getProfile() {
        return Optional.empty();
    }

    default public Optional<String> getName() {
        return Optional.empty();
    }

    default public Optional<String> getTitle() {
        return Optional.empty();
    }

    default public Optional<String> getHreflang() {
        return Optional.empty();
    }

    public static Link of(URI uri) {
        return new DefaultLink(uri.toString());
    }

    public static Link of(String uri) {
        return new DefaultLink(uri);
    }

    public static Builder build(URI uri) {
        return new DefaultLink(uri.toString());
    }

    public static Builder build(String uri) {
        return new DefaultLink(uri);
    }

    public static interface Builder {
        public Builder templated(boolean var1);

        public Builder profile(@Nullable URI var1);

        public Builder profile(@Nullable String var1);

        public Builder deprecation(@Nullable URI var1);

        public Builder deprecation(@Nullable String var1);

        public Builder title(@Nullable String var1);

        public Builder name(@Nullable String var1);

        public Builder hreflang(@Nullable String var1);

        public Builder type(@Nullable MediaType var1);

        public Link build();
    }
}

