/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.qualifiers;

import io.micronaut.context.Qualifier;
import io.micronaut.core.annotation.Internal;
import io.micronaut.inject.BeanType;
import io.micronaut.inject.qualifiers.AnnotationMetadataQualifier;
import io.micronaut.inject.qualifiers.AnnotationStereotypeQualifier;
import java.util.Objects;
import java.util.stream.Stream;

@Internal
final class NamedAnnotationStereotypeQualifier<T>
implements Qualifier<T> {
    final String stereotype;

    NamedAnnotationStereotypeQualifier(String stereotype) {
        this.stereotype = Objects.requireNonNull(stereotype, "Stereotype cannot be null");
    }

    @Override
    public <BT extends BeanType<T>> Stream<BT> reduce(Class<T> beanType, Stream<BT> candidates) {
        return candidates.filter(candidate -> candidate.getAnnotationMetadata().hasStereotype(this.stereotype));
    }

    public String toString() {
        return "@" + this.stereotype;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof NamedAnnotationStereotypeQualifier) {
            NamedAnnotationStereotypeQualifier that = (NamedAnnotationStereotypeQualifier)o;
            return Objects.equals(this.stereotype, that.stereotype);
        }
        if (o instanceof AnnotationStereotypeQualifier) {
            AnnotationStereotypeQualifier that = (AnnotationStereotypeQualifier)o;
            return Objects.equals(this.stereotype, that.stereotype.getName());
        }
        if (o instanceof AnnotationMetadataQualifier) {
            AnnotationMetadataQualifier that = (AnnotationMetadataQualifier)o;
            if (that.qualifierAnn == null) {
                return Objects.equals(this.stereotype, that.qualifiedName);
            }
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.stereotype);
    }
}

