/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.version;

import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.version.SemanticVersion;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Properties;

public class VersionUtils {
    private static final Properties VERSIONS = new Properties();
    public static final String MICRONAUT_VERSION;

    public static boolean isAtLeastMicronautVersion(String requiredVersion) {
        return MICRONAUT_VERSION == null || SemanticVersion.isAtLeast(MICRONAUT_VERSION, requiredVersion);
    }

    @Nullable
    public static String getMicronautVersion() {
        Object micronautVersion = VERSIONS.get("micronaut.version");
        if (micronautVersion != null) {
            return micronautVersion.toString();
        }
        return null;
    }

    static {
        URL resource = VersionUtils.class.getResource("/micronaut-version.properties");
        if (resource != null) {
            try (InputStreamReader reader = new InputStreamReader(resource.openStream(), StandardCharsets.UTF_8);){
                VERSIONS.load(reader);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        MICRONAUT_VERSION = VersionUtils.getMicronautVersion();
    }
}

