/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.ast.groovy.visitor;

import groovy.lang.GroovyClassLoader;
import io.micronaut.ast.groovy.scan.ClassPathAnnotationScanner;
import io.micronaut.ast.groovy.utils.AstAnnotationUtils;
import io.micronaut.ast.groovy.visitor.AbstractGroovyElement;
import io.micronaut.ast.groovy.visitor.GroovyBeanDefinitionBuilder;
import io.micronaut.ast.groovy.visitor.GroovyClassWriterOutputVisitor;
import io.micronaut.ast.groovy.visitor.GroovyElementFactory;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.value.MutableConvertibleValues;
import io.micronaut.core.convert.value.MutableConvertibleValuesMap;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.util.VisitorContextUtils;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.inject.writer.AbstractBeanDefinitionBuilder;
import io.micronaut.inject.writer.ClassWriterOutputVisitor;
import io.micronaut.inject.writer.GeneratedFile;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.ErrorCollector;
import org.codehaus.groovy.control.Janitor;
import org.codehaus.groovy.control.ProcessingUnit;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.messages.Message;
import org.codehaus.groovy.control.messages.SimpleMessage;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.codehaus.groovy.syntax.SyntaxException;

public class GroovyVisitorContext
implements VisitorContext {
    private static final MutableConvertibleValues<Object> VISITOR_ATTRIBUTES = new MutableConvertibleValuesMap();
    private final ErrorCollector errorCollector;
    private final CompilationUnit compilationUnit;
    private final ClassWriterOutputVisitor outputVisitor;
    private final SourceUnit sourceUnit;
    private final MutableConvertibleValues<Object> attributes;
    private final List<String> generatedResources = new ArrayList<String>();
    private final GroovyElementFactory groovyElementFactory;
    private final List<AbstractBeanDefinitionBuilder> beanDefinitionBuilders = new ArrayList<AbstractBeanDefinitionBuilder>();

    public GroovyVisitorContext(SourceUnit sourceUnit, @Nullable CompilationUnit compilationUnit) {
        this(sourceUnit, compilationUnit, new GroovyClassWriterOutputVisitor(compilationUnit));
    }

    public GroovyVisitorContext(SourceUnit sourceUnit, @Nullable CompilationUnit compilationUnit, ClassWriterOutputVisitor outputVisitor) {
        this.sourceUnit = sourceUnit;
        this.errorCollector = sourceUnit != null ? sourceUnit.getErrorCollector() : null;
        this.compilationUnit = compilationUnit;
        this.outputVisitor = outputVisitor;
        this.attributes = VISITOR_ATTRIBUTES;
        this.groovyElementFactory = new GroovyElementFactory(this);
    }

    @NonNull
    public Iterable<URL> getClasspathResources(@NonNull String path) {
        try {
            Enumeration resources = this.compilationUnit.getClassLoader().getResources(path);
            return CollectionUtils.enumerationToIterable((Enumeration)resources);
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
    }

    public Optional<ClassElement> getClassElement(String name) {
        if (name == null || this.compilationUnit == null) {
            return Optional.empty();
        }
        ClassNode classNode = Optional.ofNullable(this.compilationUnit.getClassNode(name)).orElseGet(() -> {
            GroovyClassLoader classLoader;
            if (this.sourceUnit != null && (classLoader = this.sourceUnit.getClassLoader()) != null) {
                return ClassUtils.forName((String)name, (ClassLoader)classLoader).map(ClassHelper::make).orElse(null);
            }
            return null;
        });
        return Optional.ofNullable(classNode).map(cn -> this.groovyElementFactory.newClassElement((ClassNode)cn, AstAnnotationUtils.getAnnotationMetadata(this.sourceUnit, this.compilationUnit, (AnnotatedNode)cn)));
    }

    public Optional<ClassElement> getClassElement(Class<?> type) {
        ClassNode classNode = ClassHelper.makeCached(type);
        AnnotationMetadata annotationMetadata = AstAnnotationUtils.getAnnotationMetadata(this.sourceUnit, this.compilationUnit, (AnnotatedNode)classNode);
        ClassElement classElement = this.groovyElementFactory.newClassElement(classNode, annotationMetadata);
        return Optional.of(classElement);
    }

    @NonNull
    public ClassElement[] getClassElements(@NonNull String aPackage, String ... stereotypes) {
        ArgumentUtils.requireNonNull((String)"aPackage", (Object)aPackage);
        ArgumentUtils.requireNonNull((String)"stereotypes", (Object)stereotypes);
        if (this.compilationUnit == null) {
            return new ClassElement[0];
        }
        ClassPathAnnotationScanner scanner = new ClassPathAnnotationScanner((ClassLoader)this.compilationUnit.getClassLoader());
        ArrayList classElements = new ArrayList();
        for (String s : stereotypes) {
            scanner.scan(s, aPackage).forEach(aClass -> {
                ClassNode classNode = ClassHelper.make((Class)aClass);
                classElements.add(this.groovyElementFactory.newClassElement(classNode, AstAnnotationUtils.getAnnotationMetadata(this.sourceUnit, this.compilationUnit, (AnnotatedNode)classNode)));
            });
        }
        return classElements.toArray(new ClassElement[0]);
    }

    @NonNull
    public GroovyElementFactory getElementFactory() {
        return this.groovyElementFactory;
    }

    public void info(String message, @Nullable Element element) {
        StringBuilder msg = new StringBuilder("Note: ").append(message);
        if (element != null) {
            ASTNode expr = (ASTNode)element.getNativeType();
            String sample = this.sourceUnit.getSample(expr.getLineNumber(), expr.getColumnNumber(), new Janitor());
            msg.append("\n\n").append(sample);
        }
        System.out.println(msg);
    }

    public void info(String message) {
        System.out.println("Note: " + message);
    }

    public void fail(String message, @Nullable Element element) {
        Object msg = element instanceof AbstractGroovyElement ? this.buildErrorMessage(message, element) : new SimpleMessage(message, (ProcessingUnit)this.sourceUnit);
        if (this.errorCollector != null) {
            this.errorCollector.addError((Message)msg);
        }
    }

    public void warn(String message, @Nullable Element element) {
        StringBuilder msg = new StringBuilder("WARNING: ").append(message);
        if (element != null) {
            ASTNode expr = (ASTNode)element.getNativeType();
            String sample = this.sourceUnit.getSample(expr.getLineNumber(), expr.getColumnNumber(), new Janitor());
            msg.append("\n\n").append(sample);
        }
        System.out.println(msg);
    }

    public OutputStream visitClass(String classname, @Nullable Element originatingElement) throws IOException {
        return this.outputVisitor.visitClass(classname, originatingElement);
    }

    public OutputStream visitClass(String classname, Element ... originatingElements) throws IOException {
        return this.outputVisitor.visitClass(classname, originatingElements);
    }

    public void visitServiceDescriptor(String type, String classname) {
        this.outputVisitor.visitServiceDescriptor(type, classname);
    }

    public void visitServiceDescriptor(String type, String classname, Element originatingElement) {
        this.outputVisitor.visitServiceDescriptor(type, classname, originatingElement);
    }

    public Optional<GeneratedFile> visitMetaInfFile(String path, Element ... originatingElements) {
        return this.outputVisitor.visitMetaInfFile(path, originatingElements);
    }

    public Optional<GeneratedFile> visitGeneratedFile(String path) {
        return this.outputVisitor.visitGeneratedFile(path);
    }

    public void finish() {
        this.outputVisitor.finish();
    }

    SourceUnit getSourceUnit() {
        return this.sourceUnit;
    }

    @Internal
    public CompilationUnit getCompilationUnit() {
        return this.compilationUnit;
    }

    public Map<String, String> getOptions() {
        return VisitorContextUtils.getSystemOptions();
    }

    private SyntaxErrorMessage buildErrorMessage(String message, Element element) {
        ASTNode expr = (ASTNode)element.getNativeType();
        return new SyntaxErrorMessage(new SyntaxException(message + '\n', expr.getLineNumber(), expr.getColumnNumber(), expr.getLastLineNumber(), expr.getLastColumnNumber()), this.sourceUnit);
    }

    public MutableConvertibleValues<Object> put(CharSequence key, @Nullable Object value) {
        return this.attributes.put(key, value);
    }

    public MutableConvertibleValues<Object> remove(CharSequence key) {
        return this.attributes.remove(key);
    }

    public MutableConvertibleValues<Object> clear() {
        return this.attributes.clear();
    }

    public Set<String> names() {
        return this.attributes.names();
    }

    public Collection<Object> values() {
        return this.attributes.values();
    }

    public <T> Optional<T> get(CharSequence name, ArgumentConversionContext<T> conversionContext) {
        return this.attributes.get(name, conversionContext);
    }

    public Collection<String> getGeneratedResources() {
        return Collections.unmodifiableCollection(this.generatedResources);
    }

    public void addGeneratedResource(@NonNull String resource) {
        this.generatedResources.add(resource);
    }

    @Internal
    public List<AbstractBeanDefinitionBuilder> getBeanElementBuilders() {
        ArrayList<AbstractBeanDefinitionBuilder> current = new ArrayList<AbstractBeanDefinitionBuilder>(this.beanDefinitionBuilders);
        this.beanDefinitionBuilders.clear();
        return current;
    }

    @Internal
    void addBeanDefinitionBuilder(GroovyBeanDefinitionBuilder groovyBeanDefinitionBuilder) {
        this.beanDefinitionBuilders.add(groovyBeanDefinitionBuilder);
    }
}

